<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#vendor_detail" aria-controls="vendor_detail" aria-selected="true">
			<?= lang('Vendor.vendor_detail'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#mobile-information" aria-controls="mobile-information" aria-selected="false">
			<?= lang('Vendor.vendor_mobile_information'); ?>
		</button>
	</li>
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="vendor_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="vendor_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Vendor.vendor_name"); ?></td>
						<td><?php
							echo (isset($vendor_data['vendor_name']) && $vendor_data['vendor_name'] != "") ? $vendor_data['vendor_name'] : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($vendor_data['created_at']) && isValidDate($vendor_data['created_at'])) ? siteDateFormat($vendor_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($vendor_data['created_by']) && $vendor_data['created_by'] != "") ? $vendor_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($vendor_data['updated_at']) && isValidDate($vendor_data['updated_at'])) ? siteDateFormat($vendor_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($vendor_data['updated_by']) && $vendor_data['updated_by'] != "") ? $vendor_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	<div class="tab-pane fade" id="mobile-information" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="mobile_details_table" class="table table-bordered">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th><?= lang("Vendor.person_name"); ?></th>
						<th><?= lang("Vendor.designation"); ?></th>
						<th><?= lang("Vendor.mobile"); ?></th>
					</tr>
				</thead>
				<tbody class="">
					<?php if ($vendor_mobile_data != '' && array_filter($vendor_mobile_data)) { ?>
						<?php
						$sr = 1;
						foreach ($vendor_mobile_data as $key => $value) { ?>
							<tr>
								<td><?= $sr; ?></td>
								<td><?= $value['vendor_person_name']; ?> </td>
								<td><?= $value['vendor_designation']; ?> </td>
								<td><?= $value['vendor_mobile_no']; ?> </td>
							</tr>
						<?php $sr++;
						}
					} else {   ?>
						<tr>
							<td colspan="4" align="center"> <?= lang('CommonMessage.no_data_found'); ?></td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>

	</div>
</div>