<?php $dtCIAcl = new \App\Libraries\Dt_ci_acl(); ?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Vendor.vendor_form');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_vendor',
				);
				echo form_open_multipart('',$form_id);
				$vendorId = (isset($vendor_data['vendor_id']) && ($vendor_data['vendor_id'] != '')) ? $vendor_data['vendor_id'] : '';
				?>
				<input type="hidden" id="vendor_id" name="vendor_id" value="<?= $vendorId ?>">
				<input type="hidden" id="category_for" name="category_for" value="vendor">
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Vendor.category');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<select data-placeholder="Select  <?= lang('Vendor.category'); ?>" name="category_id[]"
							id="category_id" class="form-control categoryDd" multiple>
						<option></option>
						<?php
						if(isset($vendor_category_data) && !empty($vendor_category_data)) {
							foreach ($vendor_category_data as  $vendorElement){ ?>
								<option  value="<?= isset($vendorElement['category_id']) ? $vendorElement['category_id'] : ""; ?>" selected> <?= $vendorElement['category_name']; ?> </option>
							<?php  }
						} ?>
						</select>
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Vendor.vendor_name');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="vendor_name" id="vendor_name" placeholder="Enter <?= lang('Vendor.vendor_name');?>" value="<?= (isset($vendor_data['vendor_name']) && ($vendor_data['vendor_name'] != '')) ? $vendor_data['vendor_name'] : '';  ?>" />
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Vendor.vendor_mobile');?></label>
					<div class="col-sm-10">
						<?= isset($vendor_mobile_table) ? $vendor_mobile_table : ""; ?>

						<?php if ($dtCIAcl->checkAccess('Vendor|manage')) { ?>
							<button type="button" class="btn btn-xs btn-primary" onclick="addVendorMobile()">
								<i class="ti ti-plus me-1"></i>
								<span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
							</button>
						<?php } ?>
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
					<div class="col-sm-10">
						<label class="switch switch-sm"><span class="switch-label"></span>
							<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($vendor_data['is_active']) || $vendor_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
							<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>

						</label>
					</div>
				</div>

				<div class="pt-4">
					<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
					<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Vendor'); ?>'" class="btn btn-label-secondary">Cancel</button>
				</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
	function vendorMobile() {

		addValidation("input", ".dt-vendor-mobile-no", {
			required: true,
			minlength: 10,
			maxlength: 10,
			messages: {
				required: "Please Enter "+"<?= lang('Vendor.mobile');?>",
			}
		});

		addValidation("input", ".dt-vendor-person-name", {
			required: true,
			messages: {
				required: "Please Enter "+"<?= lang('Vendor.person_name');?>",
			}
		});

		addValidation("input", ".dt-vendor-designation", {
			required: true,
			messages: {
				required: "Please Enter "+"<?= lang('Vendor.designation');?>",
			}
		});
	}
	$(document).ready(function() {
		numberInit();
		categoryDd();
		switcheryKeyGen("datatable-list-switchery");
		addSerialNumber('vendor_mobile_table');
		// Initialize
		var validator = $("#form_vendor").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				vendor_name: {
					required: true,
				},
				'category_id[]' :{
					required: true,
				},
			},
			messages: {
				vendor_name: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Vendor.vendor_name"); ?>',
				},
				'category_id[]' :{
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Vendor.category"); ?>',
				},
			},
			submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Vendor/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Vendor');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Vendor');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
			}
		});

		vendorMobile();
	});
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>

