<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Staff.staff_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_staff',
				);
				echo form_open_multipart('',$form_id);
				$staffId = (isset($staff_data['staff_id']) && ($staff_data['staff_id'] != '')) ? $staff_data['staff_id'] : '';
				$staffTypeGuard = (isset($staff_data['staff_type']) && ($staff_data['staff_type'] != '')) ? $staff_data['staff_type'] : '';
				?>
				<input type="hidden" id="staff_id" name="staff_id" value="<?= $staffId ?>">
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Staff.staff_type');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">

                            <?php if($staffId == ''){ ?>
							<?php
								$staffTypes = staffType();
							?>
							<select data-placeholder="Select  <?= lang('Staff.staff_type'); ?>" name="staff_type"
								id="staff_type" class="select2 form-select dt-staff-type">
								<option value=""> </option>
								<?php
								$selectedStaffType = isset($staff_data['staff_type']) ? $staff_data['staff_type'] : "";
								foreach ($staffTypes as $staffKey => $staffType) { ?>
									<option <?= ($selectedStaffType == $staffKey) ? "selected" : ""; ?>
										value="<?= $staffKey; ?>"> <?= $staffType; ?> </option>
								<?php } ?>
							</select>
                            <?php } else { ?>
                                <select data-placeholder="Select  <?= lang('Staff.staff_type'); ?>" name="staff_type"
                                        id="staff_type" class="select2 form-select dt-staff-type">
                                    <option value=""> </option>
                                    <?php
                                    $selectedStaffType = isset($staff_data['staff_type']) ? $staff_data['staff_type'] : "";
                                    ?>
                                    <option <?= "selected"; ?>  value="<?= $selectedStaffType; ?>"> <?= underscoreToUcWord($selectedStaffType); ?> </option>
                                </select>
                            <?php } ?>
						</div>
					</div>
					<div class="row mb-3 dt-gate">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Staff.gate');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<select data-placeholder="Select  <?= lang('Staff.gate'); ?>" name="gate_id[]"
								id="gate_id" class="form-control gateDd" multiple>
							
							<?php
							if(isset($staff_guard_data) && !empty($staff_guard_data)) {
								foreach ($staff_guard_data as  $staffElement){ ?>
									<option  value="<?= isset($staffElement['gate_id']) ? $staffElement['gate_id'] : ""; ?>" selected> <?= $staffElement['gate_name']; ?> </option>
								<?php  }
							} ?>
							</select>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Staff.staff_name');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="staff_name" id="staff_name" placeholder="Enter <?= lang('Staff.staff_name');?>" value="<?= (isset($staff_data['staff_name']) && ($staff_data['staff_name'] != '')) ? $staff_data['staff_name'] : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Staff.father_name');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="father_name" id="father_name" placeholder="Enter <?= lang('Staff.father_name');?>" value="<?= (isset($staff_data['father_name']) && ($staff_data['father_name'] != '')) ? $staff_data['father_name'] : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Staff.date_of_birth');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="date_of_birth" id="date_of_birth" placeholder="Enter <?= lang('Staff.date_of_birth');?>" value="<?= (isset($staff_data['date_of_birth']) && isValidDate($staff_data['date_of_birth'])) ? siteDateFormat($staff_data['date_of_birth']) : ''; ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Staff.gender');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<div class="form-check form-check-inline mt-3">
								<input class="form-check-input" type="radio" name="gender" id="gender" value="male" <?php if(isset($staff_data['gender']) && $staff_data['gender'] == "male"){ echo "checked";}?> />
								<label class="form-check-label" for="inlineRadio1">Male</label>
							</div>
							<div class="form-check form-check-inline">
								<input
									class="form-check-input" type="radio" name="gender" id="gender" value="female" <?php if(isset($staff_data['gender']) && $staff_data['gender']== "female"){ echo "checked";}?>/>
								<label class="form-check-label" for="inlineRadio2">Female</label>
							</div>
                     		<label id="bio-error" class="validation-invalid-label" for="gender"></label>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Staff.work');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="work" id="work" placeholder="Enter <?= lang('Staff.work');?>" value="<?= (isset($staff_data['work']) && ($staff_data['work'] != '')) ? $staff_data['work'] : '';  ?>" />
						</div>
					</div>
					<?php /*
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('aadhar_card_no');?></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control numberInit" name="aadhar_card_no" id="aadhar_card_no" placeholder="Enter <?= lang('aadhar_card_no');?>" value="<?= (isset($staff_data['aadhar_card_no']) && ($staff_data['aadhar_card_no'] != '')) ? $staff_data['aadhar_card_no'] : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('voter_card_no');?></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="voter_card_no" id="voter_card_no" placeholder="Enter <?= lang('voter_card_no');?>" value="<?= (isset($staff_data['voter_card_no']) && ($staff_data['voter_card_no'] != '')) ? $staff_data['voter_card_no'] : '';  ?>" />
						</div>
					</div>
					*/ ?>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Staff.contact_no');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control numberInit" name="contact_no" id="contact_no" placeholder="Enter <?= lang('Staff.contact_no');?>" value="<?= (isset($staff_data['contact_no']) && ($staff_data['contact_no'] != '')) ? $staff_data['contact_no'] : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Staff.present_address');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<textarea name="present_address"  id="present_address" placeholder="Enter <?= lang('Staff.present_address'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($staff_data['present_address']) && ($staff_data['present_address'] != '')) ? $staff_data['present_address'] : ''; ?></textarea>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Staff.permanent_address');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<textarea name="permanent_address"  id="permanent_address" placeholder="Enter <?= lang('Staff.permanent_address'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($staff_data['permanent_address']) && ($staff_data['permanent_address'] != '')) ? $staff_data['permanent_address'] : ''; ?></textarea>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Staff.reference');?></label>
						<div class="col-sm-10">
							<textarea name="reference"  id="reference" placeholder="Enter <?= lang('Staff.reference'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($staff_data['reference']) && ($staff_data['reference'] != '')) ? $staff_data['reference'] : ''; ?></textarea>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Staff.staff_image');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<input type="file" accept="image/*" class="form-control" name="staff_image[]" multiple="multiple">
							<span class="form-text text-muted"><?= FILE_UPLOAD_TYPE_MSG; ?></span> <br>
							<?php 
		                    if(isset($image_data) && is_array($image_data) && !empty($image_data)){
		                        foreach($image_data as $image) { 
		                        	if(file_exists(STAFF_IMAGE_PATH . $image['staff_image'])){
		                        		$thumbnailPaths = site_url() . THUMBNAIL_STAFF_IMAGE_PATH . $image['staff_image'];
				                        $paths = site_url() . STAFF_IMAGE_PATH . $image['staff_image']; ?> &nbsp;&nbsp;&nbsp;
				                 		<span class="document-image-<?= $image['staff_image_id']; ?>">
				                 			<a href="<?= $paths; ?>" target="_blank"> 
												<img src="<?= $thumbnailPaths; ?>" width="100" class="img-fluid" alt=""> 
												<?php if(!empty($staffId) && $dtCIAcl->checkAccess('Staff|deleteImage')) {?>
													<a href="javascript:void(0);"  id="<?php echo $image['staff_image_id']; ?>" class="btn btn-icon btn-outline-dribbble delete-image"> <i class="tf-icons ti ti-trash"></i> </a> 
												<?php }?>
											</a>
				        				</span>
		            		<?php }} } ?>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Staff.is_outsourced');?></label>
							<div class="col-sm-10">
							<label class="switch switch-sm"><span class="switch-label"></span>
								<input type="checkbox" class="switch-input form-add-switchery"  name="is_outsourced" id="is_outsourced" <?php if(isset($staff_data['is_outsourced']) && $staff_data['is_outsourced'] == 1) {  echo 'checked="checked"'; } else { echo ''; } ?>/>
								<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
								
							</label>						
						</div>
					</div>
					<div class="row mb-3 dt-vendor">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('staff.vendor');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<select id="vendor_id" name="vendor_id" class="select2 form-select form-select-lg vendorDd" data-allow-clear="true">
								<option></option>
								<?php if(isset($staff_data['vendor_id']) && $staff_data['vendor_id'] != 0){ ?>
								<option value="<?= isset($staff_data['vendor_id']) ? $staff_data['vendor_id'] : 0 ?>" selected> <?= isset($staff_data['vendor_name']) ? $staff_data['vendor_name'] : ''  ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
							<div class="col-sm-10">
							<label class="switch switch-sm"><span class="switch-label"></span>
								<input type="checkbox" class="switch-input form-add-switchery is_outsourced"  name="is_active" id="is_active" <?php echo (!isset($staff_data['is_active']) || $staff_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
								<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
								
							</label>						
						</div>
					</div>
					<div class="row mb-3 staff-login">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang("Staff.staff_can_login"); ?></label>
						<div class="col-sm-10">
							<input type="checkbox" class="form-check-input" id="is_login"
										name="is_login" <?= isset($staff_data['is_login']) && $staff_data['is_login'] == 1 ? "checked" : '' ?>
										value="1">			
						</div>
					</div>
					<hr class="my-4 mx-n4" />
					<h6> <?= lang('Staff.staff_document'); ?></h6>
					<div class="row g-3">
						<?= isset($document_table) ? $document_table : ""; ?>
					</div>
					

					
					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1">Submit</button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Staff'); ?>'" class="btn btn-label-secondary">Cancel</button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
    	documentDd();
		gateDd();
		vendorDd();
    	addSerialNumber('document_table');
    	$('.dt-staff-type').select2();
    	$('.document-type').select2();
    	$('#is_outsourced').change();
		switcheryKeyGen("datatable-list-switchery");
		dateDocumentInit();
		// $(".dt-gate").hide();
        // Initialize
		var validator = $("#form_staff").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				staff_name: {
					required: true,
				},
				staff_type : {
					required : true,
				},
				father_name : {
					required : true,
				},
				date_of_birth : {
					required : true,
				},
				gender : {
					required : true,
				},
				work : {
					required : true,
				},
				present_address : {
					required : true,
				},
				permanent_address : {
					required : true,
				},
				// aadhar_card_no: {
				// 	minlength: 12,
				// 	maxlength: 12,
				// },
				contact_no: {
					required : true,
					minlength: 10,
					maxlength: 10,
				},
				"gate_id[]" : {
                    required: "#gate_id:visible",
                },
				vendor_id : {
                    required: "#vendor_id:visible",
                },
				<?php
        		if($staffId == '') { ?>
					"staff_image[]":{
						required : true,
	                },
            	<?php } ?>

            },
            messages: {
				staff_name: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Staff.staff_name"); ?>',
				},
				staff_type : {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Staff.staff_type"); ?>',
				},
				father_name : {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Staff.father_name"); ?>',
				},
				date_of_birth : {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Staff.date_of_birth"); ?>',
				},
				gender : {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Staff.gender"); ?>',
				},
				work : {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Staff.work"); ?>',
				},
				present_address : {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Staff.present_address"); ?>',
				},
				permanent_address : {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Staff.permanent_address"); ?>',
				},
				contact_no: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Staff.contact_no"); ?>',
				},
				"gate_id[]": {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Staff.gate"); ?>',
				},
				vendor_id: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Staff.vendor"); ?>',
				},
				<?php
        		if($staffId == '') { ?>
					"staff_image[]":{
						required : '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Staff.staff_image"); ?>',
	                },
	            <?php } ?>
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Staff/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Visit');?>';
                                }
							});

							setTimeout(function () {
								window.location.href = '<?php echo admin_url('Staff');?>';
							}, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });

        $("#date_of_birth").flatpickr({
			// monthSelectorType: 'static',
			dateFormat: 'd-m-Y'
		});
    });

    $(document).on('click', '.delete-image', function () {
        var deleteId = $(this).attr("id");
		var staffId = $("#staff_id").val();
        Swal.fire({
			title: "<?= ucwords(lang('CommonMessage.common_delete')); ?>",
			text: "<?= lang('CommonMessage.delete_warning'); ?>",
			icon: 'warning',
			showCancelButton: true,
			confirmButtonText: 'OK',
			customClass: {
				confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
				cancelButton: 'btn btn-label-secondary waves-effect waves-light'
			},
			buttonsStyling: false
		}).then(function(result) {
			if (result.value) {

				$("span.document-image-"+deleteId).remove();

		        $.ajax({
		            type: "post",
		            url: "<?= admin_url("Staff/deleteStaffImage")?>",
		            dataType: "json",
		            data: {staff_image_id: deleteId,staff_id:staffId},
		            success: function (data) {
		                if (data['success']) {
		                    $(".delete-image").click(function() {
		                        $(this).parent().remove();
		                    }); 
			                Swal.fire({
								title: 'Success',
								text: data['msg'],
								icon: 'success',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								dt_DataTable.ajax.reload();
							});
		                }
		                else{
		                    Swal.fire({
								title: 'Error!',
								text: data['msg'],
								icon: 'error',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								dt_DataTable.ajax.reload();
							});
		                }
		            }
		        });
		    }
		});
    });

    $(document).on('click', '.module-delete-image', function () {
    	var deleteId = $(this).attr("id");
		var staffId = $("#staff_id").val();
    	Swal.fire({
			title: "<?= ucwords(lang('CommonMessage.common_delete')); ?>",
			text: "<?= lang('CommonMessage.delete_warning'); ?>",
			icon: 'warning',
			showCancelButton: true,
			confirmButtonText: 'OK',
			customClass: {
				confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
				cancelButton: 'btn btn-label-secondary waves-effect waves-light'
			},
			buttonsStyling: false
		}).then(function(result) {
			if (result.value) {
		        $("span.document-remove-image-"+deleteId).remove();
		        $.ajax({
		            type: "post",
		            url: "<?= admin_url("Staff/deleteModuleImage")?>",
		            dataType: "json",
		            data: {module_document_image_id: deleteId,module:"staff",module_id:staffId},
		            success: function (data) {
		                if (data['success']) {
		                    Swal.fire({
								title: 'Success',
								text: data['msg'],
								icon: 'success',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								dt_DataTable.ajax.reload();
							});
		                }
		                else{
		                    Swal.fire({
								title: 'Error!',
								text: data['msg'],
								icon: 'error',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								dt_DataTable.ajax.reload();
							});
		                }
		            }
		        });
		    }
		});
    });

	
	$(document).on('change', '.dt-staff-type', function () {
		var staffType = $(this).val();
		if ((staffType) == 'guard') {
			$(".dt-gate").show();
			$(".staff-login").show();
		} else {
			$(".dt-gate").hide();
			$(".staff-login").hide();
		}
	});

	$(document).on('change', '#is_outsourced', function () {
    var isOutsourced = $(this).prop('checked'); // Check if the checkbox is checked
    console.log(isOutsourced);
    
    if (isOutsourced) {
        $(".dt-vendor").show();
    } else {
        $(".dt-vendor").hide();
    }
});
	
	<?php if(strtolower($staffTypeGuard) == 'guard'){?>
		$(".dt-gate").show();
		$(".staff-login").show();
	<?php } else {?>
		$(".dt-gate").hide();
		$(".staff-login").hide();
	<?php }?>
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
