<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>
<div class="card">
	<div class="card-datatable text-nowrap table-responsive">
		<table id="sos_emergency_table" class="table dt-datatable dt-scrollableTable">
			<thead class="border-top">
			<tr>
                <th class="font-weight-bold"><?= lang("SosEmergency.sos_emergency_id"); ?></th>
				<th class="font-weight-bold"><?= lang("SosEmergency.category_name"); ?></th>
				<th class="font-weight-bold"><?= lang("SosEmergency.status_name"); ?></th>
				<th class="font-weight-bold"><?= lang("SosEmergency.total_notification"); ?></th>
				<th class="font-weight-bold"><?= lang("SosEmergency.total_accept"); ?></th>
				<th class="font-weight-bold"><?= lang("SosEmergency.total_reject"); ?></th>
				<th class="font-weight-bold"><?= lang("SosEmergency.sos_emergency_type"); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_created_at"); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_created_by"); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_updated_at"); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_updated_by"); ?></th>
			</tr>
			</thead>
		</table>
	</div>
</div>
<script type="text/javascript">
	var dt_DataTable;
	$(document).ready(function () {
		dt_DataTable = $('#sos_emergency_table').DataTable( {
			dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
				'<"me-5 ms-n2 pe-5"f>' +
				'<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
				'>t' +
				'<"row mx-2"' +
				'<"col-sm-12 col-md-6"i>' +
				'<"col-sm-12 col-md-6"p>' +
				'>',
			processing: true,
			serverSide: true,
            scrollX: true,
			displayLength: 10,
			language: {
				sLengthMenu: 'Show _MENU_',
				search: '',
				searchPlaceholder: 'Search <?= lang('SosEmergency.sos_emergency');?>',
				info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
			},
			buttons: [
				// {
				// 	extend: 'collection',
				// 	className: 'btn btn-label-secondary px-2 dropdown-toggle me-2 waves-effect waves-light',
				// 	text: '<i class="ti ti-download me-1 ti-xs"></i>Export',
				// 	buttons: [
				// 		// {
				// 		// 	text: '<i class="ti ti-file me-2" ></i>Excel',
				// 		// 	className: 'dropdown-item dt-excel-export'
				// 		// },
				// 		<?php /* if ($dtCIAcl->checkAccess("SosEmergency|pdf")) { ?> {
				// 			extend: 'pdf',
				// 			text: '<i class="ti ti-file-text me-2"></i>Pdf',
				// 			className: 'dropdown-item',
				// 			action: function() {
				// 				window.location.href = '<?= admin_url('SosEmergency/sosPdf'); ?>';
				// 			}
				// 		},
				// 		<?php } */?>
				// 	]
				// },
				<?php /* if ($dtCIAcl->checkAccess("SosEmergency|manage")) { ?>
				{
					text: '<i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('SosEmergency.add_sos');?></span>',
					className: 'add-new btn btn-primary px-1 me-2',
					action: function () {
						window.location.href = '<?= admin_url("SosEmergency/manage");?>';
					}
				},
				<?php } ?>
				<?php if ($dtCIAcl->checkAccess("SosEmergency|delete")) { ?>
				{
					text: '<i class="ti ti-trash me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('SosEmergency.delete_sos');?></span>',
					className: 'btn btn-danger  px-1 dt-delete-record',
				},
				<?php } */?>
			],
			"ajax": {
				"url": "<?php echo admin_url('SosEmergency/getSosEmergencyListing'); ?>",
				"type": "POST",
				"data": function ( d ) {

				}
			},
			"stateSave": true,
			"order": [[ 0, "asc" ]],
			"columns": [
				{
					"data": "sos_emergency_id",
					visible: false,
				},
				{"data": "category_name" },
				{"data": "status_name" },
				{"data": "total_notification" },
				{"data": "total_accept" },
				{"data": "total_reject" },
				{"data": "sos_emergency_type" },
				{"data": "created_at" },
				{"data": "created_by" },
				{"data": "updated_at" },
				{"data": "updated_by" },	
			],
			"columnDefs": [
                {
                    "targets": 0,
                    "width": "10%",
                    "render": function (data, type, row) {
                        return '<label><input type="checkbox" class="dt-checkbox styled" id="ids_' + row['sos_emergency_id'] + '" name="ids[]" value="' + row['sos_emergency_id'] + '"/><span class="lbl"></span></label>';
                    },
                    "sortable": false,
                    "searchable": false
                },
                {
                    "targets": 3,
                    "render": function (data, type, row) {
                        return '<a target="_blank" data-popup="custom-tooltip" title="<?= lang('view_notification') ?>" href="<?= admin_url('Notification?type_id='); ?>'+row['sos_emergency_id']+'&type=sos_emergency">'+data+'</a>';
                    },
                    // "sortable": false,
//                    "searchable": false
                },
                {
                    "targets": 4,
                    "render": function (data, type, row) {
                        return '<a target="_blank" data-popup="custom-tooltip" title="<?= lang('view_notification') ?>" href="<?= admin_url('Notification?type_id='); ?>'+row['sos_emergency_id']+'&action_type=accept&type=sos_emergency">'+data+'</a>';
                    },
                    // "sortable": false,
//                    "searchable": false
                },
                {
                    "targets": 5,
                    "render": function (data, type, row) {
                        return '<a target="_blank" data-popup="custom-tooltip" title="<?= lang('view_notification') ?>" href="<?= admin_url('Notification?type_id='); ?>'+row['sos_emergency_id']+'&action_type=reject&type=sos_emergency">'+data+'</a>';
                    },
                    // "sortable": false,
//                    "searchable": false
                },
            ],
			"fnDrawCallback": function (oSettings, json) {
				customToolTip();
				$('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
				$('.dt-buttons').addClass('d-flex flex-wrap');
				$('.dataTables_filter .form-control').removeClass('form-control-sm');
				$('.dataTables_length .form-select').removeClass('form-select-sm');
				//checkBoxRefresh("datatable-checkbox");
				switcheryKeyGen("datatable-list-switchery");

			}
		});
		dtDataTableSearch();
	});

</script>