<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-header d-flex align-items-center justify-content-between">
                <h5 class="mb-0"><?= lang('Setting.setting_form');?></h5>
            </div>
            <div class="card-body">
                <?php
                //create  form open tag
                $form_id = array(
                    'id'=>'form_setting',
                );
                echo form_open_multipart('',$form_id);
                $settingId = (isset($setting_data['setting_id']) && ($setting_data['setting_id'] != '')) ? $setting_data['setting_id'] : '';
                ?>
                <input type="hidden" id="setting_id" name="setting_id" value="<?= $settingId ?>">
                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Setting.inquiry_email');?><span class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="inquiry_email" id="inquiry_email" placeholder="Enter <?= lang('Setting.inquiry_email');?>" value="<?= (isset($setting_data['inquiry_email']) && ($setting_data['inquiry_email'] != '')) ? $setting_data['inquiry_email'] : '';  ?>" />
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Setting.phone_number');?><span class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="phone_number" id="phone_number" placeholder="Enter <?= lang('Setting.phone_number');?>" value="<?= (isset($setting_data['phone_number']) && ($setting_data['phone_number'] != '')) ? $setting_data['phone_number'] : '';  ?>" />
                    </div>
                </div>


                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Setting.site_title');?><span class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <td>
                            <input type="text"  name="site_title" id="site_title" class="form-control dt-start-date" placeholder="Select <?= lang('Setting.site_title'); ?>" value="<?= isset($setting_data['site_title']) ? YMDToDMY($setting_data['site_title']): ""; ?>"/>
                        </td>
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label"
                           for="basic-default-name"><?= lang('Setting.site_meta_keyword'); ?><span
                                class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <textarea name="site_meta_keyword"  id="site_meta_keyword" placeholder="Enter <?= lang('Setting.site_meta_keyword'); ?>" rows="3" cols="5"  class="form-control site_meta_keyword"><?= (isset($setting_data['site_meta_keyword']) && ($setting_data['site_meta_keyword'] != '')) ? $setting_data['site_meta_keyword'] : ''; ?></textarea>
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label"
                           for="basic-default-name"><?= lang('Setting.site_meta_description'); ?><span
                                class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <textarea name="site_meta_description"  id="site_meta_description" placeholder="Enter <?= lang('Setting.site_meta_description'); ?>" rows="3" cols="5"  class="form-control site_meta_description"><?= (isset($setting_data['site_meta_description']) && ($setting_data['site_meta_description'] != '')) ? $setting_data['site_meta_description'] : ''; ?></textarea>
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Setting.privacy_policy'); ?></label>
                    <div class="col-sm-10">
                        <textarea class="form-control privacy_policy" name="privacy_policy" id="privacy_policy" placeholder="Enter <?= lang('Setting.privacy_policy'); ?>" rows="10" cols="10" class="form-control privacy_policy"><?= (isset($setting_data['privacy_policy']) && ($setting_data['privacy_policy'] != '')) ? $setting_data['privacy_policy'] : ''; ?></textarea>
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Setting.terms_and_condition'); ?></label>
                    <div class="col-sm-10">
                        <textarea class="form-control terms_and_condition" name="terms_and_condition" id="terms_and_condition"  placeholder="Enter <?= lang('Setting.terms_and_condition'); ?>" rows="10" cols="10" class="form-control terms_and_condition"><?= (isset($setting_data['terms_and_condition']) && ($setting_data['terms_and_condition'] != '')) ? $setting_data['terms_and_condition'] : ''; ?></textarea>
                    </div>
                </div>

                <div class="pt-4">
                    <button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
                    <button type="button" onclick="window.location.href='<?php echo admin_url('setting'); ?>'" class="btn btn-label-secondary">Cancel</button>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        numberInit();
        switcheryKeyGen("datatable-list-switchery");
        ckEditorInit('privacy_policy');
        ckEditorInit('terms_and_condition');
        // Initialize
        var validator = $("#form_setting").validate({
            ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
            errorClass: 'validation-invalid-label',
            successClass: 'validation-valid-label',
            validClass: 'validation-valid-label',
            highlight: function(element, errorClass) {
                $(element).removeClass(errorClass);
            },
            unhighlight: function(element, errorClass) {
                $(element).removeClass(errorClass);
            },
            success: function(label) {
                label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
            },
            // Different components require proper error label placement
            errorPlacement: function(error, element) {

                // Unstyled checkboxes, radios
                if (element.parents().hasClass('form-check')) {
                    error.appendTo( element.parents('.form-check').parent() );
                }

                // Input with icons and Select2
                else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
                    error.appendTo( element.parent() );
                }

                // Input group, styled file input
                else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                    error.appendTo( element.parent().parent() );
                }

                // Other elements
                else {
                    error.insertAfter(element);
                }
            },
            rules: {
                inquiry_email: {
                    required: true,
                },
                phone_number: {
                    required: true,
                },
                site_title: {
                    required: true,
                },
                site_meta_keyword: {
                    required: true,
                },
                
                site_meta_description: {
                    required: true,
                }
            },
            messages: {
                inquiry_email: {
                    required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Setting.inquiry_email"); ?>',
                },
                phone_number: {
                    required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Setting.phone_number"); ?>',
                },
                site_title: {
                    required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Setting.site_title"); ?>',
                },
                site_meta_keyword: {
                    required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Setting.site_meta_keyword"); ?>',
                },
                
                site_meta_description: {
                    required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Setting.site_meta_description"); ?>',
                }
            },
            submitHandler: function (e) {
                $(e).ajaxSubmit({
                    url: '<?php echo admin_url("setting/save");?>',
                    type: 'post',
                    beforeSubmit: function (formData, jqForm, options) {
                        dtButtonHide('#submitBtn');
                    },
                    complete: function () {

                    },
                    dataType: 'json',
                    clearForm: false,
                    success: function (resObj, statusText) {
                        if (resObj.success) {
                            toastr.success(resObj.msg, 'Success', {
                                closeButton: true,
                                progressBar: true,
                                positionClass: 'toast-top-right',
                                timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
                                    window.location.href = '<?php echo admin_url('setting');?>';
                                }
                            });

                            // setTimeout(function () {
                            //  window.location.href = '<?php echo admin_url('setting');?>';
                            // }, 1000);

                        } else {
                            dtButtonShow('#submitBtn');
                            toastr.error(resObj.msg, 'Error', {
                                closeButton: true,
                                // progressBar: true,
                                positionClass: 'toast-top-right',
                                // timeOut: 1000
                            });
                        }
                    }
                });
            }
        });
    });
</script>