<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Service.service_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_service',
				);
				echo form_open_multipart('',$form_id);
				$serviceId = (isset($service_data['service_id']) && ($service_data['service_id'] != '')) ? $service_data['service_id'] : '';
				?>
				<input type="hidden" id="service_id" name="service_id" value="<?= $serviceId ?>">
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Service.vendor');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<select id="vendor_id" name="vendor_id" class="select2 form-select form-select-lg vendorDd" data-allow-clear="true">
								<option></option>
								<?php if(isset($service_data['vendor_id']) && $service_data['vendor_id'] != 0){ ?>
								<option value="<?= isset($service_data['vendor_id']) ? $service_data['vendor_id'] : 0 ?>" selected> <?= isset($service_data['vendor_name']) ? $service_data['vendor_name'] : ''  ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Service.service_date_time');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="service_date_time" id="service_date_time" placeholder="Enter <?= lang('Service.service_date_time');?>" value="<?= (isset($service_data['service_date_time']) && isValidDate($service_data['service_date_time'])) ? siteDateFormat($service_data['service_date_time'],true) : ''; ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Service.remarks');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<textarea name="remarks"  id="remarks" placeholder="Enter <?= lang('Service.remarks'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($service_data['remarks']) && ($service_data['remarks'] != '')) ? $service_data['remarks'] : ''; ?></textarea>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
							<div class="col-sm-10">
							<label class="switch switch-sm"><span class="switch-label"></span>
								<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($service_data['is_active']) || $service_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
								<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
								
							</label>
						</div>
					</div>

					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Service'); ?>'" class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
    	vendorDd();
    	itemDd();
		switcheryKeyGen("datatable-list-switchery");

        // Initialize
		var validator = $("#form_service").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				service_date_time : {
					required : true,
				},
				remarks : {
					required : true,
				},
                vendor_id: {
                    required: true,
                },
            },
            messages: {
				service_date_time: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Service.service_date_time');?>"
				},
				remarks: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Service.remarks');?>"
				},
				vendor_id: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Service.vendor');?>"
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Service/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Service');?>';
                                }
							});
							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Service');?>';
							// }, 1000);
						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
        $("#service_date_time").flatpickr({
			// monthSelectorType: 'static',
    		enableTime: true,
    		dateFormat: "d-m-Y H:i",
			// dateFormat: 'd-m-Y'
		});
    });
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
