<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#resource_detail" aria-controls="resource_detail" aria-selected="true">
			<?= lang('Resource.resource_detail'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#working-day-info" aria-controls="working-day-info" aria-selected="false">
			<?= lang('Resource.resource_working_day_information'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#attached-document" aria-controls="attached-document" aria-selected="false">
			<?= lang('Resource.resource_document'); ?>
		</button>
	</li>
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="resource_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="resource_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Resource.resource_type"); ?></td>
						<td><?php
							echo (isset($resource_data['resource_type_name']) && $resource_data['resource_type_name'] != "") ? ($resource_data['resource_type_name']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Resource.gate"); ?></td>
						<td>
							<?php
							if(isset($resource_guard_data) && !empty($resource_guard_data)) {
								echo implode(' , ', array_column($resource_guard_data, 'gate_name'));
							}?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Resource.resource_name"); ?></td>
						<td><?php
							echo (isset($resource_data['resource_name']) && $resource_data['resource_name'] != "") ? $resource_data['resource_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Resource.father_name"); ?></td>
						<td><?php
							echo (isset($resource_data['father_name']) && $resource_data['father_name'] != "") ? $resource_data['father_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Resource.date_of_birth"); ?></td>
						<td><?php
							echo (isset($resource_data['date_of_birth']) && $resource_data['date_of_birth'] != "") ? siteDateFormat($resource_data['date_of_birth']) : '-';
							?></td>
					</tr>
					<tr>
						<td><?= lang("Resource.gender"); ?></td>
						<td><?php
							echo (isset($resource_data['gender']) && $resource_data['gender'] != "") ? underscoreToUcWord($resource_data['gender']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Resource.work"); ?></td>
						<td><?php
							echo (isset($resource_data['work']) && $resource_data['work'] != "") ? $resource_data['work'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Resource.mobile_no"); ?></td>
						<td><?php
							echo (isset($resource_data['resource_mobile_no']) && $resource_data['resource_mobile_no'] != "") ? $resource_data['resource_mobile_no'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Resource.present_address"); ?></td>
						<td><?php
							echo (isset($resource_data['present_address']) && $resource_data['present_address'] != "") ? $resource_data['present_address'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Resource.permanent_address"); ?></td>
						<td><?php
							echo (isset($resource_data['permanent_address']) && $resource_data['permanent_address'] != "") ? $resource_data['permanent_address'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Resource.reference"); ?></td>
						<td><?php
							echo (isset($resource_data['reference']) && $resource_data['reference'] != "") ? $resource_data['reference'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Resource.is_outsourced"); ?></td>
						<td><?php
							echo (isset($resource_data['is_outsourced']) && $resource_data['is_outsourced'] == 1) ? 'Yes' : 'No';
							?>
						</td>
					</tr>
					<?php 
					if($resource_data['is_outsourced'] == 1){ ?> 
						<tr>
							<td><?= lang("Resource.vendor"); ?></td>
							<td><?php
								echo (isset($resource_data['vendor_name']) && $resource_data['vendor_name'] != "") ? $resource_data['vendor_name'] : '-';
								?>
							</td>
						</tr>
					<?php }
					?>
					<tr>
						<td><?= lang("Resource.resource_image"); ?></td>
						<td>
							<?php 
		                    if(isset($image_data) && is_array($image_data) && !empty($image_data)){
		                        foreach($image_data as $image) { 
		                        	if(file_exists(DOCUMENT_IMAGE_PATH . $image['document_image'])){
				                        $paths = site_url() . DOCUMENT_IMAGE_PATH . $image['document_image']; ?> 
				                 		<span class="document-image-<?= $image['document_image_id']; ?>">
				                 			<a href="<?= $paths; ?>" target="_blank"> <img src="<?= $paths; ?>" width="100" class="img-fluid" alt=""> </a>
				        				</span>
		            		<?php }} } ?>
						</td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($resource_data['created_at']) && isValidDate($resource_data['created_at'])) ? siteDateFormat($resource_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($resource_data['created_by']) && $resource_data['created_by'] != "") ? $resource_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($resource_data['updated_at']) && isValidDate($resource_data['updated_at'])) ? siteDateFormat($resource_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($resource_data['updated_by']) && $resource_data['updated_by'] != "") ? $resource_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>

	<div class="tab-pane fade" id="working-day-info" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="working_day_info_table" class="table table-bordered">
				<thead>
					<tr>
						<th class="text-center" style="width: 5%"><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th><?= lang('Resource.flat'); ?></th>
						<th><?= lang('Resource.working_days'); ?></th>
						<th><?= lang('Resource.in_time'); ?></th>
						<th><?= lang('Resource.out_time'); ?></th>
					</tr>
				</thead>
				<tbody class="">
                	<?php if($resource_flat_data != '' && array_filter($resource_flat_data)) {
                    $sr = 1;
                    foreach ($resource_flat_data as $key => $value) { 
						$weekdayData = isset($value['weekday_data']) ? $value['weekday_data'] : array();
						$selectedWeekDayId = array();
						if (!empty($weekdayData)) {
							foreach ($weekdayData as $weekday) {
								$selectedWeekDayId[] = isset($weekday['working_day_id']) ? $weekday['working_day_id'] : "";
							}
						}
						?>
						<tr>
							<td class="text-center"><?= $sr; ?></td>
							<td><?= ($value['tower_flat_name']); ?> </td>
							<td>
								<?php 
									$weekDays = weekDays(); 
									$selectedDays = [];
									foreach ($weekDays as $weekDayElement) {
										if (in_array($weekDayElement['working_day_id'], $selectedWeekDayId)) {
											$selectedDays[] = $weekDayElement['working_day_name'];
										}
									}
									echo implode(', ', $selectedDays);
								?>
							</td>
							<td><?= ($value['resource_in_time']); ?> </td>
							<td><?= ($value['resource_out_time']); ?> </td>
						</tr>
                    <?php $sr++;} }   else {   ?>
						<tr>
							<td colspan="3" align="center"> <?= lang('CommonMessage.no_data_found'); ?></td>
						</tr>
					<?php } ?>
			</tbody>
			</table>
		</div>
	</div>

	<div class="tab-pane fade" id="attached-document" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="document_details_table" class="table table-bordered">
				<thead>
					<tr>
						<th class="text-center" style="width: 5%"><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th style="width: 10%"><?= lang("Staff.document_name"); ?></th>
						<th style="width: 10%"><?= lang("Staff.document_image"); ?></th>
					</tr>
				</thead>
				<tbody class="">
                	<?php if($document_data != '' && array_filter($document_data)) {
                    $sr = 1;
                    foreach ($document_data as $key => $value) { ?>
						<tr>
							<td class="text-center"><?= $sr; ?></td>
                            <td colspan="1"><?= underscoreToUcWord($value['document_name']); ?> </td>
                            <td colspan="1">
							<?php if (isset($value['module_image_data']) && $value['module_image_data'] != '' ) {?>
								<?php
								foreach($value['module_image_data'] as $document){
								$paths = site_url() . DOCUMENT_IMAGE_PATH . $document['document_image'];
								if(file_exists( DOCUMENT_IMAGE_PATH .$document['document_image'])){ ?>
									<a href="<?= $paths; ?>"  target="_blank">
										<img src="<?= $paths; ?>" width="100" height="100" class="img-fluid" alt="">
									</a>
								<?php } } } ?> 
							</td>
						</tr>
                    <?php $sr++;} }  else {   ?>
						<tr>
							<td colspan="3" align="center"> <?= lang('CommonMessage.no_data_found'); ?></td>
						</tr>
					<?php } ?>
			</tbody>
			</table>
		</div>
	</div>
</div>