<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$session = \Config\Services::session();
$resourceView = isset($resource_data['view']) ? $resource_data['view'] : 0;
?>
    <!-- Multi Column with Form Separator -->
    <div class="card mb-4">
        <h5 class="card-header"><?= lang('Resource.man_power_form'); ?>

        </h5>
        <?php
        //create  form open tag
        $form_id = array(
            'id' => 'form_resource',
            'class' => 'card-body',
        );
        echo form_open_multipart('', $form_id);
        $resourceId = (isset($resource_data['resource_id']) && ($resource_data['resource_id'] != '')) ? $resource_data['resource_id'] : '';
        ?>
        <input type="hidden" name="is_login" id="is_login" class='dt-is-login' value="<?= (isset($resource_data['is_login']) && ($resource_data['is_login'] != '')) ? $resource_data['is_login'] : '';  ?>" >
        <input type="hidden" name="group_id" id="group_id" class='dt-group-id' value="<?= (isset($resource_data['group_id']) && ($resource_data['group_id'] != '')) ? $resource_data['group_id'] : '';  ?>" >
        <input type="hidden" name="is_guard" id="is_guard" class='dt-is-guard' value="<?= (isset($resource_data['is_guard']) && ($resource_data['is_guard'] != '')) ? $resource_data['is_guard'] : '';  ?>" >
        <input type="hidden" name="user_society_id" id="user_society_id" class='dt-user-society' value="<?= (isset($resource_data['user_society_id']) && ($resource_data['user_society_id'] != '')) ? $resource_data['user_society_id'] : '';  ?>" >
        <input type="hidden" id="resource_id" name="resource_id" value="<?= $resourceId ?>">
        <!-- <input type="hidden" id="category_for" name="category_for" value="resource"> -->
        <h6>1. <?= lang('Resource.man_power_basic_information') ?></h6>
        <div class="row g-3">

            <div class="col-md-6">
                <label class="form-label" for="basic-default-name"><?= lang('Resource.resource_type');?><span class="text-danger"> *</span></label>
                <select id="resource_type_id" name="resource_type_id" class="select2 form-select form-select-lg dt-resource-type resourceTypeDd" data-allow-clear="true">
                        <option></option>
                        <?php if(isset($resource_data['resource_type_id']) && $resource_data['resource_type_id'] != 0){ ?>
                        <option value="<?= isset($resource_data['resource_type_id']) ? $resource_data['resource_type_id'] : 0 ?>" data-is_login="<?= $resource_data['is_login'] ?? 0 ?>" data-is_guard="<?= $resource_data['is_guard'] ?? 0 ?>" selected> <?= isset($resource_data['resource_type_name']) ? $resource_data['resource_type_name'] : ''  ?> </option>
                        <?php } ?>
                </select>
            </div>

            <div class="col-md-6 dt-gate">
                <label class="form-label" for="basic-default-name"><?= lang('Resource.gate');?><span class="text-danger"> *</span></label>
                <select data-placeholder="Select  <?= lang('Resource.gate'); ?>" name="gate_id[]" id="gate_id" class="form-control gateDd" multiple>
                <?php
                if(isset($resource_guard_data) && !empty($resource_guard_data)) {
                    foreach ($resource_guard_data as  $resourceElement){ ?>
                        <option  value="<?= isset($resourceElement['gate_id']) ? $resourceElement['gate_id'] : ""; ?>" selected> <?= $resourceElement['gate_name']; ?> </option>
                    <?php  }
                } ?>
                </select>
            </div>

            <div class="col-md-6">
                <label class="form-label" for="basic-default-name"><?= lang('Resource.resource_name'); ?><span
                            class="text-danger"> *</span></label>
                <input type="text" class="form-control" name="resource_name" id="resource_name"
                       placeholder="Enter <?= lang('Resource.resource_name'); ?>"
                       value="<?= isset($resource_data['resource_name']) ? $resource_data['resource_name'] : ''; ?>"/>
            </div>


            <div class="col-md-6">
                <label class="form-label" for="basic-default-name"><?= lang('Resource.father_name');?><span class="text-danger"> *</span></label>
                <input type="text" class="form-control" name="father_name" id="father_name" placeholder="Enter <?= lang('Resource.father_name');?>" value="<?= (isset($resource_data['father_name']) && ($resource_data['father_name'] != '')) ? $resource_data['father_name'] : '';  ?>" />
            </div>

            <div class="col-md-6">
                <label class="form-label" for="basic-default-name"><?= lang('Resource.date_of_birth');?><span class="text-danger"> *</span></label>
                <input type="text" class="form-control" name="date_of_birth" id="date_of_birth" placeholder="Enter <?= lang('Resource.date_of_birth');?>" value="<?= (isset($resource_data['date_of_birth']) && isValidDate($resource_data['date_of_birth'])) ? siteDateFormat($resource_data['date_of_birth']) : ''; ?>" /> 
            </div>

            <div class="col-md-6">
                <label class="form-label" for="basic-default-name"><?= lang('Resource.gender');?><span class="text-danger"> *</span></label>
                <br>
                <input class="form-check-input" type="radio" name="gender" id="gender" value="male" <?php if(isset($resource_data['gender']) && $resource_data['gender'] == "male"){ echo "checked";}?> /> <label class="form-check-label" for="inlineRadio1">Male</label>
                <input class="form-check-input" type="radio" name="gender" id="gender" value="female" <?php if(isset($resource_data['gender']) &&     $resource_data['gender']== "female"){ echo "checked";}?>/><label class="form-check-label" for="inlineRadio2">Female</label> 
                <label id="bio-error" class="validation-invalid-label" for="gender"></label>
            </div>

            <div class="col-md-6">
                <label class="form-label" for="basic-default-name"><?= lang('Resource.work');?><span class="text-danger"> *</span></label>
                <input type="text" class="form-control" name="work" id="work" placeholder="Enter <?= lang('Resource.work');?>" value="<?= (isset($resource_data['work']) && ($resource_data['work'] != '')) ? $resource_data['work'] : '';  ?>" />
            </div>
            <div class="col-md-6">
                <label class="form-label"><?= lang('Resource.mobile_no'); ?><span class="text-danger"> *</span></label>
                <input type="tel" class="form-control numberInit" name="resource_mobile_no" id="resource_mobile_no" placeholder="Enter <?= lang('Resource.mobile_no'); ?>" value="<?= isset($resource_data['resource_mobile_no']) ? $resource_data['resource_mobile_no'] : ''; ?>"/>
            </div>
            <div class="col-md-6">
                <label class="form-label" for="basic-default-name"><?= lang('Resource.present_address');?><span class="text-danger"> *</span></label>
                <textarea name="present_address"  id="present_address" placeholder="Enter <?= lang('Resource.present_address'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($resource_data['present_address']) && ($resource_data['present_address'] != '')) ? $resource_data['present_address'] : ''; ?></textarea>     
            </div>

            <div class="col-md-6">
                <label class="form-label" for="basic-default-name"><?= lang('Resource.permanent_address');?><span class="text-danger"> *</span></label>
                <textarea name="permanent_address"  id="permanent_address" placeholder="Enter <?= lang('Resource.permanent_address'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($resource_data['permanent_address']) && ($resource_data['permanent_address'] != '')) ? $resource_data['permanent_address'] : ''; ?></textarea> 
            </div>

            <div class="col-md-6">
                <label class="form-label" for="basic-default-name"><?= lang('Resource.reference');?></label>
                <textarea name="reference"  id="reference" placeholder="Enter <?= lang('Resource.reference'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($resource_data['reference']) && ($resource_data['reference'] != '')) ? $resource_data['reference'] : ''; ?></textarea>
                
            </div>

            <div class="col-md-6">
                <label class="form-label" for="basic-default-name"><?= lang('Resource.man_power_image');?><span class="text-danger"> *</span></label>
                <input type="file" accept="image/*" class="form-control" name="resource_image[]" multiple="multiple">
                <?php 
                if(isset($image_data) && is_array($image_data) && !empty($image_data)){
                    foreach($image_data as $image) { 
                        if(file_exists(DOCUMENT_IMAGE_PATH . $image['document_image'])){
                            $thumbnailPaths = site_url() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $image['document_image'];
                            $paths = site_url() . DOCUMENT_IMAGE_PATH . $image['document_image']; ?> &nbsp;&nbsp;&nbsp;
                            <span class="document-image-<?= $image['document_image_id']; ?>">
                                <a href="<?= $paths; ?>" target="_blank"> 
                                    <img src="<?= $thumbnailPaths; ?>" width="100" class="img-fluid" alt=""> 
                                    <?php if ($resourceView != 1) {?>
                                        <?php if(!empty($resourceId) && $dtCIAcl->checkAccess('Resource|deleteImage')) {?>
                                            <a href="javascript:void(0);"  id="<?php echo $image['document_image_id']; ?>" class="btn btn-icon btn-outline-dribbble delete-image"> <i class="tf-icons ti ti-trash"></i> </a> 
                                        <?php }?>
                                    <?php }?>
                                </a>
                            </span>
                <?php }} } ?>
            </div>

            <div class="col-md-6">
                <label class="form-label" for="basic-default-name"><?= lang('Resource.is_outsourced');?></label><br>
                <label class="switch switch-sm"><span class="switch-label"></span>
                    <input type="checkbox" class="switch-input form-add-switchery"  name="is_outsourced" id="is_outsourced" <?php if(isset($resource_data['is_outsourced']) && $resource_data['is_outsourced'] == 1) {  echo 'checked="checked"'; } else { echo ''; } ?>/>
                    <span class="switch-toggle-slider">
                        <span class="switch-on"></span>
                        <span class="switch-off"></span>
                    </span>
                </label>
            </div>
            <div class="col-md-6 dt-vendor">
                <label class="form-label" for="basic-default-name"><?= lang('Resource.vendor');?><span class="text-danger"> *</span></label>
                <select id="vendor_id" name="vendor_id" class="select2 form-select form-select-lg vendorDd" data-allow-clear="true">
                    <option></option>
                    <?php if(isset($resource_data['vendor_id']) && $resource_data['vendor_id'] != 0){ ?>
                    <option value="<?= isset($resource_data['vendor_id']) ? $resource_data['vendor_id'] : 0 ?>" selected> <?= isset($resource_data['vendor_name']) ? $resource_data['vendor_name'] : ''  ?> </option>
                    <?php } ?>
                </select> 
            </div>
            <?php /*
            <div class="col-md-6 resource-login">
                <label class="form-label" for="basic-default-name"><?= lang("Resource.is_login"); ?></label><br>
                <input type="checkbox" class="form-check-input" id="is_login" name="is_login" <?= isset($resource_data['is_login']) && $resource_data['is_login'] == 1 ? "checked" : '' ?> value="1">
            </div>

            <div class="col-md-6 dt-group">
                <label class="form-label" for="basic-default-name"><?= lang('Resource.group');?><span class="text-danger"> *</span></label>
                <select id="group_id" name="group_id" class="select2 form-select form-select-lg groupDd" data-allow-clear="true">
                    <option></option>
                    <?php if(isset($resource_data['group_id']) && $resource_data['group_id'] != 0){ ?>
                    <option value="<?= isset($resource_data['group_id']) ? $resource_data['group_id'] : 0 ?>" selected> <?= isset($resource_data['group_name']) ? $resource_data['group_name'] : ''  ?> </option>
                    <?php } ?>
                </select> 
            </div> */ ?>
        </div>
        <div class="resource-flat">
            <hr class="my-4 mx-n4"/>
            <h6 class="resource-flat">2. <?= lang('Resource.resource_working_day_information'); ?></h6>
            <div class="row g-3 resource-flat">
                <?= isset($resource_flat_table) ? $resource_flat_table : ""; ?>
            </div>
            <?php if ($dtCIAcl->checkAccess('Resource|manage')) { ?>
                <button type="button" class="btn btn-xs btn-primary resource-flat" onclick="addResourceFlat()">
                    <i class="ti ti-plus me-1"></i>
                    <span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
                </button>
            <?php } ?>
        </div>
        <hr class="my-4 mx-n4" />
        <h6>3. <?= lang('Resource.man_power_document'); ?></h6>
        <div class="row g-3">
            <?= isset($document_table) ? $document_table : ""; ?>
        </div>

        <?php if ($resourceView != 1) { ?>

            <div class="pt-4">
                <button type="submit" id="submitBtn"
                        class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
                <button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Resource'); ?>'"
                        class="btn btn-label-secondary"><?= lang('CommonMessage.common_cancel'); ?></button>
            </div>
        <?php } ?>
        <?php echo form_close(); ?>
    </div>

    <script>

        var editable = <?= $resourceView ?>;
        if (editable == 1) {
            $("#form_resource :input").prop("disabled", true);
            $(".dt-delete-item-row").removeAttr("onclick");
            $(".dt-delete-item-row").remove();
        }

        function resourceFlat() {
            addValidation("select", ".dt-flat-id", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_select');?> " + "<?= lang('Resource.flat');?>",
                }
            });
            addValidation("select", ".dt-working-day-id", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_select');?> " + "<?= lang('Resource.working_days');?>",
                }
            });

            addValidation("input", ".dt-in-time", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_enter');?> " + "<?= lang('Resource.in_time');?>",
                }
            });
            addValidation("input", ".dt-out-time", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_enter');?> " + "<?= lang('Resource.out_time');?>",
                }
            });
        }
        function inTime() {
            $('.dt-in-time').flatpickr({
                enableTime: true,
                noCalendar: true,
                dateFormat: "h:i K"
            });
        }

        function outTime() {
            $('.dt-out-time').flatpickr({
                enableTime: true,
                noCalendar: true,
                dateFormat: "h:i K"
            });
        }

        $(document).ready(function () {
            <?php 
            if(!empty($resourceId)){ ?>
                resourceTypeDd();
                // If you're editing, and the value is already present, trigger change manually
                var resourceSelect = $('#resource_type_id');
                if (resourceSelect.val()) {
                    // Manually trigger the select2:select event with the selected option data
                    var selectedOption = resourceSelect.find('option:selected');
                    resourceSelect.trigger({
                        type: 'select2:select',
                        params: {
                            data: {
                                id: selectedOption.val(),
                                text: selectedOption.text(),
                                is_login: selectedOption.data('is_login'),
                                is_guard: selectedOption.data('is_guard'),
                                group_id: selectedOption.data('group_id')
                            }
                        }
                    });
                }
            <?php }
            ?>
            documentDd();
            // categoryDd();
            numberInit();
            addSerialNumber('resource_flat_table');
            addSerialNumber('document_table');
            towerDd();
            ownerflatDd();
            inTime();
            outTime();
            gateDd();
            vendorDd();
            resourceTypeDd();
            // groupDd();
            
            $('#is_outsourced').change();
            $('.document-type').select2();
            $(".dt-working-day-id").select2();
            dateDocumentInit();
            // Initialize
            var validator = $("#form_resource").validate({
                ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
                errorClass: 'validation-invalid-label',
                // successClass: 'validation-valid-label',
                validClass: 'validation-valid-label',
                highlight: function (element, errorClass) {
                    $(element).removeClass(errorClass);
                },
                unhighlight: function (element, errorClass) {
                    $(element).removeClass(errorClass);
                },
                success: function (label) {
                    //label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
                },
                // Different components require proper error label placement
                errorPlacement: function (error, element) {

                    // Unstyled checkboxes, radios
                    if (element.parents().hasClass('form-check')) {
                        error.appendTo(element.parents('.form-check').parent());
                    }

                    // Input with icons and Select2
                    else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
                        error.appendTo(element.parent());
                    }

                    // Input group, styled file input
                    else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                        error.appendTo(element.parent().parent());
                    }

                    // Other elements
                    else {
                        error.insertAfter(element);
                    }
                },
                rules: {
                    resource_type_id: {
                        required: true,
                    },
                    resource_name: {
                        required: true,
                    },
                    resource_mobile_no: {
                        required: true,
                        minlength: 10,
                        maxlength: 10,
                    },
                    father_name : {
                        required : true,
                    },
                    date_of_birth : {
                        required : true,
                    },
                    gender : {
                        required : true,
                    },
                    work : {
                        required : true,
                    },
                    present_address : {
                        required : true,
                    },
                    permanent_address : {
                        required : true,
                    },
                    "gate_id[]" : {
                        required: "#gate_id:visible",
                    },
                    vendor_id : {
                        required: "#vendor_id:visible",
                    },
                    <?php
                    if($resourceId == '') { ?>
                        "resource_image[]":{
                            required : true,
                        },
                    <?php } ?>
                },
                messages: {
                    resource_type_id: {
                        required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Resource.resource_type"); ?>.'
                    },
                    resource_name: {
                        required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Resource.resource_name"); ?>.'
                    },
                    resource_mobile_no: {
                        required: '<?= lang('CommonMessage.common_please_enter'); ?> <?= lang("Resource.mobile_no"); ?>',
                    },
                    father_name : {
                        required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Resource.father_name"); ?>',
                    },
                    date_of_birth : {
                        required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Resource.date_of_birth"); ?>',
                    },
                    gender : {
                        required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Resource.gender"); ?>',
                    },
                    work : {
                        required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Resource.work"); ?>',
                    },
                    present_address : {
                        required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Resource.present_address"); ?>',
                    },
                    permanent_address : {
                        required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Resource.permanent_address"); ?>',
                    },
                    "gate_id[]": {
                        required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Resource.gate"); ?>',
                    },
                    vendor_id: {
                        required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Resource.vendor"); ?>',
                    },
                    <?php
                    if($resourceId == '') { ?>
                        "resource_image[]":{
                            required : '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Resource.resource_image"); ?>',
                        },
                    <?php } ?>
                },
                submitHandler: function (e) {
                    $(e).ajaxSubmit({
                        url: '<?php echo admin_url("Resource/save");?>',
                        type: 'post',
                        beforeSubmit: function (formData, jqForm, options) {
                            dtButtonHide('#submitBtn');
                            dtButtonHide('#cancelBtn');
                        },
                        complete: function () {

                        },
                        dataType: 'json',
                        clearForm: false,
                        success: function (resObj, statusText) {
                        if (resObj.success) {
                            toastr.success(resObj.msg, 'Success', {
                                closeButton: true,
                                progressBar: true,
                                positionClass: 'toast-top-right',
                                timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Resource');?>';
                                }
                            });

                            // setTimeout(function () {
                            //     window.location.href = '<?php echo admin_url('Resource');?>';
                            // }, 1000);

                        } else {
                            dtButtonShow('#submitBtn');
                            dtButtonShow('#cancelBtn');
                            toastr.error(resObj.msg, 'Error', {
                                closeButton: true,
                                // progressBar: true,
                                positionClass: 'toast-top-right',
                                // timeOut: 1000
                            });
                        }
                    }
                    });
                }
            });
            // resourceFlat();
            $("#date_of_birth").flatpickr({
                // monthSelectorType: 'static',
                dateFormat: 'd-m-Y'
            });
        });

        $(document).on('click', '.delete-image', function () {
            var deleteId = $(this).attr("id");
            var resourceId = $("#resource_id").val();
            Swal.fire({
                title: "<?= ucwords(lang('CommonMessage.common_delete')); ?>",
                text: "<?= lang('CommonMessage.delete_warning'); ?>",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'OK',
                customClass: {
                    confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                    cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                },
                buttonsStyling: false
            }).then(function(result) {
                if (result.value) {

                    $("span.document-image-"+deleteId).remove();

                    $.ajax({
                        type: "post",
                        url: "<?= admin_url("Resource/deleteResourceImage")?>",
                        dataType: "json",
                        data: {document_image_id: deleteId,document_type_id:resourceId,document_type:'resource'},
                        success: function (data) {
                            if (data['success']) {
                                $(".delete-image").click(function() {
                                    $(this).parent().remove();
                                }); 
                                Swal.fire({
                                    title: 'Success',
                                    text: data['msg'],
                                    icon: 'success',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            }
                            else{
                                Swal.fire({
                                    title: 'Error!',
                                    text: data['msg'],
                                    icon: 'error',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            }
                        }
                    });
                }
            });
        });

        $(document).on('click', '.module-delete-image', function () {
            var deleteId = $(this).attr("id");
            var resourceId = $("#resource_id").val();
            Swal.fire({
                title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
                text: "<?= lang('CommonMessage.delete_warning'); ?>",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'OK',
                customClass: {
                    confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                    cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                },
                buttonsStyling: false
            }).then(function(result) {
                if (result.value) {
                    $("span.document-remove-image-"+deleteId).remove();
                    $.ajax({
                        type: "post",
                        url: "<?= admin_url("Staff/deleteModuleImage")?>",
                        dataType: "json",
                        data: {module_document_image_id: deleteId,module:"resource",module_id:resourceId},
                        success: function (data) {
                            if (data['success']) {
                                // $(".module-delete-image").click(function() {
                                //    $(this).closest('.document-remove-image').remove();
                                // });

                                Swal.fire({
                                    title: 'Success',
                                    text: data['msg'],
                                    icon: 'success',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            }
                            else{
                                Swal.fire({
                                    title: 'Error!',
                                    text: data['msg'],
                                    icon: 'error',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            }
                        }
                    });
                }
            });
        });

        $(document).on('change', '#is_outsourced', function () {
            var isOutsourced = $(this).prop('checked'); // Check if the checkbox is checked
            if (isOutsourced) {
                $(".dt-vendor").show();
            } else {
                $(".dt-vendor").hide();
            }
        });
    </script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>