<?php
$html = '';
if (isset($resource_flat_data) && !empty($resource_flat_data)) {
	foreach ($resource_flat_data as $key => $value) {
		$data["row_number"] = $key + 1;
		$data["resource_flat_data"] = $value;
		$html .= view('Admin/Resource/ResourceFlatRowView', $data);
	}
}
?>
<!-- Responsive Table -->
	<div class="table-responsive text-nowrap">
		<table id="resource_flat_table" class="table table-bordered">
			<thead>
			<tr class="text-nowrap">
				<th><?= lang('CommonMessage.common_sr_no'); ?></th>
				<th><?= lang('Resource.flat'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Resource.working_days'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Resource.in_time'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Resource.out_time'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('CommonMessage.common_action'); ?></th>
			</tr>
			</thead>
			<tbody class="table-border-bottom-0">
			<?php
			if (isset($resource_flat_data) && !empty($resource_flat_data)) {
				echo $html;
			}else { ?>
				<?php
				$data["row_number"] =  1;
				echo view('Admin/Resource/ResourceFlatRowView',$data); ?>
			<?php } ?>

			</tbody>
		</table>
	</div>
<!--/ Responsive Table -->
<script>
	var rowNumber;

	function addResourceFlat() {
		var lastIndex = ($("#resource_flat_table tbody tr:last").length >= 1) ? $("#resource_flat_table tbody tr:last").attr("data-id").split("_").pop() : 0;
		rowNumber = parseInt(lastIndex) + 1;
		$.ajax({
			type: "post",
			url: "<?= admin_url('Resource/addResourceFlatRow'); ?>",
			dataType: "html",
			async: false,
			data: {
				row_number: rowNumber,
			},
			success: function (data) {
				if (data) {
					$('table#resource_flat_table tbody').append(data);
					addSerialNumber('resource_flat_table');
                    ownerflatDd();
					numberInit();
                    $('#in_time_'+rowNumber).flatpickr({
                        enableTime: true,
                        noCalendar: true,
                        dateFormat: "h:i K"
                    });
                    $('#out_time_'+rowNumber).flatpickr({
                        enableTime: true,
                        noCalendar: true,
                        dateFormat: "h:i K"
                    });
                    $(".dt-working-day-id").select2();
                    resourceFlat();
					customToolTip();
				}
			}
		});
	}


	$(document).on('click', '.dt-delete-item-row', function () {
		var trField = $(this).closest('tr');
		var id = $(this).closest('tr').find(".resource_flat_id").val();
		var resourceId = $("#resource_id").val();

		if (id != '') {
				Swal.fire({
					title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
					text: "<?= lang('CommonMessage.delete_warning'); ?>",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'OK',
					customClass: {
						confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
						cancelButton: 'btn btn-label-secondary waves-effect waves-light'
					},
					buttonsStyling: false

			}).then(function (result) {
				if (result.value) {
					var deleteId = [];
					deleteId.push(id);
					$.ajax({
						type: "POST",
						url: "<?php echo admin_url('Resource/deleteResourceFlatRow');?>",
						dataType: "json",
						async:false,
						data: {
                            resource_flat_id: deleteId,
                            resource_id: resourceId
						},
						success: function (resObj) {
							if (resObj.success) {
								$(trField).remove();
								addSerialNumber('resource_flat_table');
								Swal.fire({
									title: 'Success',
									text: resObj['msg'],
									icon: 'success',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								}).then(function() {
									if ($('#resource_flat_table tbody > tr').length == 0) {
                                        addResourceFlat();
									}
								});
							} else {
								Swal.fire({
									title: 'Error!',
									text: resObj['msg'],
									icon: 'error',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								});
							}
						}
					});
				}
			});
		} else {
			$(trField).remove();
			addSerialNumber('resource_flat_table');
			if ($('#resource_flat_table tbody > tr').length == 0) {
                addResourceFlat();
			}
		}
	});

</script>
