<?php
$assets = base_url() . 'assets/';
$rentalsData = !empty($rentals_data) && is_array($rentals_data) ? $rentals_data : array(); ?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?= $name; ?></title>
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet"
		  type="text/css">

	<link href="<?= $assets ?>css/pdf_bootstrap.css" rel="stylesheet" type="text/css">
	<link href="<?= $assets ?>css/pdf_style_sheet.css" rel="stylesheet" type="text/css">

</head>

<body style='font-family:chelvetica;font-size: 9px'>
<div class="row">
	<div class="col-xs-12">
		<h3 style="color: red;text-align: center;"><?= lang('Rentals.rentals_detail'); ?></h3>


        <table class="table" border="1" cellpadding="1" cellspacing="1" width="100%">
            <tr>
                <td colspan="6" rowspan="2"><center><strong>TENANTS</center></strong></td>
                <td colspan="4"><center><strong><?php
                    if (isset($rentalsData['society_name']) && $rentalsData['society_name'] != '') {
                        echo $rentalsData['society_name'];
                    } ?></center></strong></td>
            </tr>
            <tr>
                <td colspan="2"><center><strong><?= lang("Rentals.intercom_no"); ?>.</center></strong></td>
                <td colspan="2"><center><?= isset($rentalsData["intercom_no"]) ? $rentalsData["intercom_no"] : ""; ?></center></td>
            </tr>
            <tr>
                <td><center><strong>TOWER</center></strong></td>
                <td><center><?= isset($rentalsData["tower_name"]) ? $rentalsData["tower_name"] : ""; ?></center></td>
                <td><center><strong>FLAT NO.</center></strong></td>
                <td><center><?= isset($rentalsData["flat_no"]) ? $rentalsData["flat_no"] : ""; ?></center></td>
                <td><center><strong>BHK</center></strong></td>
                <td><center><?= isset($rentalsData["bhk"]) ? roundNumber($rentalsData["bhk"]) : ""; ?></center></td>
                <td><center><strong>SQ FT</center></strong></td>
                <td><?= isset($rentalsData["sqr_ft"]) ? roundNumber($rentalsData["sqr_ft"]) : ""; ?></td>
                <td><center><strong>RESIDENT</center></strong></td>
                <td><center>Tenant</center></td>
            </tr>
            <?php if(isset($rentals_flat_owner_data) && !empty($rentals_flat_owner_data)){
                    foreach ($rentals_flat_owner_data as $rentalsOwnerData) { ?>
            <tr>
                <td colspan="2"><center><strong>Owner's Name<center><strong></td>
                <td colspan="4"><?= isset($rentalsOwnerData['name']) ? $rentalsOwnerData['name'] : ''; ?></td>
                <td colspan="2"><center><strong>Contact No.</center></strong></td>
                <td colspan="2"><?= isset($rentalsOwnerData['mobile_no']) ? $rentalsOwnerData['mobile_no'] : ''; ?></td>
            </tr>
            <?php } } ?>
            <tr>
                <td colspan="2"><center><strong>Brokers's Name</center></strong></td>
                <td colspan="4"><?= isset($rentalsData["broker_name"]) ? $rentalsData["broker_name"] : ""; ?></td>
                <td colspan="2"><center><strong>Contact No.</center></strong></td>
                <td colspan="2"><?= isset($rentalsData["broker_contact_no"]) ? $rentalsData["broker_contact_no"] : ""; ?></td>
            </tr>
            <tr>
                <td colspan="4"><center><strong>Name of Tenant</center></strong></td>
                <td colspan="2"><center><strong>Contact</center></strong></td>
                <td colspan="4"><center><strong>Email</center></strong></td>
            </tr>
            <tr>
                <td colspan="4"><center><?= isset($rentalsData["tenant_name"]) ? $rentalsData["tenant_name"] : ""; ?></center></td>
                <td colspan="2"><center><?= isset($rentalsData["tenant_contact_no"]) ? $rentalsData["tenant_contact_no"] : ""; ?></center></td>
                <td colspan="4"><center><?= isset($rentalsData["tenant_email"]) ? $rentalsData["tenant_email"] : ""; ?></center></td>
            </tr>
            <tr>
                <td colspan="4"><center><strong>Rent Agreement Period</center></strong></td>
                <td><center><strong>From</center></strong></td>
                <td colspan="2"><center><?= isset($rentalsData["rent_agreement_period_from"]) ? YMDToDMY($rentalsData["rent_agreement_period_from"]) : ""; ?></center></td>
                <td><center><strong>To</center></strong></td>
                <td colspan="2"><center><?= isset($rentalsData["rent_agreement_period_to"]) ? YMDToDMY($rentalsData["rent_agreement_period_to"]) : ""; ?></center></td>
            </tr>
            <tr>
                <td colspan="4" ><center><strong>Native/Permanent Address</center></strong></td>
                <td colspan="6"><?= isset($rentalsData["permanent_address"]) ? $rentalsData["permanent_address"] : ""; ?></td>
            </tr>

            <tr>
                <td colspan="4" ><center><strong>Work Address</center></strong></td>
                <td colspan="6"><?= isset($rentalsData["work_address"]) ? $rentalsData["work_address"] : ""; ?></td>
            </tr>
        </table>


		<?php if (isset($rentals_member_data) && !empty($rentals_member_data)) { ?>
			<h3 style="color: red;text-align: center;"><?= lang('Rentals.family_information') ?></h3>
			<table class="table" width="100%" border="1">
				<thead>
				<tr>
					<td class="text-bold" style="width: 5%">
						<?= lang('CommonMessage.common_sr_no'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.name'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.email_id'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.mobile'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.gender'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.relation'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.birth_yr'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.blood_gp'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.food_like'); ?>
					</td>
				</tr>
				</thead>
				<tbody>
				<?php
				if (is_array($rentals_member_data) && !empty($rentals_member_data)) {
					foreach ($rentals_member_data as $key => $value) {
						?>
						<tr>
							<td>
								<?= ++$key; ?>
							</td>
							<td>
								<?= isset($value['name']) ? $value['name'] : ''; ?>
							</td>
							<td>
								<?= isset($value['email_id']) ? $value['email_id'] : ''; ?>
							</td>
							<td>
								<?= isset($value['mobile_no']) ? $value['mobile_no'] : ''; ?>
							</td>
							<td>
								<?= isset($value['gender']) ? underscoreToUcWord($value['gender']) : ''; ?>
							</td>
							<td>
								<?= isset($value['relation']) ? underscoreToUcWord($value['relation']) : ''; ?>
							</td>
							<td>
								<?= isset($value['birth_date']) ? YMDToDMY($value['birth_date']) : ''; ?>
							</td>
							<td>
								<?= isset($value['blood_group']) ? $value['blood_group'] : ''; ?>
							</td>
							<td>
								<?= isset($value['food_like']) ? underscoreToUcWord($value['food_like']) : ''; ?>
							</td>
						</tr>
						<?php
					}
				} else {
					echo "<tr><td colspan='9' class='text-center'>" . lang("CommonMessage.common_no_data_found") . "</td></tr>";
				} ?>
				</tbody>
			</table>
		<?php } ?>

		<?php if (isset($rentals_emergency_contact_data) && !empty($rentals_emergency_contact_data)) { ?>
			<h3 style="color: red;text-align: center;"><?= lang('Rentals.emergency_information') ?></h3>
			<table class="table" width="100%" border="1">
				<thead>
				<tr>
					<td class="text-bold" style="width: 10%">
						<?= lang('CommonMessage.common_sr_no'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.e_name'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.e_place'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.e_relation'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.e_mobile'); ?>
					</td>
				</tr>
				</thead>
				<tbody>
				<?php
				if (is_array($rentals_emergency_contact_data) && !empty($rentals_emergency_contact_data)) {
					foreach ($rentals_emergency_contact_data as $eKey => $contactValue) {

						?>
						<tr>
							<td>
								<?= ++$eKey; ?>
							</td>
							<td>
								<?= isset($contactValue['name']) ? $contactValue['name'] : ''; ?>
							</td>
							<td>
								<?= isset($contactValue['place']) ? $contactValue['place'] : ''; ?>
							</td>
							<td>
								<?= isset($contactValue['relation']) ? underscoreToUcWord($contactValue['relation']) : ''; ?>
							</td>
							<td>
								<?= isset($contactValue['mobile_no']) ? $contactValue['mobile_no'] : ''; ?>
							</td>

						</tr>
						<?php
					}
				} else {
					echo "<tr><td colspan='5' class='text-center'>" . lang("CommonMessage.common_no_data_found") . "</td></tr>";
				} ?>
				</tbody>
			</table>
		<?php } ?>


		<?php if (isset($rentals_parking_data) && !empty($rentals_parking_data)) { ?>
			<h3 style="color: red;text-align: center;"><?= lang('Rentals.parking_information') ?></h3>
			<table class="table" width="100%" border="1">
				<thead>
				<tr>
					<td class="text-bold" style="width: 10%">
						<?= lang('CommonMessage.common_sr_no'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.vehicle_type'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.vehicle_no'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.parking_slot'); ?>
					</td>
					<!-- <td class="text-bold">
						<?= lang('Rentals.parking_slot_no'); ?>
					</td> -->
					<td class="text-bold">
						<?= lang('Rentals.token_no'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.is_electric'); ?>
					</td>
				</tr>
				</thead>
				<tbody>
				<?php
				if (is_array($rentals_parking_data) && !empty($rentals_parking_data)) {
					foreach ($rentals_parking_data as $pKey => $parkingValue) {

						?>
						<tr>
							<td>
								<?= ++$pKey; ?>
							</td>
							<td>
								<?= isset($parkingValue['vehicle_type']) ? underscoreToUcWord($parkingValue['vehicle_type']) : ''; ?>
							</td>
							<td>
								<?= isset($parkingValue['vehicle_no']) ? $parkingValue['vehicle_no'] : ''; ?>
							</td>
							<td>
								<?= isset($parkingValue['parking_area']) ? $parkingValue['parking_area'] : ''; ?>
							</td>
							<!-- <td>
								<?= isset($parkingValue['parking_slot_no']) ? $parkingValue['parking_slot_no'] : ''; ?>
							</td> -->
							<td>
								<?= isset($parkingValue['token_no']) ? $parkingValue['token_no'] : ''; ?>
							</td>
							<td>
								<?= (isset($parkingValue['is_electric']) && $parkingValue['is_electric'] != 0) ?  'Yes' : 'No'; ?>
							</td>
						</tr>
						<?php
					}
				} else {
					echo "<tr><td colspan='5' class='text-center'>" . lang("CommonMessage.common_no_data_found") . "</td></tr>";
				} ?>
				</tbody>
			</table>
		<?php } ?>

		<?php if (isset($rentals_access_card_data) && !empty($rentals_access_card_data)) { ?>
			<h3 style="color: red;text-align: center;"><?= lang('Rentals.access_card_information') ?></h3>
			<table class="table" width="100%" border="1">
				<thead>
				<tr>
					<td class="text-bold" style="width: 10%">
						<?= lang('CommonMessage.common_sr_no'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.remarks'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.lifts_access'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.amenities_usage'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Rentals.vehicle_type'); ?>
					</td>
				</tr>
				</thead>
				<tbody>
				<?php
				if (is_array($rentals_access_card_data) && !empty($rentals_access_card_data)) {
					foreach ($rentals_access_card_data as $aKey => $acceessValue) {

						?>
						<tr>
							<td>
								<?= ++$aKey; ?>
							</td>
							<td>
								<?= isset($acceessValue['remarks']) ? ($acceessValue['remarks']) : ''; ?>
							</td>
							<td>
								<?= isset($acceessValue['lift_access']) ? $acceessValue['lift_access'] : ''; ?>
							</td>
							<td>
								<?= isset($acceessValue['amenities_name']) ? $acceessValue['amenities_name'] : ''; ?>
							</td>
							<td>
								<?php foreach ($acceessValue['vehicle_data'] as $key => $value) { ?>
										<?= underscoreToUcWord($value['vehicle_type']); ?>
								<?php } ?>
							</td>
						</tr>
						<?php
					}
				} else {
					echo "<tr><td colspan='5' class='text-center'>" . lang("CommonMessage.common_no_data_found") . "</td></tr>";
				} ?>
				</tbody>
			</table>
		<?php } ?>
	</div>
</div>
</body>
</html>
