<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<?= isset($advance_filter) ? $advance_filter : ""; ?>
<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>
<div class="card">
	<div class="card-datatable text-nowrap table-responsive">
		<table id="poll_votes_table" class="table dt-datatable dt-scrollableTable">
			<thead class="border-top">
			<tr>
                <th class="font-weight-bold"><?= lang("PollVotes.poll_option_id"); ?></th>
				<th class="font-weight-bold"><?= lang("PollVotes.poll_title"); ?></th>
				<th class="font-weight-bold"><?= lang("PollVotes.poll_option"); ?></th>
				<th class="font-weight-bold"><?= lang("PollVotes.ownership_flat_member"); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_created_at"); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_created_by"); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_updated_at"); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_updated_by"); ?></th>
			</tr>
			</thead>
		</table>
	</div>
</div>
<script type="text/javascript">
	var dt_DataTable;
	$(document).ready(function () {
		pollDd();
		pollOptionDd();
		dt_DataTable = $('#poll_votes_table').DataTable( {
			dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
				'<"me-5 ms-n2 pe-5"f>' +
				'<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
				'>t' +
				'<"row mx-2"' +
				'<"col-sm-12 col-md-6"i>' +
				'<"col-sm-12 col-md-6"p>' +
				'>',
			processing: true,
			serverSide: true,
            scrollX: true,
			displayLength: 10,
			language: {
				sLengthMenu: 'Show _MENU_',
				search: '',
				searchPlaceholder: 'Search <?= lang('PollVotes.poll_votes');?>',
				info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
			},
			buttons: [
				
			],
			"ajax": {
				"url": "<?php echo admin_url('PollVotesDetail/getPollVotesDetailListing'); ?>",
				"type": "POST",
				"data": function(d) {
                    var params = {};
                    params["<?= csrf_token(); ?>"] = "<?= csrf_hash() ?>";
                    var filterData = $("#advanceFilter").serializeArray();
                    $.each(filterData, function(i, val) {
                        var name = val.name;
                        if (typeof params[name] == 'undefined') {
                            params[name] = val.value;
                        } else if ($.isArray(params[name])) {
                            params[name].push(val.value);
                        } else {
                            params[name] = [params[name]];
                            params[name].push(val.value);
                        }
                    });

                    return $.extend({}, d, params);
                }
			},
			"stateSave": true,
			"order": [[ 0, "asc" ]],
			"columns": [
				{
					"data": "poll_option_id",
					visible: false,
                    "searchable":false,
				},
				{"data": "poll_title" },
				{"data": "poll_option" },
				{"data": "member_name" , "searchable": false },
				{"data": "created_at" },
				{"data": "created_by" },
				{"data": "updated_at" },
				{"data": "updated_by" },
			],
			"fnDrawCallback": function (oSettings, json) {
				customToolTip();
				$('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
				$('.dt-buttons').addClass('d-flex flex-wrap');
				$('.dataTables_filter .form-control').removeClass('form-control-sm');
				$('.dataTables_length .form-select').removeClass('form-select-sm');
				//checkBoxRefresh("datatable-checkbox");
				switcheryKeyGen("datatable-list-switchery");
			}
		});
		dtDataTableSearch();
	});

	$(document).on('click', '.filter_data', function() {
		dt_DataTable.draw();
	});
	$(document).on('click', '.clear_filter', function() {
		$('form#advanceFilter  #filter_poll_id').val('').trigger('change');
		$('form#advanceFilter  #filter_poll_option_id').val('').trigger('change');
		$("#filter_created_at").val('');
		$("#filter_updated_at").val('');
        dateRangePicker();
		dt_DataTable.draw();
	});
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>