<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$parkingAreaView = isset($parking_area_data['view']) ? $parking_area_data['view'] : 0;
$numberType = isset($parking_area_data['number_type']) ? $parking_area_data['number_type'] : '';
?>

<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-header d-flex align-items-center justify-content-between">
                <h5 class="mb-0"><?= lang('ParkingArea.parking_area_form');?></h5>
            </div>
            <div class="card-body">
                <?php
                //create  form open tag
                $form_id = array(
                    'id' => 'form_parking_area',
                );
                echo form_open_multipart('',$form_id);
                $parkingAreaId = (isset($parking_area_data['parking_area_id']) && ($parking_area_data['parking_area_id'] != '')) ? $parking_area_data['parking_area_id'] : '';
                ?>
                <input type="hidden" id="parking_area_id" name="parking_area_id" value="<?= $parkingAreaId ?>">
                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('ParkingArea.parking_area_name');?><span class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="parking_area_name" id="parking_area_name" placeholder="Enter <?= lang('ParkingArea.parking_area_name');?>" value="<?= (isset($parking_area_data['parking_area_name']) && ($parking_area_data['parking_area_name'] != '')) ? $parking_area_data['parking_area_name'] : '';  ?>" />
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
                    <div class="col-sm-10">
                        <label class="switch switch-sm"><span class="switch-label"></span>
                            <input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($parking_area_data['is_active']) || $parking_area_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
                            <span class="switch-toggle-slider">
                                      <span class="switch-on"></span>
                                      <span class="switch-off"></span>
                                    </span>
                        </label>
                    </div>
                </div>

                <hr class="my-4 mx-n4" />

                <h6>2. <?= lang('ParkingArea.add_parking_vehicle'); ?></h6>
                <div class="row g-3">
                    <?= isset($parking_vehicle_table) ? $parking_vehicle_table : ""; ?>
                </div>
                <?php if ($dtCIAcl->checkAccess('ParkingArea|manage')) { ?>
                    <button type="button" class="btn btn-xs btn-primary" onclick="addParkingVehicle()">
                        <i class="ti ti-plus me-1"></i>
                        <span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
                    </button>
                <?php } ?>

                
                <div class="pt-4">
                    <button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
                    <button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('ParkingArea'); ?>'" class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>


<!--  add,update and delete model code here-->
<script type="text/javascript">
    //var laddaSubmitBtn = Ladda.create(document.querySelector('#submit'));
    $(document).ready(function () {
        numberInit();
        $('.dt-number-type,.dt-vehicle-type').select2();
        addSerialNumber('parking_vehicle_table');
        $('.dt-number-type').trigger('change');
        //validation
        var validator = $("#form_parking_area").validate({
            ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
            errorClass: 'validation-invalid-label',
            successClass: 'validation-valid-label',
            validClass: 'validation-valid-label',
            highlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            unhighlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            success: function (label) {
                label.addClass('validation-valid-label'); // remove to hide Success message
            },
            // Different components require proper error label placement
            errorPlacement: function (error, element) {
                // Unstyled checkboxes, radios
                if (element.parents().hasClass('form-check')) {
                    error.appendTo(element.parents('.form-check').parent());
                }

                // Input with icons and Select2
                else if (element.parents().hasClass('form-group-feedback') || element.hasClass('select2-hidden-accessible')) {
                    error.appendTo(element.parent());
                }

                // Input group, styled file input
                else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                    error.appendTo(element.parent().parent());
                }

                // Other elements
                else {
                    error.insertAfter(element);
                }
            },
            rules: {
                parking_area_name: {
                    required: true
                },
            },
            messages: {
                parking_area_name: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang("ParkingArea.parking_area_name"); ?>",
                },
            },
            submitHandler: function (e) {
                $(e).ajaxSubmit({
                    url: '<?php echo admin_url("ParkingArea/save");?>',
                    type: 'post',
                    beforeSubmit: function (formData, jqForm, options) {
                        dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
                    },
                    complete: function () {
                        //laddaStop();
                    },
                    dataType: 'json',
                    clearForm: false,
                    success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('ParkingArea');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('ParkingArea');?>';
							// }, 1000);

						} else {
                            dtButtonShow('#submitBtn');
                            dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
                });
            }
        });



    });

    $(document).on('change', '.dt-number-type', function() {
        var numberType = $(this).val(); // Get the selected number type
        var row = $(this).closest('tr'); // Get the closest row (tr) that contains this dropdown

        // Select the corresponding Range Label and Range Start From fields in this row
        var rangeLabelField = row.find('.dt-range-label');
        var rangeStartFromField = row.find('.dt-range-start-from');

        if (numberType === 'range') {
            // If 'range' is selected, show the fields
            rangeLabelField.show();
            rangeStartFromField.show();
        } else {
            // If 'manual' or other types are selected, hide the fields
            rangeLabelField.hide();
            rangeStartFromField.hide();
        }

        // Additional logic to ensure visibility based on the entire table's context
        var shouldShow = false;

        $('.dt-number-type').each(function() {
            if ($(this).val() === 'range') {
                shouldShow = true;
            }
        });

        if (shouldShow) {
            // Show all fields that have 'range' selected
            $('.dt-number-type').each(function() {
                var thisRow = $(this).closest('tr');
                var thisRangeLabel = thisRow.find('.dt-range-label');
                var thisRangeStartFrom = thisRow.find('.dt-range-start-from');

                if ($(this).val() === 'range') {
                    thisRangeLabel.show();
                    thisRangeStartFrom.show();
                }
            });
        }
    });
</script>
