<?php
$assets = base_url() . 'assets/';
$ownershipFlatData = !empty($ownership_flat_data) && is_array($ownership_flat_data) ? $ownership_flat_data : array();
$langName = isset($lang_name) ? $lang_name : '';
?>
<!DOCTYPE html>
<html>

<head>
	<meta charset="utf-8">
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?= $name; ?></title>
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet" type="text/css">

	<link href="<?= $assets ?>css/pdf_bootstrap.css" rel="stylesheet" type="text/css">
	<link href="<?= $assets ?>css/pdf_style_sheet.css" rel="stylesheet" type="text/css">

</head>

<body style='font-family:chelvetica;font-size: 9px'>
	<div class="row">
		<div class="col-xs-12">
			<h3 style="color: red;text-align: center;"><?= lang($langName . 'ownership_flat_detail_pdf'); ?></h3>
			<table class="table" width="100%" cellspacing="0" cellpadding="0">
				<tbody>
					<tr>
						<td>
							<table class="table" border="1" cellpadding="1" cellspacing="1" width="100%">
								<tbody>
									<tr>
										<td colspan="8" rowspan="2" style="vertical-align : middle"><center><strong><?= lang($langName . 'first_ownership')?></strong></center></td>
										<td colspan="2"><center><strong><?= isset($ownershipFlatData['society_name']) ? $ownershipFlatData['society_name'] : ''; ?></strong></center></td>
									</tr>
									<tr>
										<td><center><strong><?= lang($langName . 'intercom_no')?></strong></center></td>
										<td><center><?= isset($ownershipFlatData['intercom_no']) ? $ownershipFlatData['intercom_no'] : ''; ?></center></td>
									</tr>
									<tr>
										<td><center><strong><?= lang($langName . 'tower')?></strong></center></td>
										<td><center><?= isset($ownershipFlatData['tower_name']) ? $ownershipFlatData['tower_name'] : ''; ?></center></td>
										<td><center><strong><?= lang($langName . 'flat_no')?></strong></center></td>
										<td><center><?= isset($ownershipFlatData['flat_no']) ? $ownershipFlatData['flat_no'] : ''; ?></center></td>
										<td><center><strong><?= lang($langName . 'bhk')?></strong></center></td>
										<td><center><?= isset($ownershipFlatData['bhk']) ? roundNumber($ownershipFlatData['bhk']) : ''; ?></center></td>
										<td><center><strong><?= lang($langName . 'sq_ft')?></strong></center></td>
										<td><center><?= isset($ownershipFlatData['sqr_ft']) ? roundNumber($ownershipFlatData['sqr_ft']) : ''; ?></center></td>
										<td><center><strong><?= lang($langName . 'resident')?></strong></center></td>
										<td><center><?= isset($ownershipFlatData['resident']) ? $ownershipFlatData['resident'] : ''; ?></center></td>
									</tr>
									<tr>
										<td><center><strong><?= lang($langName . 'index_no')?></strong></center></td>
										<td><center><?= isset($ownershipFlatData['index_no']) ? $ownershipFlatData['index_no'] : ''; ?></center></td>
										<td colspan="2"><center><strong><?= lang($langName . 'date_of_registry')?></strong></center></td>
										<td colspan="2"><center><?= isset($ownershipFlatData['date_of_registry']) ? siteDateFormat($ownershipFlatData['date_of_registry']) : ''; ?></center></td>
										<td colspan="2"><center><strong><?= lang($langName . 'purchased_from')?></strong></center></td>
										<td colspan="2"><center><?= isset($ownershipFlatData['owner_name']) ? $ownershipFlatData['owner_name'] : ''; ?></center></td>
									</tr>
								</tbody>
							</table>
						</td>
					</tr>
				</tbody>
			</table>

			<?php /*
			<table class="table" width="100%" cellspacing="0" cellpadding="0">
				<tbody>
					<tr>
						<td>
							<table class="table" border="1" cellpadding="1" cellspacing="1" width="100%">
								<tbody>
									<tr>
										<td colspan="10" style="vertical-align : middle"><center><strong><?= lang($langName . 'share_details')?></strong></center></td>
									</tr>
									<tr>
										<td><center><strong><?= lang($langName . 'fee_recd')?></strong></center></td>
										<td></td>
										<td><center><strong><?= lang($langName . 'certi_no')?></strong></center></td>
										<td></td>
										<td><center><strong><?= lang($langName . 'serial_no')?></strong></center></td>
										<td></td>
										<td></td>
										<td colspan="2"><center><strong><?= lang($langName . 'member_no')?></strong></center></td>
										<td></td>
									</tr>
									<tr>
										<td><center><strong><?= lang($langName . 'nominee')?></strong></center></td>
										<td colspan="3"></td>
										<td><center><strong><?= lang($langName . 'relation')?></strong></center></td>
										<td></td>
										<td><center><strong><?= lang($langName . 'issue_no')?></strong></center></td>
										<td></td>
										<td><center><strong><?= lang($langName . 'issue_on')?></strong></center></td>
										<td></td>
									</tr>
								</tbody>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
			*/ ?>

			<?php if (isset($ownership_flat_member_data) && !empty($ownership_flat_member_data)) { ?>
				<h3 style="color: red;text-align: center;"><?= lang($langName . 'registered_member_information') ?></h3>
				<table class="table" width="100%" border="1">
					<thead>
						<tr>
							<td class="text-bold" style="width: 5%">
								<?= lang('CommonMessage.common_sn'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'name'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'email_id'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'mobile'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'gender'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'birth_yr'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'blood_gp'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'is_owner'); ?>
							</td>
						</tr>
					</thead>
					<tbody>
						<?php
						if (is_array($ownership_flat_member_data) && !empty($ownership_flat_member_data)) {
							foreach ($ownership_flat_member_data as $key => $value) {
								$isOwner = 'No';
								if ($value['is_owner'] == 1) {
									$isOwner = 'Yes';
								}
						?>
								<tr>
									<td>
										<?= ++$key; ?>
									</td>
									<td>
										<?= isset($value['name']) ? $value['name'] : ''; ?>
									</td>
									<td>
										<?= isset($value['email_id']) ? $value['email_id'] : ''; ?>
									</td>
									<td>
										<?= isset($value['mobile_no']) ? $value['mobile_no'] : ''; ?>
									</td>
									<td>
										<?= isset($value['gender']) ? underscoreToUcWord($value['gender']) : ''; ?>
									</td>
									<td>
										<?= isset($value['birth_date']) ? YMDToDMY($value['birth_date']) : ''; ?>
									</td>
									<td>
										<?= isset($value['blood_group']) ? $value['blood_group'] : ''; ?>
									</td>
									<td>
										<?= $isOwner; ?>
									</td>
								</tr>
						<?php
							}
						} else {
							echo "<tr><td colspan='8' class='text-center'>" . lang("CommonMessage.common_no_data_found") . "</td></tr>";
						} ?>
					</tbody>
				</table>
			<?php } ?>

			<?php if (isset($ownership_flat_emergency_contact_data) && !empty($ownership_flat_emergency_contact_data)) { ?>
				<h3 style="color: red;text-align: center;"><?= lang($langName . 'emergency_information') ?></h3>
				<table class="table" width="100%" border="1">
					<thead>
						<tr>
							<td class="text-bold" style="width: 10%">
								<?= lang('CommonMessage.common_sn'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'e_name'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'e_place'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'e_relation'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'e_mobile'); ?>
							</td>
						</tr>
					</thead>
					<tbody>
						<?php
						if (is_array($ownership_flat_emergency_contact_data) && !empty($ownership_flat_emergency_contact_data)) {
							foreach ($ownership_flat_emergency_contact_data as $eKey => $contactValue) {

						?>
								<tr>
									<td>
										<?= ++$eKey; ?>
									</td>
									<td>
										<?= isset($contactValue['name']) ? $contactValue['name'] : ''; ?>
									</td>
									<td>
										<?= isset($contactValue['place']) ? $contactValue['place'] : ''; ?>
									</td>
									<td>
										<?= isset($contactValue['relation']) ? underscoreToUcWord($contactValue['relation']) : ''; ?>
									</td>
									<td>
										<?= isset($contactValue['mobile_no']) ? $contactValue['mobile_no'] : ''; ?>
									</td>

								</tr>
						<?php
							}
						} else {
							echo "<tr><td colspan='5' class='text-center'>" . lang("CommonMessage.common_no_data_found") . "</td></tr>";
						} ?>
					</tbody>
				</table>
			<?php } ?>


			<?php if (isset($ownership_flat_parking_data) && !empty($ownership_flat_parking_data)) { ?>
				<h3 style="color: red;text-align: center;"><?= lang($langName . 'parking_information') ?></h3>
				<table class="table" width="100%" border="1">
					<thead>
						<tr>
							<td class="text-bold" style="width: 10%">
								<?= lang('CommonMessage.common_sn'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'vehicle_type'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'vehicle_no'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'parking_slot'); ?>
							</td>
							<!-- <td class="text-bold">
								<?= lang($langName . 'parking_slot_no'); ?>
							</td> -->
							<td class="text-bold">
								<?= lang($langName . 'token_no'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'is_electric'); ?>
							</td>
						</tr>
					</thead>
					<tbody>
						<?php
						if (is_array($ownership_flat_parking_data) && !empty($ownership_flat_parking_data)) {
							foreach ($ownership_flat_parking_data as $pKey => $parkingValue) {

						?>
								<tr>
									<td>
										<?= ++$pKey; ?>
									</td>
									<td>
										<?= isset($parkingValue['vehicle_type']) ? underscoreToUcWord($parkingValue['vehicle_type']) : ''; ?>
									</td>
									<td>
										<?= isset($parkingValue['vehicle_no']) ? $parkingValue['vehicle_no'] : ''; ?>
									</td>
									<td>
										<?= isset($parkingValue['parking_area']) ? $parkingValue['parking_area'] : ''; ?>
									</td>
									<!-- <td>
										<?= isset($parkingValue['parking_slot_no']) ? $parkingValue['parking_slot_no'] : ''; ?>
									</td> -->
									<td>
										<?= isset($parkingValue['token_no']) ? $parkingValue['token_no'] : ''; ?>
									</td>
									<td>
										<?= (isset($parkingValue['is_electric']) && $parkingValue['is_electric'] != 0) ?  'Yes' : 'No'; ?>
									</td>
								</tr>
						<?php
							}
						} else {
							echo "<tr><td colspan='5' class='text-center'>" . lang("CommonMessage.common_no_data_found") . "</td></tr>";
						} ?>
					</tbody>
				</table>
			<?php } ?>

			<?php if (isset($ownership_flat_access_card_data) && !empty($ownership_flat_access_card_data)) { ?>
				<h3 style="color: red;text-align: center;"><?= lang($langName . 'access_card_information') ?></h3>
				<table class="table" width="100%" border="1">
					<thead>
						<tr>
							<td class="text-bold" style="width: 10%">
								<?= lang('CommonMessage.common_sn'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'remarks'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'lifts_access'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'amenities_usage'); ?>
							</td>
							<td class="text-bold">
								<?= lang($langName . 'vehicle_type'); ?>
							</td>
						</tr>
					</thead>
					<tbody>
						<?php
						if (is_array($ownership_flat_access_card_data) && !empty($ownership_flat_access_card_data)) {
							foreach ($ownership_flat_access_card_data as $aKey => $acceessValue) {

						?>
								<tr>
									<td>
										<?= ++$aKey; ?>
									</td>
									<td>
										<?= isset($acceessValue['remarks']) ? ($acceessValue['remarks']) : ''; ?>
									</td>
									<td>
										<?= isset($acceessValue['lift_access']) ? $acceessValue['lift_access'] : ''; ?>
									</td>
									<td>
										<?= isset($acceessValue['amenities_name']) ? $acceessValue['amenities_name'] : ''; ?>
									</td>
									<td>
										<?php foreach ($acceessValue['vehicle_data'] as $key => $value) { ?>
											<?= underscoreToUcWord($value['vehicle_type']); ?>
										<?php } ?>
									</td>
								</tr>
						<?php
							}
						} else {
							echo "<tr><td colspan='5' class='text-center'>" . lang("CommonMessage.common_no_data_found") . "</td></tr>";
						} ?>
					</tbody>
				</table>
			<?php } ?>

		</div>
	</div>
</body>

</html>