<?php $dtCIAcl = new \App\Libraries\Dt_ci_acl();
$request    = \Config\Services::request();
$langName = isset($lang_name) ? $lang_name : '';
$type = $request->getGet('type');
if ($type == TRANSFERRED) {
	$url = admin_url('TransferredFlat/manage?type=transferred');
} else {
	$url = admin_url('OwnershipFlat/manage?type=first_owner');
}
?>

<?= isset($advance_filter) ? $advance_filter : ""; ?>

<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>
<!-- DataTable with Buttons -->
<div class="card">

	<div class="card-datatable text-nowrap table-responsive">
		<table id="ownership_flat_table" class="table dt-datatable dt-scrollableTable">
			<thead class="border-top">
				<tr>
					<th><input class="form-check-input datatable-select-all-second" type="checkbox" /></th>
					<th class="font-weight-bold"><?= lang($langName."flat_no"); ?></th>
					<th class="font-weight-bold"><?= lang($langName."index_no"); ?></th>
					<th class="font-weight-bold"><?= lang($langName."date_of_registry"); ?></th>
                    <?php if ($type != TRANSFERRED) { ?>
                        <th class="font-weight-bold"><?= lang($langName."buyer"); ?></th>
					    <th class="font-weight-bold"><?= lang($langName."purchased_from"); ?></th>
                    <?php } else { ?>
                        <th class="font-weight-bold"><?= lang($langName."buyer"); ?></th>
                        <th class="font-weight-bold"><?= lang($langName."seller"); ?></th>
                    <?php } ?>

					<th class="font-weight-bold"><?= lang('CommonMessage.common_updated_by'); ?></th>
					<th class="font-weight-bold"><?= lang('CommonMessage.common_updated_at'); ?></th>
					<?php if ($type != TRANSFERRED) { ?>
						<th class="font-weight-bold"><?= lang("CommonMessage.common_active"); ?></th>
					<?php } ?>
					<th class="font-weight-bold"><?= lang("CommonMessage.common_action"); ?></th>
				</tr>
			</thead>
		</table>
	</div>
	<!--	</div>-->
</div>
<script type="text/javascript">
	var dt_DataTable;

	$(document).ready(function() {
		flatDd();
		dt_DataTable = $('#ownership_flat_table').DataTable({
			dom: '<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
				'<"me-5 ms-n2 pe-5"f>' +
				'<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
				'>t' +
				'<"row mx-2"' +
				'<"col-sm-12 col-md-6"i>' +
				'<"col-sm-12 col-md-6"p>' +
				'>',
			processing: true,
			serverSide: true,
			displayLength: 10,
			language: {
				sLengthMenu: 'Show _MENU_',
				search: '',
				searchPlaceholder: 'Search <?= lang($langName.'ownership_flat'); ?>',
				info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
			},
			scrollX: true,
			buttons: [
				{
					extend: 'collection',
					className: 'btn btn-label-secondary px-2 dropdown-toggle me-2 waves-effect waves-light',
					text: '<i class="ti ti-download me-1 ti-xs"></i>Export',
					buttons: [
						{
							text: '<i class="ti ti-file me-2" ></i>Excel',
							className: 'dropdown-item dt-excel-export'
						},
						// {
						// 	extend: 'pdf',
						// 	text: '<i class="ti ti-file-text me-2"></i>Pdf',
						// 	className: 'dropdown-item',
						//
						// }
					]
				},
				<?php if ($dtCIAcl->checkAccess("OwnershipFlat|manage")) { ?> {
						text: '<i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang($langName.'add_ownership_flat'); ?></span>',
						className: 'add-new btn btn-primary px-1 me-2',
						action: function() {
							window.location.href = '<?= $url; ?>';
						}
					},
				<?php } ?>
				<?php if ($dtCIAcl->checkAccess("OwnershipFlat|delete") && ($type != TRANSFERRED)) { ?> {
						text: '<i class="ti ti-trash me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang($langName.'delete_ownership_flat'); ?></span>',
						className: 'btn btn-danger  px-1 dt-delete-record',
					},
				<?php } ?>
			],
			"ajax": {
				"url": "<?php echo admin_url('OwnershipFlat/getOwnershipFlatListing'); ?>",
				"type": "POST",
				"data": function(d) {
					var params = {};
                    params["<?= csrf_token(); ?>"] = "<?= csrf_hash() ?>";
					params["type"] = '<?= $type; ?>';
					var filterData = $("#advanceFilter").serializeArray();
					$.each(filterData, function(i, val) {
						var name = val.name;
						if (typeof params[name] == 'undefined') {
							params[name] = val.value;
						} else if ($.isArray(params[name])) {
							params[name].push(val.value);
						} else {
							params[name] = [params[name]];
							params[name].push(val.value);
						}
					});

					return $.extend({}, d, params);
				}
			},
			"order": [
				[0, "desc"]
			],
			"columns": [{
					"data": "ownership_flat_id",
					"render": function(data, type, row) {
						return '<input class="form-check-input datatable-checkbox" type="checkbox" id="ids_' + row['ownership_flat_id'] + '" name="ids[]" value="' + row['ownership_flat_id'] + '"/>';
					},
					"class": "no_click_allowed",
					"sortable": false,
					"searchable": false
				},
				{
					"data": "flat_no",
					"class": "no_click_allowed",
					<?php if ($type != TRANSFERRED) { ?> "render": function(data, type, row) {
							var flatNo = row['flat_no'];
							var isTransferred = row['is_transferred'];
							if (isTransferred == 1) {
								return ' <div class=""> ' + flatNo +
									' <span class="badge  bg-label-success">Transferred</span> ' +
									'</div>';
							} else {
								return flatNo;
							}
						}
					<?php } else { ?> "render": function(data, type, row) {
							var flatNo = row['flat_no'];
							return flatNo;
						}
					<?php } ?>
				},
				{
					"data": "index_no"
				},
				{
					"data": "date_of_registry"
				},
                <?php if ($type != TRANSFERRED) { ?>
                {
                    "data": "buyer_name","searchable": false
                },
                {
                    "data": "purchased_from"
                },
                <?php } else { ?>
                {
                    "data": "buyer_name","searchable": false
                },
                {
                    "data": "purchased_from"
                },

                <?php } ?>
				{
					"data": "updated_by"
				},
				{
					"data": "updated_at"
				},
				<?php if ($type != TRANSFERRED) { ?> {
						"data": "is_active",
						"sortable": false,
						"searchable": false,
						"class": "no_click_allowed",
						"render": function(data, type, row) {
							var checked = (data == 1) ? "checked" : "";
							return '<label class="switch switch-primary switch-sm">' +
								'<input type="checkbox" class="switch-input  dt-active-status" ' + checked + '  data-id="' + row['ownership_flat_id'] + '" value="1" />' +
								'<span class="switch-toggle-slider">' +
								'<span class="switch-on"></span>' +
								'<span class="switch-off"></span>' +
								'</span>';
							'</label>';
						}
					},
				<?php } ?> {
					"data": "action_button",
					"class": "text-center no_click_allowed",
					"sortable": false,
					"searchable": false
				},

			],
			createdRow: function (row, data, dataIndex) {
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").addClass('dt-detail-model-view');
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").attr('data-dt_view_id', data['ownership_flat_id']);
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").attr('data-dt_view_module','<?= $type;?>');
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").attr('data-dt_view_url', '<?= admin_url("OwnershipFlat/view"); ?>');
			},
			"fnDrawCallback": function(oSettings, json) {
				customToolTip();
				$('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
				$('.dt-buttons').addClass('d-flex flex-wrap');
				$('.dataTables_filter .form-control').removeClass('form-control-sm');
				$('.dataTables_length .form-select').removeClass('form-select-sm');
				//checkBoxRefresh("datatable-checkbox");
				switcheryKeyGen("datatable-list-switchery");

			}
		});
		dtDataTableSearch();
	});


	$(document).on('click', '.dt-active-status', function() {
		var id = $(this).attr('data-id');
		var isActive = $(this).is(":checked") ? 1 : 0;
		$.ajax({
			type: 'post',
			url: '<?php echo admin_url('OwnershipFlat/changeStatus'); ?>',
			data: {
				ownership_flat_id: id,
				status: isActive,
				type: '<?= $type ?>'
			},
			dataType: 'json',
			success: function(data) {
				if (data) {
					Swal.fire({
						title: 'Success',
						text: data.msg,
						icon: 'success',
						customClass: {
							confirmButton: 'btn btn-primary waves-effect waves-light'
						},
						buttonsStyling: false
					}).then(function() {
						dt_DataTable.ajax.reload(null, false);
					});
				} else {
					Swal.fire({
						title: 'Error!',
						text: data.msg,
						icon: 'error',
						customClass: {
							confirmButton: 'btn btn-primary waves-effect waves-light'
						},
						buttonsStyling: false
					});
				}
			}
		});
	});



	//Delete Record
    $(document).on('click', '.dt-delete-record', function () {
        var id = $(this).attr("data-id");
        var deleteId = [];
        if(id != undefined){
            $('.datatable-select-all-second').prop('checked', false);
            $('.datatable-checkbox').prop('checked', false);
            $("#ids_" + id).prop("checked", true);
            deleteId.push(id);
        }
        else{
            var deleteElement =$('#ownership_flat_table tbody .datatable-checkbox:checked');
            var selectedLength = deleteElement.length;
            if (selectedLength == 0) {
                Swal.fire({
                    title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_info')); ?>",
                    text: "<?= lang('CommonMessage.delete_info'); ?>",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'OK',
                    customClass: {
                        confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                        cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                    },
                    buttonsStyling: false
                }).then(function () {
                    return false;
                });
            } else {
                $.each(deleteElement, function (i, ele) {
                    deleteId.push($(ele).val());
                });
            }
        }
        if (deleteId.length > 0) {
            Swal.fire({
                title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
                text: "<?= lang('CommonMessage.delete_warning'); ?>",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'OK',
                customClass: {
                    confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                    cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                },
                buttonsStyling: false
            }).then(function(result) {
                if (result.value) {
                    $.ajax({
                        type: "post",
                        url: "<?= admin_url("OwnershipFlat/delete") ?>",
                        dataType: "json",
                        data: {
                            ownership_flat_id: deleteId,
                            type: '<?= $type ?>'
                        },
                        success: function (data) {
                            if (data['success']) {
                                Swal.fire({
                                    title: 'Success',
                                    text: data['msg'],
                                    icon: 'success',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            } else {
                                Swal.fire({
                                    title: 'Error!',
                                    text: data['msg'],
                                    icon: 'error',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            }
                        }
                    });
                }
                else {
                    $('.datatable-checkbox').prop('checked', false);
                }
            });
        }
    });

	$(document).on('click', '.dt-excel-export', function() {
		$(this).removeClass(".dt-excel-export");
		var dataTableParams = dt_DataTable.ajax.params();
		url = '<?= admin_url('OwnershipFlat/excelExportOwnershipFlat/') . ""  ?>';
		var recursiveEncoded = $.param(dataTableParams);
		$('.dt-export-anchor').attr('href', url + "?" + recursiveEncoded);
		$('.dt-export-anchor')[0].click();
	});


	$(document).on('click', '.filter_data', function() {
		dt_DataTable.draw();
	});


	$(document).on('click', '.clear_filter', function() {
		$('form#advanceFilter  #filter_flat_id').val('').trigger('change');
		$("#filter_date_of_registry").val('');
		$("#filter_created_at").val('');
		$("#filter_updated_at").val('');
        dateRangePicker();
		dt_DataTable.draw();
	});
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
