<style>
	.form-controls {
		display: block;
		padding: 0.422rem 0.875rem;
		font-size: 0.9375rem;
		font-weight: 400;
		line-height: 1.5;
		color: #6f6b7d;
		appearance: none;
		background-color: #fff;
		background-clip: padding-box;
		border: var(--bs-border-width) solid #dbdade;
		border-radius: var(--bs-border-radius);
		transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
	}
</style>

<?php
$type = $request->getPost('type');
$html = '';
if (isset($ownership_flat_emergency_contact_data) && !empty($ownership_flat_emergency_contact_data)) {
	foreach ($ownership_flat_emergency_contact_data as $key => $value) {
		$data["contact_row_number"] = $key + 1;
		$data["ownership_flat_emergency_contact_data"] = $value;
		$html .= view('Admin/OwnershipFlat/OwnershipFlatEmergencyContactRowView', $data);
	}
}
?>
<!-- Responsive Table -->
	<div class="table-responsive text-nowrap">
		<table id="ownership_flat_emergency_contact_table" class="table">
			<thead>
			<tr class="text-nowrap">
				<th><?= lang('CommonMessage.common_sr_no'); ?></th>
				<th><?= lang('OwnershipFlat.e_name'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('OwnershipFlat.e_place'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('OwnershipFlat.e_relation'); ?></th>
				<th><?= lang('OwnershipFlat.e_mobile'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('CommonMessage.common_action'); ?></th>
			</tr>
			</thead>
			<tbody class="table-border-bottom-0">
			<?php
			if (isset($ownership_flat_emergency_contact_data) && !empty($ownership_flat_emergency_contact_data)) {
				echo $html;
			}else { ?>
				<?php
				$data["contact_row_number"] =  1;
				echo view('Admin/OwnershipFlat/OwnershipFlatEmergencyContactRowView',$data); ?>
			<?php } ?>

			</tbody>
		</table>
	</div>
<!--/ Responsive Table -->
<script>
	var contactRowNumber;

	function addOwnershipFlatEmergencyContact() {
		var lastIndex = ($("#ownership_flat_emergency_contact_table tbody tr:last").length >= 1) ? $("#ownership_flat_emergency_contact_table tbody tr:last").attr("data-id").split("_").pop() : 0;
		rowNumber = parseInt(lastIndex) + 1;
		$.ajax({
			type: "post",
			url: "<?= admin_url('OwnershipFlat/addOwnershipFlatEmergencyContactRow'); ?>",
			dataType: "html",
			async: false,
			data: {
				contact_row_number: contactRowNumber,
			},
			success: function (data) {
				if (data) {
					$('table#ownership_flat_emergency_contact_table tbody').append(data);
					addSerialNumber('ownership_flat_emergency_contact_table');
                    $('.dt-ecrelation').select2();
					emergencyContact();
					customToolTip();
				}
			}
		});
	}


	$(document).on('click', '.dt-delete-emergency-contact-row', function () {
		var trField = $(this).closest('tr');
		var id = $(this).closest('tr').find(".ownership_flat_emergency_contact_id").val();
		var ownershipFlatId = $("#ownership_flat_id").val();

		if (id != '') {
				Swal.fire({
					title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
					text: "<?= lang('CommonMessage.delete_warning'); ?>",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'OK',
					customClass: {
						confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
						cancelButton: 'btn btn-label-secondary waves-effect waves-light'
					},
					buttonsStyling: false

			}).then(function (result) {
				if (result.value) {
					var deleteId = [];
					deleteId.push(id);
					$.ajax({
						type: "POST",
						url: "<?php echo admin_url('OwnershipFlat/deleteOwnershipFlatEmergencyContactRow');?>",
						dataType: "json",
						async:false,
						data: {
							ownership_flat_emergency_contact_id: deleteId,
							ownership_flat_id: ownershipFlatId,
							type : '<?= $type;?>'
						},
						success: function (resObj) {
							if (resObj.success) {
								$(trField).remove();
								addSerialNumber('ownership_flat_emergency_contact_table');
								Swal.fire({
									title: 'Success',
									text: resObj['msg'],
									icon: 'success',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								}).then(function() {
									if ($('#ownership_flat_emergency_contact_table tbody > tr').length == 0) {
										addOwnershipFlatEmergencyContact();
									}
								});
							} else {

								Swal.fire({
									title: 'Error!',
									text: resObj['msg'],
									icon: 'error',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								});
							}
						}
					});
				}
			});
		} else {
			$(trField).remove();
			addSerialNumber('ownership_flat_emergency_contact_table');
			if ($('#ownership_flat_emergency_contact_table tbody > tr').length == 0) {
				addOwnershipFlatEmergencyContact();
			}
		}
	});


</script>
