<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$typeId = (isset($type_id) && !empty($type_id)) ? $type_id : '';
?>
<?= isset($advance_filter) ? $advance_filter : ""; ?>

<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>
<!-- DataTable with Buttons -->
<div class="card">
	<div class="card-datatable table-responsive text-nowrap">
		<table id="notification_table" class="table dt-datatable ">
			<thead class="border-top">
			<tr>
				<th><input class="form-check-input datatable-select-all-second" type="checkbox"  /></th>
				<th class="font-weight-bold"><?= lang("Notification.notification_title"); ?></th>
				<th class="font-weight-bold"><?= lang("Notification.notification_date"); ?></th>
				<th class="font-weight-bold"><?= lang("Notification.notification_for"); ?></th>
				<th class="font-weight-bold"><?= lang("Notification.send_for_notification"); ?></th>
				<th class="font-weight-bold"><?= lang("Notification.send_for_notification_id"); ?></th>
				<th class="font-weight-bold"><?= lang("Notification.receive_for_notification"); ?></th>
				<th class="font-weight-bold"><?= lang("Notification.receive_for_notification_id"); ?></th>
				<th class="font-weight-bold"><?= lang("Notification.description"); ?></th>
				<th class="font-weight-bold"><?= lang("Notification.type"); ?></th>
				<th class="font-weight-bold"><?= lang("Notification.type_id"); ?></th>
				<th class="font-weight-bold"><?= lang("Notification.action_type"); ?></th>
				<th class="font-weight-bold"><?= lang('CommonMessage.common_updated_by'); ?></th>
				<th class="font-weight-bold"><?= lang('CommonMessage.common_updated_at'); ?></th>
			</tr>
			</thead>
		</table>
	</div>
	<!--	</div>-->
</div>
<script type="text/javascript">
	var dt_DataTable;
	$(document).ready(function () {
		$("#action_type").select2();
		$("#notification_type").select2();
		dt_DataTable = $('#notification_table').DataTable( {
			dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
				'<"me-5 ms-n2 pe-5"f>' +
				'<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
				'>t' +
				'<"row mx-2"' +
				'<"col-sm-12 col-md-6"i>' +
				'<"col-sm-12 col-md-6"p>' +
				'>',
			processing: true,
			serverSide: true,
			displayLength: 10,
			// Scroll options
			// scrollY: '300px',
			scrollX: true,
			// language: {
			// 	sLengthMenu: 'Show _MENU_',
			// 	search: '',
			// 	searchPlaceholder: 'Search <?= lang('notification');?>',
			// 	info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
			// },
			language: {
                sLengthMenu: 'Show _MENU_',
                search: '',
                searchPlaceholder: 'Search Notification',
                info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
            },
			buttons: [
				// {
				// 	extend: 'collection',
				// 	className: 'btn btn-label-secondary px-2 dropdown-toggle me-2 waves-effect waves-light',
				// 	text: '<i class="ti ti-download me-1 ti-xs"></i>Export',
				// 	buttons: [
						
				// 	]
				// },
			],
			"ajax": {
				"url": "<?php echo admin_url('Notification/getNotificationListing'); ?>",
				"type": "POST",
				"data": function(d) {
                    var params = {};
                    params["<?= csrf_token(); ?>"] = "<?= csrf_hash() ?>";
                    params['notification_type_id'] = "<?= $typeId?>";
                    var filterData = $("#advanceFilter").serializeArray();
                    $.each(filterData, function(i, val) {
                        var name = val.name;
                        if (typeof params[name] == 'undefined') {
                            params[name] = val.value;
                        } else if ($.isArray(params[name])) {
                            params[name].push(val.value);
                        } else {
                            params[name] = [params[name]];
                            params[name].push(val.value);
                        }
                    });

                    return $.extend({}, d, params);
                }
			},
			"stateSave": true,
			"order": [[ 0, "asc" ]],
			"columns": [
				{
					"data": "notification_id",
					"render": function (data, type, row) {
						return '<input class="form-check-input datatable-checkbox" type="checkbox" id="ids_' + row['notification_id'] + '" name="ids[]" value="' + row['notification_id'] + '"/>';
					},
					"class": "no_click_allowed",
					"sortable": false,
					"searchable": false
				},
				{"data": "notification_title" },
				{"data": "notification_date" },
				{"data": "notification_for" },
				{"data": "send_for_notification" },
				{"data": "send_for_notification_name",
					"sortable": false,
					"searchable": false
				},
				{"data": "receive_for_notification" },
				{"data": "receive_for_notification_name",
					"sortable": false,
					"searchable": false
				},
				{"data": "description" },
				{"data": "type" },
				{"data": "type_name",
					"sortable": false,
					"searchable": false
				},
				{"data": "action_type"},
				{"data": "updated_by"},
				{"data": "updated_at"},
			],
			"fnDrawCallback": function (oSettings, json) {
				customToolTip();
				$('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
				$('.dt-buttons').addClass('d-flex flex-wrap');
				$('.dataTables_filter .form-control').removeClass('form-control-sm');
				$('.dataTables_length .form-select').removeClass('form-select-sm');
				//checkBoxRefresh("datatable-checkbox");
				switcheryKeyGen("datatable-list-switchery");

			}
		});
		dtDataTableSearch();
	});

	$(document).on('click', '.filter_data', function() {
		dt_DataTable.draw();
	});

	$(document).on('click', '.clear_filter', function() {
		$('form#advanceFilter  #action_type').val('').trigger('change');
		$('form#advanceFilter  #notification_type').val('').trigger('change');
		$("#filter_created_at").val('');
		$("#filter_updated_at").val('');
		dateRangePicker();
		dt_DataTable.draw();
	});
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
