<?php 
?><ul class="nav nav-tabs" role="tablist">
    <li class="nav-item">
        <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#notice_detail" aria-controls="notice_detail" aria-selected="true">
            <?= lang('Notice.notice_details'); ?>
        </button>
    </li>
    <li class="nav-item">
        <button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#attached-document" aria-controls="attached-document" aria-selected="false">
            <?= lang('Notice.media_information_details'); ?>
        </button>
    </li>
</ul>

<div class="tab-content">
    <div class="tab-pane fade show active" id="notice_detail" role="tabpanel">
        <div class="table-responsive text-nowrap">
            <table id="notice_detail_table" class="table table-xs">
                <thead>
                    <tr>
                        <th><?= lang("CommonMessage.common_detail"); ?></th>
                        <th><?= lang("CommonMessage.common_value"); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(($notice_data['recipient']) && ($notice_data['recipient'] != "all_management_committee_members(only_mc_members)")) {?>
                    <tr>
                        <td><?= lang("Notice.notified_to"); ?></td>
                        <td><?php
                            $notifiedToTypes = notifiedToType();
                            $selectedNotifiedTypes = isset($notice_data['notified_to']) ? $notice_data['notified_to'] : '';
                            foreach ($notifiedToTypes as $notifiedKey => $notify) { 
                                 echo ($selectedNotifiedTypes == $notifiedKey) ? $notify : '' ; 
                                       
                             } 
                            ?>
                        </td>
                    </tr>
                    <?php } ?>
                    <tr>
                        <td><?= lang("Notice.notice_title"); ?></td>
                        <td><?php
                            echo (isset($notice_data['notice_title']) && $notice_data['notice_title'] != "") ? ($notice_data['notice_title']) : '-';
                            ?>
                        </td>
                    </tr>

                    <?php if(($notice_data['notified_to']) && ($notice_data['notified_to'] == "selected_towers")) {?>
                    <tr>
                    
						<td><?= lang("Notice.tower"); ?></td>
						<td><?php
							    if(isset($notice_tower_data) && !empty($notice_tower_data)) {
							    echo implode(' , ', array_column($notice_tower_data, 'tower_name'));
						    }?>
						</td>
					</tr>
                    
                    <?php } ?>

                    <?php if(($notice_data['notified_to']) && ($notice_data['notified_to'] == "selected_flats")) {?>
                    <tr>
						<td><?= lang("Notice.flat"); ?></td>
						<td><?php
							    if(isset($notice_flat_data) && !empty($notice_flat_data)) {
							    echo implode(' , ', array_column($notice_flat_data, 'flat_no'));
						    }?>
						</td>
					</tr>
                    <?php } ?>

                    <tr>

                        

                        <td><?= lang("Notice.category"); ?></td>
                        <td>
                            <?php
							    if(isset($notice_category_data) && !empty($notice_category_data)) {
							    echo implode(' , ', array_column($notice_category_data, 'category_name'));
						    }?>
                        </td>
                    </tr>
                    <tr>
                        <td><?= lang("Notice.recipients"); ?></td>
                        <td><?php
                            $recipients = recipient();
                            $selectedRecipientsTypes = isset($notice_data['recipient']) ? $notice_data['recipient'] : "";
                            foreach ($recipients as $recipientsKey => $recipient) { 
                                 echo ($selectedRecipientsTypes == $recipientsKey) ? $recipient : '' ; 
                                       
                             } 
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td><?= lang("Notice.notice_date"); ?></td>
                        <td><?php
                            echo (isset($notice_data['notice_date']) && $notice_data['notice_date'] != "") ? siteDateFormat($notice_data['notice_date']) : '-';
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td><?= lang("Notice.expiry_date"); ?></td>
                        <td><?php
                            echo (isset($notice_data['expiry_date']) && $notice_data['expiry_date'] != "") ? siteDateFormat($notice_data['expiry_date']) : '-';
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td><?= lang("Notice.description"); ?></td>
                        <td><?php
                            echo (isset($notice_data['description']) && $notice_data['description'] != "") ? ($notice_data['description']) : '-';
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
                        <td><?php
                            echo (isset($notice_data['created_at']) && isValidDate($notice_data['created_at'])) ? siteDateFormat($notice_data['created_at'], TRUE) : '-';
                            ?></td>
                    </tr>
                    <tr>
                        <td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
                        <td><?php
                            echo (isset($notice_data['created_by']) && $notice_data['created_by'] != "") ? $notice_data['created_by'] : '-';
                            ?></td>
                    </tr>
                    <tr>
                        <td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
                        <td><?php
                            echo (isset($notice_data['updated_at']) && isValidDate($notice_data['updated_at'])) ? siteDateFormat($notice_data['updated_at'], TRUE) : '-';
                            ?></td>
                    </tr>
                    <tr>
                        <td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
                        <td><?php
                            echo (isset($notice_data['updated_by']) && $notice_data['updated_by'] != "") ? $notice_data['updated_by'] : '-';
                            ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div class="tab-pane fade" id="attached-document" role="tabpanel">
        <div class="table-responsive text-nowrap">
            <table id="media_information_detail" class="table table-bordered">
                <thead>
                    <tr>
                        <th class="text-center" style="width: 5%"><?= lang("CommonMessage.common_sr_no"); ?></th>
                        <th style="width: 10%"><?= lang("Media.media_type"); ?></th>
                        <th style="width: 10%"><?= lang("Media.media_title"); ?></th>
                        <th style="width: 10%"><?= lang("Media.sort_order"); ?></th>
                        <th style="width: 10%"><?= lang("Media.media_file"); ?></th>
                    </tr>
                </thead>
                <tbody class="">
                    <?php if ($media_data != '' && array_filter($media_data)) {
                        $sr = 1;
                        foreach ($media_data as $key => $value) { ?>
                            <tr>
                                <td class="text-center"><?= $sr; ?></td>
                                <td colspan="1"><?= $value['media_type']; ?> </td>
                                <td colspan="1"><?= $value['media_title']; ?> </td>
                                <td colspan="1"><?= $value['media_sort_order']; ?> </td>
                                <td colspan="1">
                                    <?php if (isset($value['media_file']) && $value['media_file'] != '') { ?>
                                        <?php
                                        $paths = base_url() . MEDIA_IMAGE_PATH . $value['media_file'];
                                        $thumbnailPaths = base_url() . THUMBNAIL_MEDIA_IMAGE_PATH . $value['media_file'];
                                        if (file_exists(MEDIA_IMAGE_PATH . $value['media_file'])) { ?>
                                            <?php if ($value['media_type'] == 'image') { ?>
                                                <br />
                                                <a href="<?= $paths; ?>" target="_blank">
                                                    <img src="<?= $thumbnailPaths; ?>" style="width: 60px; height: 60px;" class="img-rounded"
                                                        alt=""></a>
                                            <?php } ?>
                                            <?php if ($value['media_type'] == 'audio') { ?>
                                                <br />
                                                <audio controls>
                                                    <source src="<?= $paths; ?>" type="audio/mpeg">
                                                </audio>
                                            <?php } ?>
                                            <?php if ($value['media_type'] == 'video') { ?>
                                                <br />
                                                <a href="<?= $paths; ?>" target="_blank"> <video width="160" height="120" controls>
                                                        <source src="<?= $paths; ?>" type="video/mp4"> </a>
                                            <?php } ?>
                                            <?php if ($value['media_type'] == 'pdf') {
                                                $fileUrl = site_url('uploads/pdf_image.jpg'); ?>
                                                <br />
                                                <a href="<?= $paths; ?>" target="_blank"><img src="<?= $fileUrl; ?>" style="width: 60px; height: 60px;" class="img-rounded" alt=""></a>
                                            <?php } ?>
                                        <?php } else { ?>
                                            <br />
                                            <img src="<?= base_url('uploads/no_image.png') ?>" style="width: 80px; height: 80px;"
                                                class="img-rounded" alt="">
                                        <?php } ?>
                                    <?php } ?>
                                </td>
                            </tr>
                        <?php $sr++;
                        }
                    } else {   ?>
                        <tr>
                            <td colspan="5" align="center"> <?= lang('CommonMessage.no_data_found'); ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>