<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Notice.notice_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_notice',
				);
				echo form_open_multipart('',$form_id);
				$noticeId = (isset($notice_data['notice_id']) && ($notice_data['notice_id'] != '')) ? $notice_data['notice_id'] : '';
				// printArray($notice_data['notified_to'],1);
				?>
				<input type="hidden" id="notice_id" name="notice_id" value="<?= $noticeId ?>">
				<input type="hidden" id="category_for" name="category_for" value="notice">
				<div class="row mb-3 dt-notified-to">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Notice.notified_to');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
						<?php
							$notifiedToTypes = notifiedToType();
						?>
						<select data-placeholder="Select  <?= lang('Notice.notified_to'); ?>" name="notified_to" id="notified_to" class="form-control select dt-notified-to-type">
							<!-- <option value=""> </option> -->
							<?php
							$selectedNotifiedToTypes = isset($notice_data['notified_to']) ? $notice_data['notified_to'] : "";
							foreach ($notifiedToTypes as $eventKey => $event) { ?>
								<option <?= ($selectedNotifiedToTypes == $eventKey) ? "selected" : ""; ?>
									value="<?= $eventKey; ?>"> <?= $event; ?> </option>
							<?php } ?>
						</select>
						</div>
            	</div>
				<div class="row mb-3 dt-tower">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Notice.tower');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<select data-placeholder="Select <?= lang('Notice.tower');?>" name="tower_id[]"
							id="tower_id" class="select2 form-select form-select-lg towerDd" multiple>
						<?php
						if(isset($notice_tower_data) && !empty($notice_tower_data)) {
							foreach ($notice_tower_data as  $towerElement){ ?>
								<option  value="<?= isset($towerElement['tower_id']) ? $towerElement['tower_id'] : ""; ?>" selected> <?= $towerElement['tower_name']; ?> </option>
							<?php  }
						} ?>
						</select>
					</div>
				</div>
				<div class="row mb-3 dt-flat">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Notice.flat');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<select data-placeholder="Select <?= lang('Notice.flat');?>" name="flat_id[]"
							id="flat_id" class="select2 form-select form-select-lg ownerflatDd" multiple>
						<?php
						if(isset($notice_flat_data) && !empty($notice_flat_data)) {
							foreach ($notice_flat_data as  $flatElement){ ?>
								<option  value="<?= isset($flatElement['flat_id']) ? $flatElement['flat_id'] : ""; ?>" selected> <?= $flatElement['flat_no']; ?> </option>
							<?php  }
						} ?>
						</select>
					</div>
				</div>
				<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Notice.notice_title');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="notice_title" id="notice_title" placeholder="Enter <?= lang('Notice.notice_title');?>" value="<?= (isset($notice_data['notice_title']) && ($notice_data['notice_title'] != '')) ? $notice_data['notice_title'] : '';  ?>" />
						</div>
				</div>
                <div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Notice.category');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<select data-placeholder="Select  <?= lang('Notice.category'); ?>" name="category_id[]"
								id="category_id" class="form-control categoryDd" multiple>
							
							<?php
							if(isset($notice_category_data) && !empty($notice_category_data)) {
								foreach ($notice_category_data as  $noticeElement){ ?>
									<option  value="<?= isset($noticeElement['category_id']) ? $noticeElement['category_id'] : ""; ?>" selected> <?= $noticeElement['category_name']; ?> </option>
								<?php  }
							} ?>
							</select>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Notice.recipients');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<?php
								$recipients = recipient();
							?>
							<select data-placeholder="Select  <?= lang('Notice.recipients'); ?>" name="recipient"
								id="recipient" class="select2 form-select dt-recipient-type">
								<option value=""> </option>
								<?php
								$selectedNoticeType = isset($notice_data['recipient']) ? $notice_data['recipient'] : "";
								foreach ($recipients as $receipentKey => $recipient) { ?>
									<option <?= ($selectedNoticeType == $receipentKey) ? "selected" : ""; ?>
										value="<?= $receipentKey; ?>"> <?= $recipient; ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>
					<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Notice.notice_date');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<td>
							<input type="text"  name="notice_date" id="notice_date" class="form-control dt-notice-date" placeholder="Select <?= lang('Notice.notice_date'); ?>" value="<?= isset($notice_data['notice_date']) ? YMDToDMY($notice_data['notice_date']): ""; ?>"/>
						</td>
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Notice.expiry_date');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<td>
							<input type="text"  name="expiry_date" id="expiry_date" class="form-control dt-expiry-date" placeholder="Select <?= lang('Notice.expiry_date'); ?>" value="<?= isset($notice_data['expiry_date']) ? YMDToDMY($notice_data['expiry_date']): ""; ?>"/>
						</td>
					</div>
				</div>

				<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Notice.description');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<textarea name="description"  id="description" placeholder="Enter <?= lang('Notice.description'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($notice_data['description']) && ($notice_data['description'] != '')) ? $notice_data['description'] : ''; ?></textarea>
						</div>
					
                </div>

			<hr class="my-4 mx-n4" />
			<h6><?= lang('Media.media_information'); ?></h6>
			<div class="row g-3">
				<?= isset($media_table) ? $media_table : ""; ?>
    		</div>
			<?php if ($dtCIAcl->checkAccess('Notice|manage')) { ?>
				<button type="button" class="btn btn-sm btn-primary" onclick="addMediaItem()" data-bs-popup='tooltip' title="<?= lang('CommonMessage.common_add_media') ?>">
            		<i class="ti ti-plus me-1"></i>
            		<span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
        		</button>
   			 <?php } ?>
           

					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Notice'); ?>'" class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
    	categoryDd();
		ownerflatDd();
		towerDd();
		addSerialNumber('media_table');
		switcheryKeyGen("datatable-list-switchery");
		ckEditorInit('description');
		$('.dt-media-type').select2();
		$('.dt-recipient-type').select2();
		$('.dt-notified-to-type').select2();
		$('.dt-notified-to-type').change();
		$('.dt-recipient-type').change();

		var noticeDate = $(".dt-notice-date").flatpickr({
			//monthSelectorType: 'static',
			dateFormat: 'd-m-Y',
		});
		var expiryDate = $(".dt-expiry-date").flatpickr({
			//monthSelectorType: 'static',
			dateFormat: 'd-m-Y',
		});
        // Initialize
		var validator = $("#form_notice").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				notice_title: {
					required: true
				},
				"category_id[]": {
					required: true
				},
				recipient: {
					required: true
				},
				notified_to: {
					required: true
				},
				"tower_id[]" : {
                    required: "#tower_id:visible",
                },
				"flat_id[]" : {
                    required: "#flat_id:visible",
                },
				notice_date: {
					required: true
				},
				expiry_date: {
					required: true
				},
				description: {
					required: true
				},
            },
            messages: {
				notice_title: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Notice.notice_title');?>"
				},
				"category_id[]": {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Notice.category');?>"
				},
				recipient: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Notice.recipients');?>"
				},
				notified_to: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Notice.notified_to');?>"
				},
				"tower_id[]": {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Notice.tower');?>"
				},
				"flat_id[]": {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Notice.flat');?>"
				},
				notice_date: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Notice.notice_date');?>"
				},
				expiry_date: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Notice.expiry_date');?>"
				},
				description: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Notice.description');?>"
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Notice/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Notice');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Notice');?>';
							// }, 1000);

						} else {
							dtButtonShow("#submitBtn");
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
    });

	$(document).on('change', '.dt-notified-to-type', function () {
		var notifiedToType = $(this).val();
		if ((notifiedToType) == 'selected_towers' && $('#notified_to').is(':visible')) {
			$(".dt-tower").show();
			$(".dt-flat").hide();
			$(".flatDd").val('').trigger('change.select2');
		} else if((notifiedToType) == 'selected_flats' && $('#notified_to').is(':visible')) {
			$(".dt-flat").show();
			$(".dt-tower").hide();
			$(".towerDd").val('').trigger('change.select2');
		} else {
			$(".dt-flat").hide();
			$(".dt-tower").hide();
		}
	});

	$(document).on('change', '.dt-recipient-type', function () {
		var receipentType = $(this).val();
		if ((receipentType) == 'all_management_committee_members(only_mc_members)') {
			$(".dt-notified-to").hide();
		} else {
        	$(".dt-notified-to").show();
    	}
		$('.dt-notified-to-type').change();
		var notifiedToType = $('.dt-notified-to-type').val();
		if ((notifiedToType) != 'selected_towers') {
			$(".towerDd").val('').trigger('change.select2');
			$(".dt-notified-to").val('');
		} else if((notifiedToType) != 'selected_flats') {
			$(".flatDd").val('').trigger('change.select2');
			$(".dt-notified-to").val('');
		} else {
			$(".dt-flat").hide();
			$(".dt-tower").hide();
		}
	});
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
