<?php
$rowNumber = isset($row_number) ? $row_number : 0;
$mediaData = isset($mediaData) ? $mediaData : 0;
?>
<tr data-id="tr_<?= $rowNumber; ?>">
    <td scope="row" class="dt-serial_number"></td>
    <td>
        <?php
         $mediaTypes = mediaType();
        ?>
        <input type="hidden" name="media_id[<?= $rowNumber; ?>]" class="media_id"
               value="<?= isset($mediaData['media_id']) ? $mediaData['media_id'] : ""; ?>">
        <input type="hidden" name="common_media[<?= $rowNumber; ?>]" class="common_media"
               value="<?= isset($mediaData['media_file']) ? $mediaData['media_file'] : ""; ?>">

        <select <?= lang('media_type'); ?> name="media_type[<?= $rowNumber; ?>]" id="media_type[<?= $rowNumber; ?>]" class="form-control select dt-media-type">
            <option value="">Select Media Type</option>

            <?php
            $selectedMediaTypes = isset($mediaData['media_type']) ? $mediaData['media_type']: "";
            foreach ($mediaTypes as $mediaKey => $mediaType) { ?>
                <option <?= ($selectedMediaTypes == $mediaKey) ? "selected" : ""; ?>
                        value="<?= $mediaKey; ?>"> <?= $mediaType; ?> </option>
            <?php } ?>
        </select>
    </td>
    <td>

        <input type="text" name="media_title[<?= $rowNumber; ?>]" id="media_title_<?= $rowNumber; ?>"
               class="form-control media-title"
               value="<?= isset($mediaData['media_title']) ? $mediaData['media_title'] : ""; ?>"
               placeholder="Enter <?= lang("Media.media_title"); ?>">
    </td>
    <td>
        <input type="text" name="sort_order[<?= $rowNumber; ?>]" id="sort_order<?= $rowNumber; ?>"
               class="form-control sort-order numberInit"
               value="<?= isset($mediaData['media_sort_order']) ? $mediaData['media_sort_order'] : ""; ?>"
               placeholder="Enter <?= lang("Media.sort_order"); ?>">
    </td>
    <td>
        <?php
        $imageExtension = array('jpeg' => 'jpeg', 'png' => 'png', 'pdf' => 'pdf', 'mp4' => 'mp4','mp3' => 'mp3');
        $imageAccept = imageAcceptExtension($imageExtension);
        $acceptImageFormat = '';
        foreach ($imageAccept as $image) {
            $acceptImageFormat = $acceptImageFormat ? $acceptImageFormat . ',' . $image : $image;
        }
        ?>
        <input type="file" accept="<?= $acceptImageFormat; ?>" class="form-control"
               name="media_file[<?= $rowNumber; ?>]"
               id="media_file_<?= $rowNumber; ?>"
               data-show-caption="false" data-show-upload="false"
               data-remove-class="btn btn-default"
               value="<?= isset($mediaData['media_file']) ? $mediaData['media_file'] : ""; ?>">
        <span class="form-text text-muted"><?= IMAGE_PDF_UPLOAD_MESSAGE; ?></span>

        <?php if (isset($mediaData['media_file']) && $mediaData['media_file'] != '') { ?>
            <?php
            $paths = base_url() . MEDIA_IMAGE_PATH . $mediaData['media_file'];
            $thumbnailPaths = base_url() . THUMBNAIL_MEDIA_IMAGE_PATH . $mediaData['media_file'];
            if (file_exists(MEDIA_IMAGE_PATH . $mediaData['media_file'])) { ?>
                <?php if ($mediaData['media_type'] == 'image') { ?>
                    <br/>
                    <a href="<?= $paths; ?>" target="_blank">
                        <img src="<?= $thumbnailPaths; ?>" style="width: 60px; height: 60px;" class="img-rounded"
                                                                  alt=""></a>
                <?php } ?>
                <?php if ($mediaData['media_type'] == 'audio') { ?>
                    <br/>
                    <audio controls><source src="<?= $paths; ?>" type="audio/mpeg"> </audio>
                <?php } ?>
                <?php if ($mediaData['media_type'] == 'video') { ?>
                    <br/>
                    <a href="<?= $paths; ?>" target="_blank"> <video width="160" height="120" controls> <source src="<?= $paths; ?>" type="video/mp4"> </a>
                <?php } ?>
                <?php if ($mediaData['media_type'] == 'pdf') { 
                        $fileUrl = site_url('uploads/pdf_image.jpg');?>
                    <br/>
                    <a href="<?= $paths; ?>" target="_blank"><img src="<?= $fileUrl; ?>" style="width: 60px; height: 60px;" class="img-rounded" alt=""></a>
                <?php } ?>
            <?php } else { ?>
                <br/>
                <img src="<?= base_url('uploads/no_image.png') ?>" style="width: 80px; height: 80px;"
                     class="img-rounded" alt="">
            <?php } ?>
        <?php } ?>
    </td>

    <td>
    <button type="button"
                        class=" rounded-pill waves-effect btn btn-sm btn-icon btn-danger dt-delete-media-row"
                        data-bs-toggle="tooltip"
                        data-bs-placement="top" title="<?= lang('Media.delete_media') ?>">
                    <i class="ti ti-trash"></i>
                </button>

    </td>
</tr>
