<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$session = \Config\Services::session();
$prefix = MATERIAL_PREFIX;
$materialView = isset($material_data['view']) ? $material_data['view'] : 0;
?>
    <!-- Multi Column with Form Separator -->
    <div class="card mb-4">
        <h5 class="card-header"><?= lang('Material.material_form'); ?>

        </h5>
        <?php
        //create  form open tag
        $form_id = array(
            'id' => 'form_material',
            'class' => 'card-body',
        );
        echo form_open_multipart('', $form_id);
        $materialId = (isset($material_data['material_id']) && ($material_data['material_id'] != '')) ? $material_data['material_id'] : '';
        ?>
        <input type="hidden" id="material_id" name="material_id" value="<?= $materialId ?>">
        <h6>1. <?= lang('Material.material_basic_information') ?></h6>
        <div class="row g-3">
            <div class="col-md-3">
                <label class="form-label"><?= lang('CommonMessage.common_prefix'); ?></label>
                <input type="text" id="prefix" name="prefix" class="form-control customerWarehousePrefix"
                       placeholder="Enter <?= lang('CommonMessage.common_prefix'); ?>"
                       value="<?= isset($material_data['prefix']) ? $material_data['prefix'] : $prefix; ?>" readonly/>
            </div>

            <div class="col-md-3">
                <label class="form-label"><?= lang('CommonMessage.common_series'); ?></label>
                <input type="text" id="series" name="series" class="form-control series"
                       placeholder="Enter <?= lang('CommonMessage.common_series'); ?>"
                       value="<?= isset($material_data['series']) ? $material_data['series'] : ""; ?>" readonly/>
            </div>

            <div class="col-md-6">
                <label class="form-label" for="basic-default-name"><?= lang('Material.material_date'); ?><span
                            class="text-danger"> *</span></label>
                <input type="text" class="form-control" name="material_date" id="material_date"
                       placeholder="Select <?= lang('Material.material_date'); ?>"
                       value="<?= (isset($material_data['material_date']) && isValidDate($material_data['material_date'])) ? siteDateFormat($material_data['material_date']) : date('Y-m-d'); ?>"

                />

            </div>

            <div class="col-md-6">
                <label class="form-label"><?= lang('Material.common_area'); ?><span
                            class="text-danger"> *</span></label>
                <select id="common_area_id" name="common_area_id" class="select2 form-select commonAreaDd">
                    <option></option>
                    <?php if (isset($material_data['common_area_id']) && $material_data['common_area_id'] != 0) { ?>
                        <option value="<?= isset($material_data['common_area_id']) ? $material_data['common_area_id'] : 0 ?>"
                                selected> <?= isset($material_data['common_area_name']) ? $material_data['common_area_name'] : '' ?> </option>
                    <?php } ?>
                </select>
            </div>


            <div class="col-md-6">
                <label class="form-label"><?= lang('AMC.financial_year'); ?><span class="text-danger"> *</span></label>
                <select id="financial_year_id" name="financial_year_id" class="select2 form-select  financialYearDd"
                        data-allow-clear="true">
                    <option></option>
                    <?php if (isset($material_data['financial_year_id']) && $material_data['financial_year_id'] != 0) { ?>
                        <option value="<?= isset($material_data['financial_year_id']) ? $material_data['financial_year_id'] : 0 ?>"
                                selected> <?= isset($material_data['financial_year_prefix']) ? $material_data['financial_year_prefix'] : '' ?> </option>
                    <?php } ?>
                </select>
            </div>

            <div class="col-md-6">
                <label class="form-label" for="multicol-username"><?= lang('Material.material_type'); ?><span
                            class="text-danger"> *</span></label>
                <?php
                $materialTypes = materialType();
                $selectedMaterialTypes = isset($material_data['material_type']) ? $material_data['material_type'] : "";
                ?>
                <select name="material_type" id="material_type" class="form-control dt-material-type"
                        data-placeholder="Select  <?= lang('Material.material_type'); ?>">
                    <option> </option>
                    <?php
                    foreach ($materialTypes as $material => $materialType) {
                        ?>
                        <option <?= ($selectedMaterialTypes == $material) ? "selected" : ""; ?>
                                value="<?= $material; ?>"> <?= $materialType; ?> </option>
                    <?php } ?>

                </select>
            </div>

            <div class="col-md-6">
                <?php
                $hideMaterialForClassName = '';
                if($materialId != '' && $selectedMaterialTypes != 'inwards'){
                    $hideMaterialForClassName = 'd-lg-none';
                }
                ?>
                <div class="materialForDiv <?= $materialId == !'' ? $hideMaterialForClassName : 'd-lg-none'; ?>" >
                    <?php
                    $materialFor = materialFor();
                    $selectedMaterialFor = isset($material_data['material_for']) ? $material_data['material_for'] : "";
                    ?>

                    <label class="form-label"><?= lang('Material.material_for'); ?><span
                                class="text-danger"> </span></label>
                    <select id="material_for" name="material_for" class="select2 form-select dt-material-for"
                            data-placeholder="Select  <?= lang('Material.material_for'); ?>">
                        <option></option>
                        <?php
                        foreach ($materialFor as $materialForKey => $materialForElement) {
                            ?>
                            <option <?= ($selectedMaterialFor == $materialForKey) ? "selected" : ""; ?>
                                    value="<?= $materialForKey; ?>"> <?= $materialForElement; ?> </option>
                        <?php } ?>

                    </select>
                </div>
            </div>

            <div class="col-md-6">
                <?php
                $hideMaterialReturnClassName = '';
                if($materialId != '' && $selectedMaterialFor != 'return'){
                    $hideMaterialReturnClassName = 'd-lg-none';
                }
                ?>


                <div class="materialReturnForDiv <?= $materialId == !'' ? $hideMaterialReturnClassName : 'd-lg-none'; ?>" >
                    <label class="form-label"><?= lang('Material.material_return'); ?><span class="text-danger"> </span></label>
                    <select id="material_return_id" name="material_return_id[]"
                            class="select2 form-select materialReturnDd dt-material-return" multiple>
                        <?php
                        if (!empty($material_reference_data)) {
                            foreach ($material_reference_data as $referenceData) { ?>
                                <option value="<?= $referenceData['reference_type_id'] ?>"
                                        selected><?= $referenceData['material_return_number']; ?></option>
                            <?php }
                        } ?>


                    </select>
                    <div class="form-text ">
                        <button type="button"
                                class="btn btn-sm btn-rounded btn-primary btn-flat border-2 getItem buttonHideAmend"
                                data-type="sales_order"><?= lang('Material.get_item') ?>
                        </button>
                    </div>
                </div>
            </div>


        </div>
        <hr class="my-4 mx-n4"/>

        <h6>2. <?= lang('Material.item_information'); ?></h6>
        <div class="row g-3">
            <?= isset($material_item_table) ? $material_item_table : ""; ?>
        </div>
        <?php if ($dtCIAcl->checkAccess('Material|manage')) { ?>
            <button type="button" class="btn btn-xs btn-primary" onclick="addMaterialItem()">
                <i class="ti ti-plus me-1"></i>
                <span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
            </button>
        <?php } ?>
        <?php if ($materialView != 1) { ?>

            <div class="pt-4">
                <button type="submit" id="submitBtn"
                        class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
                <button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Material'); ?>'"
                        class="btn btn-label-secondary"><?= lang('CommonMessage.common_cancel'); ?></button>
            </div>
        <?php } ?>
        <?php echo form_close(); ?>
    </div>

    <script>

        var editable = <?= $materialView ?>;
        if (editable == 1) {
            $("#form_material :input").prop("disabled", true);
            $(".dt-delete-item-row").removeAttr("onclick");
            $(".dt-delete-item-row").remove();
        }

        function materialItem() {
            addValidation("select", ".dt-item-id", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_select');?> " + "<?= lang('Material.item');?>",
                }
            });
            addValidation("input", ".dt-quantity", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_enter');?> " + "<?= lang('Material.quantity');?>",
                }
            });
        }


        $(document).ready(function () {
            itemDd();
            commonAreaDd();
            numberInit();
            financialYearDd();
            materialReturnDd();
            addSerialNumber('material_item_table');
            $("#material_type,.dt-material-for").select2();
            <?php if (!isset($material_data['material_id'])){ ?>
            getMaterialPrefix();
            <?php } ?>

            // $('#material_type').on('change', function(){
            // var material_type = $(this).val();
			// console.log(material_type);
            // if(material_type != 'inwards'){
            //     $("#material_for").val('');
            // }
            // else{
            //     $(".dt-material-for").select2();
            // }  
            // });

            // Initialize
            var validator = $("#form_material").validate({
                ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
                errorClass: 'validation-invalid-label',
               // successClass: 'validation-valid-label',
                validClass: 'validation-valid-label',
                highlight: function (element, errorClass) {
                    $(element).removeClass(errorClass);
                },
                unhighlight: function (element, errorClass) {
                    $(element).removeClass(errorClass);
                },
                success: function (label) {
                    //label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
                },
                // Different components require proper error label placement
                errorPlacement: function (error, element) {

                    // Unstyled checkboxes, radios
                    if (element.parents().hasClass('form-check')) {
                        error.appendTo(element.parents('.form-check').parent());
                    }

                    // Input with icons and Select2
                    else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
                        error.appendTo(element.parent());
                    }

                    // Input group, styled file input
                    else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                        error.appendTo(element.parent().parent());
                    }

                    // Other elements
                    else {
                        error.insertAfter(element);
                    }
                },
                rules: {
                    prefix: {
                        required: true,
                    },
                    series: {
                        required: true,
                    },
                    material_date: {
                        required: true,
                    },
                    common_area_id: {
                        required: true,
                    },
                    material_type: {
                        required: true,
                    },
                    financial_year_id: {
                        required: true,
                    },
                },
                messages: {
                    prefix: {
                        required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("CommonMessage.common_prefix"); ?>.'
                    },
                    series: {
                        required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("CommonMessage.common_series"); ?>.'
                    },
                    material_date: {
                        required: '<?= lang('CommonMessage.common_please_select'); ?> <?= lang("Material.material_date"); ?>',
                    },
                    common_area_id: {
                        required: "<?= lang('CommonMessage.common_please_select'); ?>  <?= lang("Material.common_area"); ?>",
                    },
                    material_type: {
                        required: "<?= lang('CommonMessage.common_please_select'); ?>  <?= lang("Material.material_type"); ?>",
                    },
                    financial_year_id: {
                        required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Material.financial_year"); ?>',
                    },
                },
                submitHandler: function (e) {
                    $(e).ajaxSubmit({
                        url: '<?php echo admin_url("Material/save");?>',
                        type: 'post',
                        beforeSubmit: function (formData, jqForm, options) {
                            dtButtonHide('#submitBtn');
                            dtButtonHide('#cancelBtn');
                        },
                        complete: function () {

                        },
                        dataType: 'json',
                        clearForm: false,
                        success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Material');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Material');?>';
							// }, 1000);

						} else {
                            dtButtonShow('#submitBtn');
                            dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
                    });
                }
            });
            materialItem();

            $("#material_date").flatpickr({
                // monthSelectorType: 'static',
                dateFormat: "d-m-Y",
                // dateFormat: 'd-m-Y',
                // minDate: "today",
                //maxDate:"15-07-2024"
            });
        });

        function getMaterialPrefix(prefix = '') {
            var tableType = "material";
            var societyId = "<?= $session->get('society_id') ?>";
            if (prefix != '') {
                var displayPrefix = prefix;
            } else {
                var displayPrefix = "<?= $prefix ?>";
            }
            getNextSeriesJS(tableType, displayPrefix, societyId);
        }

        $(document).on("change", "#material_type", function () {
            var materialType = $(this).val();

            if (materialType == 'outwards') {
                $("#material_for").val('');
                $(".materialForDiv").hide();
                $( ".materialForDiv" ).addClass( "d-lg-none" );
                $(".materialReturnForDiv").hide();
                $( ".materialReturnForDiv" ).addClass( "d-lg-none" );
                $('#material_item_table tbody').html('');
                addMaterialItem();
            }
            if (materialType == 'inwards') {
                $(".dt-material-for").val("").trigger("change.select2");
                $(".materialReturnDd").val("").trigger("change.select2");
                $(".materialForDiv").show();
                $( ".materialForDiv" ).removeClass( "d-lg-none" );
            }

        });

        $(document).on("change", "#material_for", function () {
            var materialFor = $(this).val();

            if (materialFor == 'return') {
                $(".materialReturnDd").val("").trigger("change.select2");
                $(".materialReturnForDiv").show();
                $( ".materialReturnForDiv" ).removeClass( "d-lg-none" );
            }
            if (materialFor == 'purchase') {
                $(".materialReturnForDiv").hide();
                $( ".materialReturnForDiv" ).addClass( "d-lg-none" );
                $('#material_item_table tbody').html('');
                addMaterialItem();
            }
        });

        $(document).on('click', '.getItem', function () {
            var index = 0;
            var commonAreaId = $('#common_area_id').val();
            var materiaReturnId = $('#material_return_id').val();
            var materialId = $('#material_id').val();

            $.ajax({
                type: "POST",
                url: "<?php echo admin_url('Material/getItemTableRow'); ?>",
                dataType: "json",
                data: {
                    material_return_id: materiaReturnId,
                    material_id: materialId,
                    common_area_id: commonAreaId,
                },
                success: function (resObj) {
                    if (resObj.success) {
                        $('#material_item_table tbody').html(resObj.item_row_data);
                        $(".dt-item-id").select2();
                        addSerialNumber('material_item_table');
                    } else {
                        $('#material_item_table tbody').html(resObj.item_row_data);
                        $(".dt-item-id").select2();
                        addSerialNumber('material_item_table');
                        Swal.fire({
                            title: 'Error!',
                            text: resObj.msg,
                            icon: 'error',
                            customClass: {
                                confirmButton: 'btn btn-primary waves-effect waves-light'
                            },
                            buttonsStyling: false
                        });
                    }
                }
            });
        });


    </script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>