<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>
<div class="card">
	<div class="card-datatable table-responsive">
		<table id="letter_head_table" class="table dt-datatable">
			<thead class="border-top">
			<tr>
				<th><input class="form-check-input datatable-select-all-second" type="checkbox"  /></th>
				<th class="font-weight-bold"><?= lang("LetterHead.letter_head_title"); ?></th>
				<th class="font-weight-bold"><?= lang('LetterHead.letter_head_date'); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_action"); ?></th>
			</tr>
			</thead>
		</table>
	</div>
</div>
<script type="text/javascript">
	var dt_DataTable;
	$(document).ready(function () {
		dt_DataTable = $('#letter_head_table').DataTable( {
			dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
				'<"me-5 ms-n2 pe-5"f>' +
				'<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
				'>t' +
				'<"row mx-2"' +
				'<"col-sm-12 col-md-6"i>' +
				'<"col-sm-12 col-md-6"p>' +
				'>',
			processing: true,
			serverSide: true,
			displayLength: 10,
			language: {
				sLengthMenu: 'Show _MENU_',
				search: '',
				searchPlaceholder: 'Search <?= lang('LetterHead.letter_head');?>',
				info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
			},
			buttons: [
				<?php if ($dtCIAcl->checkAccess("LetterHead|manage")) { ?>
				{
					text: '<i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('LetterHead.add_letter_head');?></span>',
					className: 'add-new btn btn-primary px-1 me-2',
					action: function () {
						window.location.href = '<?= admin_url("LetterHead/manage");?>';
					}
				},
				<?php } ?>
				<?php if ($dtCIAcl->checkAccess("LetterHead|delete")) { ?>
				{
					text: '<i class="ti ti-trash me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('LetterHead.delete_letter_head');?></span>',
					className: 'btn btn-danger  px-1 dt-delete-record',
				},
				<?php } ?>
			],
			"ajax": {
				"url": "<?php echo admin_url('LetterHead/getLetterHeadListing'); ?>",
				"type": "POST",
				"data": function ( d ) {

				}
			},
			"stateSave": true,
			"order": [[ 0, "asc" ]],
			"columns": [
				{
					"data": "letter_head_id",
					"render": function (data, type, row) {
						return '<input class="form-check-input datatable-checkbox" type="checkbox" id="ids_' + row['letter_head_id'] + '" name="ids[]" value="' + row['letter_head_id'] + '"/>';
					},
					"class": "no_click_allowed",
					"sortable": false,
					"searchable": false
				},
				{"data": "letter_head_title" },
				{"data": "letter_head_date" },
				{
					"data": "action_button",
					"class" : "text-center no_click_allowed",
					"sortable": false,
					"searchable": false
				},
			],
			"fnDrawCallback": function (oSettings, json) {
				customToolTip();
				$('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
				$('.dt-buttons').addClass('d-flex flex-wrap');
				$('.dataTables_filter .form-control').removeClass('form-control-sm');
				$('.dataTables_length .form-select').removeClass('form-select-sm');
				//checkBoxRefresh("datatable-checkbox");
				switcheryKeyGen("datatable-list-switchery");

			}
		});
		dtDataTableSearch();
	});

    //Delete Record
    $(document).on('click', '.dt-delete-record', function () {
        var id = $(this).attr("data-id");
        var deleteId = [];
        if(id != undefined){
            $('.datatable-select-all-second').prop('checked', false);
            $('.datatable-checkbox').prop('checked', false);
            $("#ids_" + id).prop("checked", true);
            deleteId.push(id);
        }
        else{
            var deleteElement =$('#letter_head_table tbody .datatable-checkbox:checked');
            var selectedLength = deleteElement.length;
            if (selectedLength == 0) {
                Swal.fire({
                    title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_info')); ?>",
                    text: "<?= lang('CommonMessage.delete_info'); ?>",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'OK',
                    customClass: {
                        confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                        cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                    },
                    buttonsStyling: false
                }).then(function () {
                    return false;
                });
            } else {
                $.each(deleteElement, function (i, ele) {
                    deleteId.push($(ele).val());
                });
            }
        }
        if (deleteId.length > 0) {
            Swal.fire({
                title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
                text: "<?= lang('CommonMessage.delete_warning'); ?>",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'OK',
                customClass: {
                    confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                    cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                },
                buttonsStyling: false
            }).then(function(result) {
                if (result.value) {
                    $.ajax({
                        type: "post",
                        url: "<?= admin_url("LetterHead/delete")?>",
                        dataType: "json",
                        data: {letter_head_id: deleteId},
                        success: function (data) {
                            if (data['success']) {
                                Swal.fire({
                                    title: 'Success',
                                    text: data['msg'],
                                    icon: 'success',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            } else {
                                Swal.fire({
                                    title: 'Error!',
                                    text: data['msg'],
                                    icon: 'error',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            }
                        }
                    });
                }
                else {
                    $('.datatable-checkbox').prop('checked', false);
                }
            });
        }
    });

	$(document).on('click', '.datatable-checkbox', function () {
		$(".dt-delete-record").removeClass( "invisible" );

	});
</script>