<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#flat_detail" aria-controls="flat_detail" aria-selected="true">
			<?= lang('Item.item_detail'); ?>
		</button>
	</li>
	
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="flat_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="flat_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Item.item_name"); ?></td>
						<td><?php
							echo (isset($item_data['item_name']) && $item_data['item_name'] != "") ? $item_data['item_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Item.item_description"); ?></td>
						<td><?php
							echo (isset($item_data['item_description']) && $item_data['item_description'] != "") ? $item_data['item_description'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Item.manufacturer"); ?></td>
						<td><?php
							echo (isset($item_data['manufacturer_name']) && $item_data['manufacturer_name'] != "") ? $item_data['manufacturer_name'] : '-';
							?></td>
					</tr>
					<tr>
						<td><?= lang("Item.common_area"); ?></td>
						<td><?php
							echo (isset($item_data['common_area_name']) && $item_data['common_area_name'] != "") ? $item_data['common_area_name'] : '-';
							?>
						</td>
					</tr>	
					<tr>
						<td><?= lang("Item.batch_no"); ?></td>
						<td><?php
							echo (isset($item_data['batch_no']) && $item_data['batch_no'] != "") ? $item_data['batch_no'] : '-';
							?>
						</td>
					</tr>
                    <tr>
						<td><?= lang("Item.serial_no"); ?></td>
						<td><?php
							echo (isset($item_data['serial_no']) && $item_data['serial_no'] != "") ? $item_data['serial_no'] : '-';
							?>
						</td>
					</tr>


                    <tr>
                        <td><?= lang("Item.warranty_period_from"); ?></td>
                        <td><?php
                            echo (isset($item_data['warranty_period_from']) && $item_data['warranty_period_from'] != "") ? YMDToDMY($item_data['warranty_period_from']) : '-';
                            ?>
                        </td>
                    </tr>


                    <tr>
                        <td><?= lang("Item.warranty_period_to"); ?></td>
                        <td><?php
                            echo (isset($item_data['warranty_period_to']) && $item_data['warranty_period_to'] != "") ? YMDToDMY($item_data['warranty_period_to']) : '-';
                            ?>
                        </td>
                    </tr>

                    <tr>
                        <td><?= lang("Item.remarks"); ?></td>
                        <td><?php
                            echo (isset($item_data['remarks']) && $item_data['remarks'] != "") ? $item_data['remarks'] : '-';
                            ?>
                        </td>
                    </tr>
                    <tr>
						<td><?= lang("Item.item_image"); ?></td>
						<td>
							<?php 
		                    if(isset($image_data) && is_array($image_data) && !empty($image_data)){
		                        foreach($image_data as $image) { 
		                        	if(file_exists(ITEM_IMAGE_PATH . $image['item_image'])){
				                        $paths = site_url() . ITEM_IMAGE_PATH . $image['item_image']; ?> 
				                 		<span class="document-image-<?= $image['item_image_id']; ?>">
				                 			<a href="<?= $paths; ?>" target="_blank"> <img src="<?= $paths; ?>" width="100" class="img-fluid" alt=""> </a>
				        				</span>
		            		<?php }} } ?>
						</td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($item_data['created_at']) && isValidDate($item_data['created_at'])) ? siteDateFormat($item_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($item_data['created_by']) && $item_data['created_by'] != "") ? $item_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($item_data['updated_at']) && isValidDate($item_data['updated_at'])) ? siteDateFormat($item_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($item_data['updated_by']) && $item_data['updated_by'] != "") ? $item_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	
</div>