<?php
$assets = base_url() . 'assets/';
$investmentsData = !empty($investments_data) && is_array($investments_data) ? $investments_data : array();
$totalAcrdInt = 0;
$totalMaturityAmount = 0;
 ?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8">
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<title><?= $name; ?></title>
		<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet"
			  type="text/css">
		<link href="<?= $assets ?>css/pdf_bootstrap.css" rel="stylesheet" type="text/css">
		<link href="<?= $assets ?>css/pdf_style_sheet.css" rel="stylesheet" type="text/css">
	</head>
	<body style='font-family:chelvetica;font-size: 9px'>

	<div class="card">
		<h3 style="color: red;text-align: center;"><?= lang('Investments.investments_detail'); ?></h3>
		<div class="card-body">
			<div class="table-responsive text-nowrap">
				<table class="table" border="1" cellpadding="1" cellspacing="1" width="100%">
					<tr>
						<td class="text-bold text-center" colspan="8" rowspan="2" style="font-size:15px">Investment</td>
						<td colspan="2" class="text-bold text-center"><?php if (isset($society_data['society_name']) && $society_data['society_name'] != '') { echo $society_data['society_name']; } ?></td>
					</tr>
					<tr>
						<td class="text-bold text-center">YEAR</td>
						<td class="text-bold text-center"><?= isset($financial_year_data["financial_year_prefix"]) ? $financial_year_data["financial_year_prefix"] : ""; ?></td>
					</tr>

					<tr>
						<td class="text-bold text-center" rowspan="2">SN</td>
						<td class="text-bold text-center"  rowspan="2">Date</td>
						<td class="text-bold text-center"  rowspan="2">Bank</td>
						<td class="text-bold text-center" colspan="5">FDR Details</td>
						<td class="text-bold text-center" colspan="2">Maturity Details</td>
					</tr>

					<tr>
						<td class="text-bold text-center">For Nos.</td>
						<td class="text-bold text-right">Amount</td>
						<td class="text-bold text-center">Term</td>
						<td class="text-bold text-right">Rate</td>
						<td class="text-bold text-right">Acrd Int.</td>
						<td class="text-bold text-center">Date</td>
						<td class="text-bold text-right">Amount</td>
					</tr>

					<?php 
					if (is_array($investmentsData) && !empty($investmentsData)) {
						foreach ($investmentsData as $investmentsValueKey => $investmentsValueElement) {
							?>
							<tr>
								<td class="text-center">
									<?= ++$investmentsValueKey; ?>
								</td>
								<td class="text-center">
									<?= isset($investmentsValueElement['date']) ? YMDToDMY($investmentsValueElement['date']) : ''; ?>
								</td>
								<td class="text-center">
									<?= isset($investmentsValueElement['bank_name']) ? $investmentsValueElement['bank_name'] : ''; ?>
								</td>
								<td class="text-center">
									<?= isset($investmentsValueElement['fdr_no']) ? $investmentsValueElement['fdr_no'] : ''; ?>
								</td>
								<td class="text-right">
									<?= isset($investmentsValueElement['fdr_amount']) ? $investmentsValueElement['fdr_amount'] : ''; ?>
								</td>
								<td class="text-center">
									<?= isset($investmentsValueElement['term']) ? $investmentsValueElement['term'] : ''; ?>
								</td>
								<td class="text-right">
									<?= isset($investmentsValueElement['rate']) ? $investmentsValueElement['rate'] : ''; ?>
								</td>
								<td class="text-right">
									<?php  $totalAcrdInt += $investmentsValueElement['acrd_int'];
									echo  isset($investmentsValueElement['acrd_int']) ? $investmentsValueElement['acrd_int'] : ''; ?>
								</td>
								<td class="text-center">
									<?= isset($investmentsValueElement['maturity_date']) ? YMDToDMY($investmentsValueElement['maturity_date']) : ''; ?>
								</td>
								<td class="text-right">
									<?php  $totalMaturityAmount += $investmentsValueElement['maturity_amount'];
									echo isset($investmentsValueElement['maturity_amount']) ? ($investmentsValueElement['maturity_amount']) : ''; ?>
								</td>
							</tr>
							<?php
						}
					} else {
						echo "<tr><td colspan='10' class='text-center'>" . lang("CommonMessage.common_no_data_found") . "</td></tr>";
					}  ?>

					<tr class="text-end">
						<td colspan="7" class="text-right text-bold">Total</td>
						<td class="text-right"><?php
							if (isset($totalAcrdInt) && $totalAcrdInt != "") {
								echo $totalAcrdInt;
							}
							?>
						</td>
						<td></td>
						<td class="text-right">
							<?php if (isset($totalMaturityAmount) && $totalMaturityAmount != "") { 
								echo $totalMaturityAmount;
							} ?>
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
	</body>
</html>
