<!-- Add New Address Modal -->
<div class="modal fade" id="generator_modal" tabindex="-1" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-simple modal-add-new-address">
		<div class="modal-content p-3 p-md-5">
			<div class="modal-body">
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				<div class="text-center mb-4">
					<h3 class="address-title mb-2"><?= lang('Generator.generator_form'); ?></h3>
				</div>
				<?php
				$form_id = array(
					'id' => 'form_generator',
					'method' => 'post',
					'class' => 'row g-3',
					'autocomplete' => 'off'
				);
				echo form_open_multipart('',$form_id);
				?>
				<input type="hidden" name="generator_id" id="generator_id">

				<div class="col-12">
					<label class="form-label" for=""><?= lang('Generator.generator_name'); ?><span class="text-danger"> *</span></label>
					<input
						type="text"
						id="generator_name"
						name="generator_name"
						class="form-control"
						placeholder="Enter <?= lang('Generator.generator_name'); ?>"/>
				</div>


				<div class="col-12 text-center">
					<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
					<button
						id="cancelBtn"
						type="reset"
						class="btn btn-label-secondary"
						data-bs-dismiss="modal"
						aria-label="Close">
						Cancel
					</button>
				</div>
				<?= form_close(); ?>
			</div>
		</div>
	</div>
</div>
<!--/ Add New Address Modal -->


<!--  add,update and delete model code here-->
<script type="text/javascript">
	//var laddaSubmitBtn = Ladda.create(document.querySelector('#submit'));
	$(document).ready(function () {
		$(".dt-generator-for").select2();
		//validation
		var validator = $("#form_generator").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function (element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function (element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function (label) {
				label.addClass('validation-valid-label'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function (error, element) {
				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo(element.parents('.form-check').parent());
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo(element.parent());
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo(element.parent().parent());
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				generator_name: {
					required: true
				}
			},
			messages: {
				generator_name: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Generator.generator_name'); ?>",
				}
			},
			submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Generator/addEdit");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {
						//laddaStop();
					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    $('#generator_modal').modal('hide');
                                    dt_DataTable.ajax.reload(null, false);
                                }
							});
							// setTimeout(function () {
							// 	$('#generator_modal').modal('hide');
							// 	dt_DataTable.ajax.reload(null, false);
							// }, 1000);
						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
			}
		});
	});
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>