<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<?= isset($advance_filter) ? $advance_filter : ""; ?>
<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>
<!-- DataTable with Buttons -->
<div class="card">
	<div class="card-datatable table-responsive text-nowrap">
		<table id="faq_table" class="table dt-datatable ">
			<thead class="border-top">
			<tr>
				<th><input class="form-check-input datatable-select-all-second" type="checkbox"  /></th>
				<th class="font-weight-bold"><?= lang("Faq.category_id"); ?></th>
				<th class="font-weight-bold"><?= lang("Faq.faq_title"); ?></th>
				<th class="font-weight-bold"><?= lang("Faq.faq_answer"); ?></th>
				<th class="font-weight-bold"><?= lang("Faq.sort_order"); ?></th>
				<th class="font-weight-bold"><?= lang('CommonMessage.common_updated_by'); ?></th>
				<th class="font-weight-bold"><?= lang('CommonMessage.common_updated_at'); ?></th>
				<th class="font-weight-bold"><?= lang("CommonMessage.common_action"); ?></th>
			</tr>
			</thead>
		</table>
	</div>
	<!--	</div>-->
</div>
<script type="text/javascript">
	var dt_DataTable;
	$(document).ready(function () {
		dt_DataTable = $('#faq_table').DataTable( {
			dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
				'<"me-5 ms-n2 pe-5"f>' +
				'<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
				'>t' +
				'<"row mx-2"' +
				'<"col-sm-12 col-md-6"i>' +
				'<"col-sm-12 col-md-6"p>' +
				'>',
			processing: true,
			serverSide: true,
			displayLength: 10,
			// Scroll options
			// scrollY: '300px',
			scrollX: true,
			// language: {
			// 	sLengthMenu: 'Show _MENU_',
			// 	search: '',
			// 	searchPlaceholder: 'Search <?= lang('faq');?>',
			// 	info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
			// },
			language: {
                sLengthMenu: 'Show _MENU_',
                search: '',
                searchPlaceholder: 'Search Faq',
                info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
            },
			buttons: [
				// {
				// 	extend: 'collection',
				// 	className: 'btn btn-label-secondary px-2 dropdown-toggle me-2 waves-effect waves-light',
				// 	text: '<i class="ti ti-download me-1 ti-xs"></i>Export',
				// 	buttons: [
						
				// 	]
				// },
				<?php if ($dtCIAcl->checkAccess("Faq|manage")) { ?>
				{
					text: '<i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('Faq.add_faq');?></span>',
					className: 'add-new btn btn-primary px-1 me-2',
					action: function () {
						window.location.href = '<?= admin_url("Faq/manage");?>';
					}
				},
				<?php } ?>
				<?php if ($dtCIAcl->checkAccess("Faq|delete")) { ?>
				{
					text: '<i class="ti ti-trash me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('Faq.delete_faq');?></span>',
					className: 'btn btn-danger  px-1 dt-delete-record',
				},
				<?php } ?>
			],
			"ajax": {
				"url": "<?php echo admin_url('Faq/getFaqListing'); ?>",
				"type": "POST",
				"data": function(d) {
                    var params = {};
                    params["<?= csrf_token(); ?>"] = "<?= csrf_hash() ?>";
                    var filterData = $("#advanceFilter").serializeArray();
                    $.each(filterData, function(i, val) {
                        var name = val.name;
                        if (typeof params[name] == 'undefined') {
                            params[name] = val.value;
                        } else if ($.isArray(params[name])) {
                            params[name].push(val.value);
                        } else {
                            params[name] = [params[name]];
                            params[name].push(val.value);
                        }
                    });

                    return $.extend({}, d, params);
                }
			},
			"stateSave": true,
			"order": [[ 0, "asc" ]],
			"columns": [
				{
					"data": "faq_id",
					"render": function (data, type, row) {
						return '<input class="form-check-input datatable-checkbox" type="checkbox" id="ids_' + row['faq_id'] + '" name="ids[]" value="' + row['faq_id'] + '"/>';
					},
					"class": "no_click_allowed",
					"sortable": false,
					"searchable": false
				},
				{"data": "category_name" },
				{"data": "faq_title" },
				{"data": "faq_answer" },
				{"data": "sort_order" },
				{"data": "updated_by"},
				{"data": "updated_at"},
				{
					"data": "action_button",
					"class" : "text-center no_click_allowed",
					"sortable": false,
					"searchable": false
				},
			],
			"fnDrawCallback": function (oSettings, json) {
				customToolTip();
				$('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
				$('.dt-buttons').addClass('d-flex flex-wrap');
				$('.dataTables_filter .form-control').removeClass('form-control-sm');
				$('.dataTables_length .form-select').removeClass('form-select-sm');
				//checkBoxRefresh("datatable-checkbox");
				switcheryKeyGen("datatable-list-switchery");

			}
		});
		dtDataTableSearch();
	});

	$(document).on('click', '.dt-delete-record', function () {
        var id = $(this).attr("data-id");
        var deleteId = [];
        if(id != undefined){
            $('.datatable-select-all-second').prop('checked', false);
            $('.datatable-checkbox').prop('checked', false);
            $("#ids_" + id).prop("checked", true);
            deleteId.push(id);
        }
        else{
            var deleteElement =$('#faq_table tbody .datatable-checkbox:checked');
            var selectedLength = deleteElement.length;
            if (selectedLength == 0) {
                Swal.fire({
                    title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_info')); ?>",
                    text: "<?= lang('CommonMessage.delete_info'); ?>",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'OK',
                    customClass: {
                        confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                        cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                    },
                    buttonsStyling: false
                }).then(function () {
                    return false;
                });
            } else {
                $.each(deleteElement, function (i, ele) {
                    deleteId.push($(ele).val());
                });
            }
        }
        if (deleteId.length > 0) {
            Swal.fire({
                title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
                text: "<?= lang('CommonMessage.delete_warning'); ?>",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'OK',
                customClass: {
                    confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                    cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                },
                buttonsStyling: false
            }).then(function(result) {
                if (result.value) {
                    $.ajax({
                        type: "post",
                        url: "<?= admin_url("Faq/delete")?>",
                        dataType: "json",
                        data: {faq_id: deleteId},
                        success: function (data) {
                            if (data['success']) {
                                Swal.fire({
                                    title: 'Success',
                                    text: data['msg'],
                                    icon: 'success',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            } else {
                                Swal.fire({
                                    title: 'Error!',
                                    text: data['msg'],
                                    icon: 'error',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            }
                        }
                    });
                }
                else {
                    $('.datatable-checkbox').prop('checked', false);
                }
            });
        }
    });
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
