<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('EmergencyContact.emergency_contact_details');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_emergency_contact',
				);
				echo form_open_multipart('',$form_id);
				$emergencyNumberId = (isset($emergency_contact_data['emergency_number_id']) && ($emergency_contact_data['emergency_number_id'] != '')) ? $emergency_contact_data['emergency_number_id'] : '';
				?>
				<input type="hidden" id="emergency_number_id" name="emergency_number_id" value="<?= $emergencyNumberId ?>">
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('EmergencyContact.name');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="name" id="name" placeholder="Enter <?= lang('EmergencyContact.name');?>" value="<?= (isset($emergency_contact_data['name']) && ($emergency_contact_data['name'] != '')) ? $emergency_contact_data['name'] : '';  ?>" />
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('EmergencyContact.contact_number');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="text" class="form-control numberInit" name="emergency_contact_number" id="emergency_contact_number" placeholder="Enter <?= lang('EmergencyContact.contact_number');?>" value="<?= (isset($emergency_contact_data['emergency_contact_number']) && ($emergency_contact_data['emergency_contact_number'] != '')) ? $emergency_contact_data['emergency_contact_number'] : '';  ?>" />
					</div>
				</div>
				<div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('EmergencyContact.description'); ?><span class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <textarea name="description"  id="description" placeholder="Enter <?= lang('EmergencyContact.description'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($emergency_contact_data['description']) && ($emergency_contact_data['description'] != '')) ? $emergency_contact_data['description'] : ''; ?></textarea>
                    </div>
                </div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
					<div class="col-sm-10">
						<label class="switch switch-sm"><span class="switch-label"></span>
							<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($emergency_contact_data['is_active']) || $emergency_contact_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
							<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
						</label>
					</div>
				</div>
                <div class="pt-4">
                    <button type="submit" id="submitBtn" 
                            class="btn btn-primary me-sm-3 me-1"><?= lang('CommonMessage.common_submit'); ?></button>
                    <button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('EmergencyContact'); ?>'"
                            class="btn btn-label-secondary"><?= lang('CommonMessage.common_cancel'); ?></button>
                </div>
                <?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
	$(document).ready(function() {
		numberInit();
		switcheryKeyGen("datatable-list-switchery");
		// Initialize
		var validator = $("#form_emergency_contact").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				name: {
					required: true,
				},
				emergency_contact_number: {
					required: true,
					// maxlength: 10,
					// minlength: 10,
				},
				description: {
					required: true,
				}
			},
			messages: {
				name: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("EmergencyContact.name"); ?>',
				},
				emergency_contact_number: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("EmergencyContact.contact_number"); ?>',
				},
				description: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("EmergencyContact.description"); ?>',
				}
			},
			submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("EmergencyContact/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
									window.location.href = '<?php echo admin_url('EmergencyContact');?>';
								}
							});
							
							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('EmergencyContact');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
			}
		});
	});
</script>