<?php
$html = '';
if (isset($document_folder_item_data) && !empty($document_folder_item_data)) {
	foreach ($document_folder_item_data as $key => $value) {
		$data["row_number"] = $key + 1;
		$data["document_folder_item_data"] = $value;
		$html .= view('Admin/DocumentFolder/DocumentFolderItemRowView', $data);
	}
}
?>
<!-- Responsive Table -->
	<div class="table-responsive text-nowrap">
		<table id="document_folder_item_table" class="table table-bordered">
			<thead>
			<tr class="text-nowrap">
				<th><?= lang('CommonMessage.common_sr_no'); ?></th>
				<th><?= lang('DocumentFolder.document_folder_title'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('DocumentFolder.effective_date'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('DocumentFolder.description'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('DocumentFolder.image'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('CommonMessage.common_action'); ?></th>
			</tr>
			</thead>
			<tbody class="table-border-bottom-0">
			<?php
			if (isset($document_folder_item_data) && !empty($document_folder_item_data)) {
				echo $html;
			}else { ?>
				<?php
				$data["row_number"] =  1;
				echo view('Admin/DocumentFolder/DocumentFolderItemRowView',$data); ?>
			<?php } ?>

			</tbody>
		</table>
	</div>
<!--/ Responsive Table -->
<script>
	var rowNumber;

	function addDocumentFolderItem() {
		var lastIndex = ($("#document_folder_item_table tbody tr:last").length >= 1) ? $("#document_folder_item_table tbody tr:last").attr("data-id").split("_").pop() : 0;
		rowNumber = parseInt(lastIndex) + 1;
		$.ajax({
			type: "post",
			url: "<?= admin_url('DocumentFolder/addDocumentFolderItemRow'); ?>",
			dataType: "html",
			async: false,
			data: {
				row_number: rowNumber,
			},
			success: function (data) {
				if (data) {
					$('table#document_folder_item_table tbody').append(data);
					addSerialNumber('document_folder_item_table');
					numberInit();
                    $('#effective_date_'+rowNumber).flatpickr({
                        dateFormat: 'd-m-Y',
                    });
                    documentFolderItem();
					customToolTip();
				}
			}
		});
	}


	$(document).on('click', '.dt-delete-item-row', function () {
		var trField = $(this).closest('tr');
		var id = $(this).closest('tr').find(".document_folder_item_id").val();
		var resourceId = $("#resource_id").val();

		if (id != '') {
				Swal.fire({
					title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
					text: "<?= lang('CommonMessage.delete_warning'); ?>",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'OK',
					customClass: {
						confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
						cancelButton: 'btn btn-label-secondary waves-effect waves-light'
					},
					buttonsStyling: false

			}).then(function (result) {
				if (result.value) {
					var deleteId = [];
					deleteId.push(id);
					$.ajax({
						type: "POST",
						url: "<?php echo admin_url('DocumentFolder/deleteDocumentFolderItemRow');?>",
						dataType: "json",
						async:false,
						data: {
                            document_folder_item_id: deleteId,
                            resource_id: resourceId
						},
						success: function (resObj) {
							if (resObj.success) {
								$(trField).remove();
								addSerialNumber('document_folder_item_table');
								Swal.fire({
									title: 'Success',
									text: resObj['msg'],
									icon: 'success',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								}).then(function() {
									if ($('#document_folder_item_table tbody > tr').length == 0) {
                                        addDocumentFolderItem();
									}
								});
							} else {
								Swal.fire({
									title: 'Error!',
									text: resObj['msg'],
									icon: 'error',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								});
							}
						}
					});
				}
			});
		} else {
			$(trField).remove();
			addSerialNumber('document_folder_item_table');
			if ($('#document_folder_item_table tbody > tr').length == 0) {
                addDocumentFolderItem();
			}
		}
	});

</script>
