<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<div class="card">
	<div class="card-datatable table-responsive">
		<table id="document_table" class="table dt-datatable">
			<thead class="border-top">
			<tr>
				<th><input class="form-check-input datatable-select-all-second" type="checkbox"  /></th>
				<th class="font-weight-bold"><?= lang("Document.document_name"); ?></th>
				<th class="font-weight-bold"><?= lang("Document.document_for"); ?></th>
				<th class="font-weight-bold"><?= lang("Document.sort_order"); ?></th>
				<th class="font-weight-bold"><?= lang('Document.has_expired_date'); ?></th>
                <th class="font-weight-bold"><?= lang('Document.is_required'); ?></th>
				<th class="font-weight-bold"><?= lang("CommonMessage.common_active"); ?></th>
				<th class="font-weight-bold"><?= lang('CommonMessage.common_created_at'); ?></th>
				<th class="font-weight-bold"><?= lang('CommonMessage.common_created_by'); ?></th>
				<th class="font-weight-bold"><?= lang('CommonMessage.common_updated_at'); ?></th>
				<th class="font-weight-bold"><?= lang('CommonMessage.common_updated_by'); ?></th>
				<th class="font-weight-bold"><?= lang("CommonMessage.common_action"); ?></th>
			</tr>
			</thead>
		</table>
	</div>
</div>
<script type="text/javascript">
	var dt_DataTable;
	$(document).ready(function () {
		dt_DataTable = $('#document_table').DataTable( {
			dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
				'<"me-5 ms-n2 pe-5"f>' +
				'<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
				'>t' +
				'<"row mx-2"' +
				'<"col-sm-12 col-md-6"i>' +
				'<"col-sm-12 col-md-6"p>' +
				'>',
			processing: true,
			serverSide: true,
			displayLength: 10,
			// language: {
			// 	sLengthMenu: 'Show _MENU_',
			// 	search: '',
			// 	searchPlaceholder: 'Search <?= lang('document');?>',
			// 	info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
			// },
			language: {
                sLengthMenu: 'Show _MENU_',
                search: '',
                searchPlaceholder: 'Search Document',
                info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
            },
			buttons: [
				<?php if ($dtCIAcl->checkAccess("Document|addEdit")) { ?>
                {
                    text: '<i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('Document.add_document');?></span>',
                    className: 'add-new btn btn-primary  px-1 me-2 add_document',
                    action: function () {
						window.location.href = '<?= admin_url("Document/manage");?>';
					}
                },

                <?php } ?>
                <?php if ($dtCIAcl->checkAccess("Document|delete")) { ?>
                {
                    text: '<i class="ti ti-trash me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('Document.delete_document');?></span>',
                    //className: 'btn btn-danger ms-2 ms-sm-0 waves-effect waves-light dt-delete-record invisible',
                    className: 'btn btn-danger  px-1 dt-delete-record',
                },
                <?php } ?>
			],
			"ajax": {
				"url": "<?php echo admin_url('Document/getDocumentListing'); ?>",
				"type": "POST",
				"data": function ( d ) {
					
				}
			},
			"stateSave": true,
			"order": [[ 0, "asc" ]],
			"columns": [
				{
					"data": "document_id",
					"render": function (data, type, row) {
						return '<input class="form-check-input datatable-checkbox" type="checkbox" id="ids_' + row['document_id'] + '" name="ids[]" value="' + row['document_id'] + '"/>';
					},
					"class" : "no_click_allowed",
					"sortable": false,
					"searchable": false
				},
				{"data": "document_name" },
				{"data": "search_document_for",
				"render": function (data, type, row) {
						return row['document_for'];
					}
				},
				{"data": "sort_order" },
				{"data": "has_expired_date",
					"render": function (data, type, row) {
						return (data == 1) ? "Yes" : "No";
					},
					"searchable": false
				},
				{"data": "is_required",
					"render": function (data, type, row) {
						return (data == 1) ? "Yes" : "No";
					},
					"searchable": false
				},
				{
					"data": "is_active",
					"sortable": false,
					"searchable": false,
					"class" : "no_click_allowed",
					"render": function (data, type, row) {
						var checked = (data == 1) ? "checked" : "";
						return '<label class="switch switch-primary switch-sm">' +
							'<input type="checkbox" class="switch-input  dt-active-status" ' + checked + '  data-id="' + row['document_id'] + '" value="1" />' +
							'<span class="switch-toggle-slider">' +
							'<span class="switch-on"></span>' +
							'<span class="switch-off"></span>' +
							'</span>';
						'</label>';
					}
				},
				{"data": "created_at" },
				{"data": "created_by" },
				{"data": "updated_at" },
				{"data": "updated_by" },
				{
					"data": "action_button",
					"class" : "text-center no_click_allowed",
					"sortable": false,
					"searchable": false
				},
			],
			createdRow: function (row, data, dataIndex) {
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").addClass('dt-detail-model-view');
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").attr('data-dt_view_id', data['document_id']);
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").attr('data-dt_view_url', '<?= admin_url("Document/view"); ?>');
			},
			"fnDrawCallback": function (oSettings, json) {
				customToolTip();
				$('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
				$('.dt-buttons').addClass('d-flex flex-wrap');
				$('.dataTables_filter .form-control').removeClass('form-control-sm');
				$('.dataTables_length .form-select').removeClass('form-select-sm');
				//checkBoxRefresh("datatable-checkbox");
				switcheryKeyGen("datatable-list-switchery");

			}
		});
		dtDataTableSearch();
	});


	$(document).on('click', '.dt-active-status', function () {
		var id = $(this).attr('data-id');
		var isActive = $(this).is(":checked") ? 1 : 0;
		$.ajax({
			type: 'post',
			url: '<?php echo admin_url('Document/changeStatus'); ?>',
			data: {document_id:id, status: isActive},
			dataType: 'json',
			success: function (data) {
				if (data) {
					Swal.fire({
						title: 'Success',
						text: data.msg,
						icon: 'success',
						customClass: {
							confirmButton: 'btn btn-primary waves-effect waves-light'
						},
						buttonsStyling: false
					}).then(function() {
						dt_DataTable.ajax.reload(null,false);
					});
				} else {
					Swal.fire({
						title: 'Error!',
						text: data.msg,
						icon: 'error',
						customClass: {
							confirmButton: 'btn btn-primary waves-effect waves-light'
						},
						buttonsStyling: false
					});
				}
			}
		});
	});

	$(document).on('click', '.dt-delete-record', function () {
        var id = $(this).attr("data-id");
        var deleteId = [];
        if(id != undefined){
            $('.datatable-select-all-second').prop('checked', false);
            $('.datatable-checkbox').prop('checked', false);
            $("#ids_" + id).prop("checked", true);
            deleteId.push(id);
        }
        else{
            var deleteElement =$('#document_table tbody .datatable-checkbox:checked');
            var selectedLength = deleteElement.length;
            if (selectedLength == 0) {
                Swal.fire({
                    title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_info')); ?>",
                    text: "<?= lang('CommonMessage.delete_info'); ?>",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'OK',
                    customClass: {
                        confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                        cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                    },
                    buttonsStyling: false
                }).then(function () {
                    return false;
                });
            } else {
                $.each(deleteElement, function (i, ele) {
                    deleteId.push($(ele).val());
                });
            }
        }
        if (deleteId.length > 0) {
            Swal.fire({
                title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
                text: "<?= lang('CommonMessage.delete_warning'); ?>",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'OK',
                customClass: {
                    confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                    cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                },
                buttonsStyling: false
            }).then(function(result) {
                if (result.value) {
                    $.ajax({
                        type: "post",
                        url: "<?= admin_url("Document/delete")?>",
                        dataType: "json",
                        data: {document_id: deleteId},
                        success: function (data) {
                            if (data['success']) {
                                Swal.fire({
                                    title: 'Success',
                                    text: data['msg'],
                                    icon: 'success',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            } else {
                                Swal.fire({
                                    title: 'Error!',
                                    text: data['msg'],
                                    icon: 'error',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            }
                        }
                    });
                }
                else {
                    $('.datatable-checkbox').prop('checked', false);
                }
            });
        }
    });
	$(document).on('click', '.datatable-checkbox', function () {

		$(".dt-delete-record").removeClass( "invisible" );

	});
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>