<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#document_detail" aria-controls="document_detail" aria-selected="true">
			<?= lang('Document.document_detail'); ?>
		</button>
	</li>
	
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="document_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="document_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Document.document_name"); ?></td>
						<td><?php
							echo (isset($document_data['document_name']) && $document_data['document_name'] != "") ? $document_data['document_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Document.document_for"); ?></td>
						<td><?php
						if(isset($document_for_data) && !empty($document_for_data)) {
							echo implode(' , ', array_map('underscoreToUcWord', array_column($document_for_data, 'document_for')));
						} ?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Document.sort_order"); ?></td>
						<td><?php
							echo (isset($document_data['sort_order']) && $document_data['sort_order'] != "") ? roundNumber($document_data['sort_order']) : '-';
							?></td>
					</tr>
					<tr>
						<td><?= lang("Document.is_required"); ?></td>
						<td>
							<?= (isset($document_data['is_required']) && $document_data['is_required'] == 1) ? 'Yes' : 'No'; ?>
						</td>
					</tr>	
					<tr>
						<td><?= lang("Document.has_expired_date"); ?></td>
						<td>
							<?= (isset($document_data['has_expired_date']) && $document_data['has_expired_date'] == 1) ? 'Yes' : 'No'; ?>
						</td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($document_data['created_at']) && isValidDate($document_data['created_at'])) ? siteDateFormat($document_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($document_data['created_by']) && $document_data['created_by'] != "") ? $document_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($document_data['updated_at']) && isValidDate($document_data['updated_at'])) ? siteDateFormat($document_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($document_data['updated_by']) && $document_data['updated_by'] != "") ? $document_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	
</div>