<div class="modal fade" id="complain_change_status_modal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered1 modal-simple modal-add-new-cc">
        <div class="modal-content p-3 p-md-5">
            <div class="modal-body">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <div class="text-center mb-4">
                    <h3 class="mb-2">Complain Status Change</h3>
                </div>

                <?php
                $form_id = array(
                    'id'        => 'form_complain_change_status_modal',
                    'method'    => 'post',
                    'class'     => 'row g-3',
                    'autocomplete' => 'off'
                ); ?>
                <?= form_open('', $form_id); ?>

                <input type="hidden" name="modal_complain_id" id="modal_complain_id">
                <div class="col-12">
					<label class="form-label" for=""><?= lang('Complain.status'); ?><span class="text-danger"> *</span></label>
					 <select id="status_id" name="status_id" class="select2 form-select statusDd" data-allow-clear="true">
					
					</select>
				</div>
				<div class="col-12">
					<label class="form-label" for=""><?= lang('Complain.resource'); ?><span class="text-danger"> </span></label>
					 <select id="resource_id" name="resource_id" class="select2 form-select resourceDd" data-allow-clear="true">
					
					</select>
				</div>
                <div class="col-12">
                    <label class="form-label" for="modalAddCardName"><?= lang('Complain.remarks'); ?><span class="text-danger"> *</span></label>
                    <textarea name="remarks" id="remarks" placeholder="Enter <?= lang('Complain.remarks'); ?>" rows="3" cols="5" class="form-control"></textarea>
                </div> 
                <div class="col-12">
                    <label class="form-label" for="modalAddCardName"><?= lang('Complain.complain_image'); ?></label>
                    <input type="file" accept="image/*" class="form-control" name="complain_image[]" multiple="multiple">
                </div>


                <div class="col-12 text-center">
                    <button type="submit" class="btn btn-primary me-sm-3 me-1">Submit</button>
                    <button type="reset" class="btn btn-label-secondary btn-reset" data-bs-dismiss="modal" aria-label="Close">
                        Cancel
                    </button>
                </div>
                <?= form_close(); ?>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
    	modalResourceDd();
    	// Select2InitModalPopup();
		modalStatusDd();
		// Initialize
		var validator = $("#form_complain_change_status_modal").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				status_id: {
					required: true,
				},
				remarks : {
					required : true,
				}
			},
			messages: {
				status_id: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Complain.status"); ?>',
				},
				remarks : {
					required: "<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Complain.remarks"); ?>",
				}
			},
			submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Complain/changeComplainStatus");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {

					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
                            $('#complain_change_status_modal').modal('hide');
							Swal.fire({
								title: 'Success',
								text: resObj.msg,
								icon: 'success',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								window.location.href = '<?php echo admin_url('Complain');?>';
							});

						} else {
							Swal.fire({
								title: 'Error!',
								text: resObj.msg,
								icon: 'error',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							});
						}
					}
				});
			}
		});

		
	});

</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>