<script type="text/javascript">
    function societyDd() {
        $("#filter_society_id,.societyDd").select2({
            ajax: {
                url: "<?= admin_url('Society/getSocietyDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Society',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }

            if ($("#" + $(this).attr('id')).closest("form").find(".towerDd").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".towerDd").val('').trigger('change.select2');
            }

            if ($("#" + $(this).attr('id')).closest("form").find(".flatDd").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".flatDd").val('').trigger('change.select2');
            }
        });
    }

    function towerDd() {
        $("#filter_tower_id,.towerDd").select2({
            ajax: {
                url: "<?= admin_url('Tower/getTowerDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    var societyId;
                    if ($("#society_id").length > 0) {
                        societyId = $("#society_id").val() || 0;
                    }
                    return {
                        society_id: societyId,
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Tower',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function(tower) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }

            var towerData = tower.params.data;
            var societyId = towerData.society_id;

            if ($("#" + $(this).attr('id')).closest("form").find(".dt-tower-society-id").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".dt-tower-society-id").val(societyId);
            }

            if ($("#" + $(this).attr('id')).closest("form").find(".flatDd").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".flatDd").val('').trigger('change.select2');
            }

            if ($("#" + $(this).attr('id')).closest("form").find(".towerUnitDd").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".towerUnitDd").val('').trigger('change.select2');
            }

            if ($("#" + $(this).attr('id')).closest("form").find(".dt-bhk").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".dt-bhk").val('');
            }

            if ($("#" + $(this).attr('id')).closest("form").find(".dt-sqr-ft").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".dt-sqr-ft").val('');
            }

            if ($("#" + $(this).attr('id')).closest("form").find(".dt-carpet-area").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".dt-carpet-area").val('');
            }
        });
    }

    function towerUnitDd() {
        $("#filter_tower_unit_id,.towerUnitDd").select2({
            ajax: {
                url: "<?= admin_url('Tower/getTowerUnitDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    var societyId;
                    if ($("#society_id").length > 0) {
                        societyId = $("#society_id").val() || 0;
                    }
                    var towerId;
                    if ($("#tower_id").length > 0) {
                        towerId = $("#tower_id").val() || 0;
                    }
                    return {
                        society_id: societyId,
                        tower_id: towerId,
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Floor',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function(towerUnit) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }

            var towerUnitData = towerUnit.params.data;
            var bhk = towerUnitData.bhk;
            var sqrFt = towerUnitData.sqr_ft;
            var carpetArea = towerUnitData.carpet_area;

            if ($("#" + $(this).attr('id')).closest("form").find(".dt-bhk").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".dt-bhk").val(bhk);
            }

            if ($("#" + $(this).attr('id')).closest("form").find(".dt-sqr-ft").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".dt-sqr-ft").val(sqrFt);
            }

            if ($("#" + $(this).attr('id')).closest("form").find(".dt-carpet-area").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".dt-carpet-area").val(carpetArea);
            }

            
        }).on('select2:unselect', function() {
            // Handle when user clears selection
            var elementId = $(this).attr('id');
            $("#" + elementId).removeClass('success').addClass('invalid');

            if ($("#" + $(this).attr('id')).closest("form").find(".dt-bhk").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".dt-bhk").val('');
            }

            if ($("#" + $(this).attr('id')).closest("form").find(".dt-sqr-ft").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".dt-sqr-ft").val('');
            }

            if ($("#" + $(this).attr('id')).closest("form").find(".dt-carpet-area").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".dt-carpet-area").val('');
            }
        });
    }

    function vendorDd() {
        $("#filter_vendor_id,.vendorDd").select2({
            ajax: {
                url: "<?= admin_url('Vendor/getVendorDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Vendor',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function(vendor) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
            var vendorData = vendor.params.data;
            var vendorId = vendorData.id;

            if ($(".dt-view_vendor-detail").length > 0) {
                $(".dt-view_vendor-detail").addClass('dt-detail-model-view');
                $(".dt-view_vendor-detail").attr('data-dt_view_id', vendorId);
                $(".dt-view_vendor-detail").attr('data-dt_view_url', '<?= admin_url("Vendor/view"); ?>');
            }
        });
    }

    function amcDd() {
        $("#filter_amc_id,.amcDd,#amc_id").select2({
            ajax: {
                url: "<?= admin_url('AMC/getAmcDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    var vendorId;
                    if ($("#vendor_id").length > 0) {
                        vendorId = $("#vendor_id").val() || 0;
                    }
                    return {
                        vendor_id: vendorId,
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select AMC',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function(amc) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }

            var amcData = amc.params.data;
            var periodFrom = amcData.period_from;
            var periodTo = amcData.period_upto;

            if($('#dt-amc-period').length > 0){
                var tempDateFrom = new Date(periodFrom);
                var tempDateTo = new Date(periodTo);
                $("#dt-amc-period").text('<?= lang("Visit.amc_period"); ?>' +' = '+ [ tempDateFrom.getDate(),tempDateFrom.getMonth() + 1, tempDateFrom.getFullYear()].join('-') + ' To '  + [ tempDateTo.getDate(),tempDateTo.getMonth() + 1, tempDateTo.getFullYear()].join('-'));
            }


        });
    }

	function flatDd() {
		$("#filter_flat_id,.flatDd").select2({
			ajax: {
				url: "<?= admin_url('Flat/getFlatDd') ?>",
				dataType: 'json',
				type: 'post',
				delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
				data: function(params) {
					var isTowerFlat;
					var ownershipFlatId;
					var intercomId;
					var rentalId;
					var societyId;
                    var towerId;
					if ($(".dt-tower-flat").length > 0) {
						isTowerFlat = 1;
					}

					if ($(".dt-society").length > 0) {
						societyId = $("#society_id").val() || 0;
					}

					if ($("#ownership_flat_id").length > 0) {
						ownershipFlatId = $("#ownership_flat_id").val() || 0;
					}

                    if ($("#tower_id").length > 0) {
						towerId = $("#tower_id").val() || 0;
					}

					if ($("#intercom_id").length > 0) {
						intercomId = $("#intercom_id").val() || 0;
					}

					if ($("#rental_id").length > 0) {
						rentalId = $("#rental_id").val() || 0;
					}

					return {
						filter_param: params.term || '', // search term
						page: params.page || 1,
						is_tower_flat: isTowerFlat,
						society_id: societyId,
						tower_id: towerId,
						<?php if(isset($isOwnershipFlat)){ ?>
							is_ownership_flat:'1',
							ownership_flat_id: ownershipFlatId,
						<?php } ?>

						<?php if(isset($isIntercomFlat)){ ?>
							is_intercom_flat:'1',
							intercom_id: intercomId,
						<?php } ?>

						<?php if(isset($isRentalFlat)){ ?>
							is_rental_flat:'1',
							rental_id: rentalId,
						<?php } ?>

					};
				},
				processResults: function(data, params) {
					// parse the results into the format expected by Select2
					// since we are using custom formatting functions we do not need to
					// alter the remote JSON data, except to indicate that infinite
					// scrolling can be used
					//                    params.page = params.page || 1;

					return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows
                        }
					};
				},
				//cache: true
			},
			placeholder: 'Select Flat No',
			escapeMarkup: function(markup) {
				return markup;
			}, // let our custom formatter work
			//minimumInputLength: 2,
		}).on('select2:select', function(flat) {
			if ($("#" + $(this).attr('id')).valid()) {
				$("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
			}

			var flatData = flat.params.data;
			var towerId = flatData.tower_id;
			var flatId = flatData.id;
			if ($("#" + $(this).attr('id')).closest("form").find(".dt-tower-flat-id").length > 0) {
				$("#" + $(this).attr('id')).closest("form").find(".dt-tower-flat-id").val(towerId);
			}
			if ($("#" + $(this).attr('id')).closest("form").find(".parkingSlotDd").length > 0) {
				$("#" + $(this).attr('id')).closest("form").find(".parkingSlotDd").val('').trigger('change.select2');
			}
			if ($("#" + $(this).attr('id')).closest("form").find(".ownershipFlatMemberDd").length > 0) {
				$("#" + $(this).attr('id')).closest("form").find(".ownershipFlatMemberDd").val('').trigger('change.select2');
			}
            if ($(".dt-view_flat-detail").length > 0) {
                $(".dt-view_flat-detail").addClass('dt-detail-model-view');
                $(".dt-view_flat-detail").attr('data-dt_view_id', flatId);
                $(".dt-view_flat-detail").attr('data-dt_view_url', '<?= admin_url("Flat/view"); ?>');
            }
		});
	}

    function memberDd() {
        $("#filter_member_id,.memberDd").select2({
            ajax: {
                url: "<?= admin_url('Member/getMemberDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Member',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function eventDd() {
        $("#filter_event_id,.eventDd").select2({
            ajax: {
                url: "<?= admin_url('Event/getEventDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Event',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,

        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function tagDd() {
        $("#filter_tag_id,.tagDd").select2({
            ajax: {
                url: "<?= admin_url('Tag/getTagDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Tag',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function gateDd() {
        $("#filter_gate_id,.gateDd").select2({
            ajax: {
                url: "<?= admin_url('Gate/getGateDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Gate',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function parkingAreaDd() {
        $("#filter_parking_area_id,.parkingAreaDd").select2({
            ajax: {
                url: "<?= admin_url('ParkingArea/getParkingAreaDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Parking Area',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function parkingVehicleDd() {
        $("#filter_parking_vehicle_id,.parkingVehicleDd").select2({
            ajax: {
                url: "<?= admin_url('ParkingArea/getParkingVehicleDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Parking Vehicle',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function(parkingVehicle) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }

            var parkingVehicleData = parkingVehicle.params.data;
            if ($(".dt-parking-area-id").length > 0) {
                $(".dt-parking-area-id").val(parkingVehicleData.remarks);
            }

        });
    }

    function managementCommitteeResponsibilitiesDd() {
        $("#filter_management_committee_responsibilities_id,.managementCommitteeResponsibilitiesDd").select2({
            ajax: {
                url: "<?= admin_url('ManagementCommitteeResponsibilities/getManagementCommitteeResponsibilitiesDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Responsibilities',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function documentDd() {
        $("#filter_document_id,.documentDd").select2({
            ajax: {
                url: "<?= admin_url('Document/getDocumentDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    var societyId;
                    if ($("#society_id").length > 0) {
                        societyId = $("#society_id").val() || 0;
                    }
                    return {
                        society_id: societyId,
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Document',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,
        }).on('select2:select', function(parkingPlace) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        })
    }

    function amenitiesDd() {
        $("#filter_amenities_id,.amenitiesDd").select2({
            ajax: {
                url: "<?= admin_url('Amenities/getAmenitiesDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1,
                        <?php if(isset($isFacilitiesAmenities)){ ?>
							type: 'facilities'
						<?php } ?>

                        <?php if(isset($isAmenities)){ ?>
							type: 'amenities'
						<?php } ?>
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        },
                    };
                },
                //cache: true
            },
            placeholder: 'Select Amenities',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
            if ($("#" + $(this).attr('id')).closest("form").find(".amenitiesUnitDd").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".amenitiesUnitDd").val('').trigger('change.select2');
            }
        });
    }

    function amenitiesUnitDd() {
        $("#filter_amenities_unit_id,.amenitiesUnitDd").select2({
            ajax: {
                url: "<?= admin_url('Amenities/getAmenitiesUnitDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    var amenitiesId;
                    if ($("#amenities_id").length > 0) {
                        amenitiesId = $("#amenities_id").val() || 0;
                    }
                    return {
                        amenities_id: amenitiesId,
                        filter_param: params.term || '', // search term
                        page: params.page || 1,
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        },
                    };
                },
                //cache: true
            },
            placeholder: 'Select Amenities Unit',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function accountDd() {
        $(".accountDd").select2({
            ajax: {
                url: "<?= admin_url('Account/getAccountDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1,
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        },
                    };
                },
                //cache: true
            },
            placeholder: 'Select Account',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function subAccountDd() {
        $(".subAccountDd").select2({
            ajax: {
                url: "<?= admin_url('SubAccount/getSubAccountDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1,
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        },
                    };
                },
                //cache: true
            },
            placeholder: 'Select Sub Account',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function timeSlotDd() {
        $("#filter_time_slot_id,.timeSlotDd").select2({
            ajax: {
                url: "<?= admin_url('TimeSlot/getTimeSlotDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Time Slot',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function waterTankDd() {
        $("#filter_water_tank_id,.waterTankDd").select2({
            ajax: {
                url: "<?= admin_url('WaterTank/getWaterTankDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    var societyId;
                    if ($("#society_id").length > 0) {
                        societyId = $("#society_id").val() || 0;
                    }
                    return {
                        society_id: societyId,
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Water Tank',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function resourceTypeDd() {
        $("#filter_resource_type_id,.resourceTypeDd").select2({
            ajax: {
                url: "<?= admin_url('ResourceType/getResourceTypeDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    var societyId;
                    if ($("#society_id").length > 0) {
                        societyId = $("#society_id").val() || 0;
                    }
                    return {
                        society_id: societyId,
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Resource Type',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function(resourceType) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }

            var resourceTypeData = resourceType.params.data;
            var isLogin = resourceTypeData.is_login;
            var groupId = resourceTypeData.group_id;
            var isGuard = resourceTypeData.is_guard;


            if ($("#" + $(this).attr('id')).closest("form").find(".dt-is-login").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".dt-is-login").val(isLogin);
            }

            if ($("#" + $(this).attr('id')).closest("form").find(".dt-group-id").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".dt-group-id").val(groupId);
            }
            if ($("#" + $(this).attr('id')).closest("form").find(".dt-is-guard").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".dt-is-guard").val(isGuard);
            }

            if(isGuard == 1){
                $("div.resource-flat").hide();
                $("div.dt-gate").show();
            }
            else{
                $("div.resource-flat").show();
                $("div.dt-gate").hide();
            }

            if ($("#" + $(this).attr('id')).closest("form").find(".resourceDd").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".resourceDd").val('').trigger('change.select2');
            }


        }).on('select2:unselect', function() {
            // Handle when user clears selection
            var elementId = $(this).attr('id');
            $("#" + elementId).removeClass('success').addClass('invalid');

            if ($("#" + $(this).attr('id')).closest("form").find(".resourceDd").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".resourceDd").val('').trigger('change.select2');
            }
        });
    }

    function parkingSlotDd() {
        $("#filter_parking_slot_id,.parkingSlotDd").select2({
            ajax: {
                url: "<?= admin_url('ParkingSlot/getParkingSlotDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    var flatId;
                    if ($("#flat_id").length > 0) {
                        flatId = $("#flat_id").val() || 0;
                    }
                    var vehicleType;
                    if($(this).closest('tr').find(".dt-vehicle-type").length > 0){
                        vehicleType = $(this).closest('tr').find(".dt-vehicle-type").val();
                    }

                    return {
                        vehicle_type: vehicleType,
                        flat_id: flatId,
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Parking Slot',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,
        }).on('select2:select', function(parkingSlot) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
            var parkingSlotData = parkingSlot.params.data;
            var number = parkingSlotData.number;


            var vehicleType = $("#" + $(this).attr('id')).closest("tr").find(".dt-vehicle-type").val();
            if (vehicleType == '4_wheelers' || vehicleType == '2_wheelers') {
                if ($("#" + $(this).attr('id')).closest("tr").find(".dt-parking-slot-no").length > 0) {
                    $("#" + $(this).attr('id')).closest("tr").find(".dt-parking-slot-no").val(number);
                }
            }
        });
    }

    function ownerMemberDd() {
        $("#filter_owner_member_id,.ownerMemberDd").select2({
            ajax: {
                url: "<?= admin_url('OwnershipFlat/getOwnershipMemberDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    var flatId;
                    if ($("#flat_id").length > 0) {
                        flatId = $("#flat_id").val() || 0;
                    }

                    return {
                        flat_id: flatId,
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Member',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,
        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function ownershipFlatVehicleDd() {
        $("#filter_ownership_flat_vehicle_id,.ownershipFlatVehicleDd").select2({
            ajax: {
                url: "<?= admin_url('OwnershipFlat/getOwnershipFlatParkingDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    var flatId;
                    if ($("#flat_id").length > 0) {
                        flatId = $("#flat_id").val() || 0;
                    }
                    var vehicleType;
                    if($(this).closest('tr').find(".dt-vehicle-type").length > 0){
                        vehicleType = $(this).closest('tr').find(".dt-vehicle-type").val();
                    }

                    return {
                        vehicle_type: vehicleType,
                        flat_id: flatId,
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Parking Slot',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,
        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function manufacturerDd() {
        $("#filter_manufacturer_id,.manufacturerDd").select2({
            ajax: {
                url: "<?= admin_url('Manufacturer/getManufacturerDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Manufacturer',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,
        }).on('select2:select', function(commonArea) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
            var commonAreaData = commonArea.params.data;
        });
    }

    function userDd() {
        $(".userDd").select2({
            ajax: {
                url: "<?= admin_url('Complain/getUserDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function (params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function (data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //params.page = params.page || 1;
                    return {
                        // results: data.result,
                        // pagination: {
                        // 	more: (params.page * 10) < data.totalRows
                        //
                        // }
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows
                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select User',
            escapeMarkup: function (markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,
            // templateResult: formatRepo, // omitted for brevity, see the source of this page
            // templateSelection: formatRepoSelection // omitted for brevity, see the source of this page


        }).on('select2:select', function (user) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function groupDd() {
        $(".groupDd").select2({
            ajax: {
                url: "<?= admin_url('Complain/getGroupDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function (params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function (data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //params.page = params.page || 1;
                    return {
                        // results: data.result,
                        // pagination: {
                        //  more: (params.page * 10) < data.totalRows
                        //
                        // }
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows
                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Group',
            escapeMarkup: function (markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,
            // templateResult: formatRepo, // omitted for brevity, see the source of this page
            // templateSelection: formatRepoSelection // omitted for brevity, see the source of this page


        }).on('select2:select', function (group) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function commonAreaDd() {
        $("#filter_common_area_id,.commonAreaDd").select2({
            ajax: {
                url: "<?= admin_url('CommonArea/getCommonAreaDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    var intercomId;
                    if ($("#intercom_id").length > 0) {
                        intercomId = $("#intercom_id").val() || 0;
                    }
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1,
                        <?php if(isset($isInterComCommonArea)){ ?>
                        is_intercom_common_area:'1',
                        intercom_id: intercomId,
                        <?php } ?>
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Common Area',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,
        }).on('select2:select', function(commonArea) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
            var commonAreaData = commonArea.params.data;
        });
    }

    function bankDd() {
        $("#filter_bank_id,.bankDd").select2({
            ajax: {
                url: "<?= admin_url('Bank/getBankDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Bank',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function taxDd() {
        $("#filter_tax_id,.taxDd").select2({
            ajax: {
                url: "<?= admin_url('Tax/getTaxDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Tax',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function itemDd() {
        $("#filter_item_id,.itemDd").select2({
            ajax: {
                url: "<?= admin_url('Item/getItemDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Item',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function(item) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }

            var itemData = item.params.data;
            var manufacturerId = itemData.manufacturer_id;
            var manufacturerName = itemData.manufacturer_name;
            var warrantyPeriodTo = itemData.warranty_period_to;
            var warrantyPeriodFrom = itemData.warranty_period_from;

            var itemName = itemData.item_name;

            if(manufacturerId != 0){
                $("#manufacturer_id").empty().trigger('change');
                var manufacturerOption = new Option(manufacturerName,manufacturerId, true, true);
                // $("#" + $(this).attr('id')).closest("form").find(".dt-manufacturer").append(manufacturerOption).trigger('change.select2');
                // $("#" + $(this).attr('id')).closest("form").find(".dt-manufacturer").val('').trigger('change.select2');
                $('#manufacturer_id').append(manufacturerOption).trigger('change.select2');
            }

            $("#warranty_period_to").val(warrantyPeriodTo);
            $("#warranty_period_from").val(warrantyPeriodFrom);
            if ($("#" + $(this).attr('id')).closest("tr").find(".dt-item-name").length > 0) {
                $("#" + $(this).attr('id')).closest("tr").find(".dt-item-name").val(itemName);
            }
        });
    }
    function financialYearDd() {
        $(".financialYearDd,#filter_financial_year_id").select2({
            ajax: {
                url: "<?= admin_url('Investments/getFinancialYearDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Year',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function ownershipFlatMemberDd() {
        $(".ownershipFlatMemberDd,#filter_owner_member_id").select2({
            ajax: {
                url: "<?= admin_url('OwnershipFlat/getOwnershipFlatMemberDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    var flatId;
                    if ($(".dt-flat").length > 0) {
                        flatId = $(".dt-flat").val() || 0;
                    }
                    if ($("#filter_flat_id").length > 0) {
                        flatId = $("#filter_flat_id").val() || 0;
                    }
                    if ($(".ownerflatDd").length > 0) {
                        flatId = $(".ownerflatDd").val() || 0;
                    }
                    return {
                        flat_id: flatId,
                        <?php if(isset($isParentPurchaseFrom)){ ?>
                        parent_ownership_flat_id : '<?= $isParentPurchaseFrom ?>',
                        <?php } ?>
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;

                    //console.log('data',data);
                    //console.log('params',params);
                    //console.log('page',data.page);
                    var dataResultArray = [];
                    var dataResult = data.result;

                    //console.log('dataResult',dataResult);
                    if(data.page == 1){
                        if(dataResult.length != 0){
                            //dataResult.push({'id':'-1','text':'<?= BUILDER; ?>'})
                            //data.result = dataResult;
                        }
                        else {
                            dataResultObject = [];
                            dataResultObject['id'] = '-1';
                            dataResultObject['text'] = '<?= BUILDER; ?>';
                            dataResultArray.push(dataResultObject);
                            data.result = dataResultArray;
                       }
                    }
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Member',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function(member) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }

            var memberData = member.params.data;
            var memberMobileNo = memberData.mobile_no;
            $("#owner_contact_no").val(memberMobileNo);
            if ($("#mobile_no").length > 0) {
                $("#mobile_no").val(memberMobileNo);
            }
        });
    }

    function brokerDd() {
        $(".brokerDd,#filter_broker_id").select2({
            ajax: {
                url: "<?= admin_url('Broker/getBrokerDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Broker',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function(broker) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
            var brokerData = broker.params.data;
            var brokerPhoneNumber = brokerData.broker_phone_number;
            $("#broker_contact_no").val(brokerPhoneNumber);
        });
    }

    function ownerflatDd() {
        $(".ownerflatDd").select2({
            ajax: {
                url: "<?= admin_url('OwnershipFlat/getOwnershipFlatDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {

                    var rentalId;
                    var societyId;

                    if ($(".dt-society").length > 0) {
                        societyId = $("#society_id").val() || 0;
                    }


                    if ($("#rental_id").length > 0) {
                        rentalId = $("#rental_id").val() || 0;
                    }
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1,
                        <?php if(isset($isRentalFlat)){ ?>
                            is_rental_flat:'1',
                            rental_id: rentalId,
                        <?php } ?>
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Owner Flat ',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function(ownershipFlat) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }


            var ownershipFlatData = ownershipFlat.params.data;
            var ownershipFlatId = ownershipFlatData.ownership_flat_id;
            var flatId = ownershipFlatData.id;
            if ($("#parent_ownership_flat_id").length > 0) {
                $("#parent_ownership_flat_id").val(ownershipFlatId);
            }

            if ($(".ownership_flat_id").length > 0) {
                $(".ownership_flat_id").val(ownershipFlatId);
            }

            if ($(".dt-view_flat-detail").length > 0) {
                $(".dt-view_flat-detail").addClass('dt-detail-model-view');
                $(".dt-view_flat-detail").attr('data-dt_view_id', flatId);
                $(".dt-view_flat-detail").attr('data-dt_view_url', '<?= admin_url("Flat/view"); ?>');
            }
        });
    }

    function staffDd() {
        $("#filter_staff_id,.staffDd").select2({
            ajax: {
                url: "<?= admin_url('Staff/getStaffDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Staff',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function resourceDd() {
        $("#filter_resource_id,.resourceDd").select2({
            ajax: {
                url: "<?= admin_url('Resource/getResourceDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    var resourceTypeId = '';
                    if ($(".dt-resource-type").length > 0) {
                        resourceTypeId = $(".dt-resource-type").val() || 0;
                    }

                    var filterResourceTypeId = '';
                    if ($("#filter_resource_type_id").length > 0) {
                        filterResourceTypeId = $("#filter_resource_type_id").val() || 0;
                    }
                    return {
                        resource_type_id: resourceTypeId,
                        filter_resource_type_id: filterResourceTypeId,
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Resource',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function(resource) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function generatorDd() {
        $("#filter_generator_id,.generatorDd").select2({
            ajax: {
                url: "<?= admin_url('Generator/getGeneratorDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Generator',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,
        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function forumDd() {
        $("#filter_forum_id,.forumDd").select2({
            ajax: {
                url: "<?= admin_url('Forum/getForumDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1,
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;

                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows
                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Forum',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,
        }).on('select2:select', function(forum) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function timeSlotDd() {
        $(".timeSlotDd,#filter_time_slot_id").select2({
            ajax: {
                url: "<?= admin_url('TimeSlot/getTimeSlotDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function (params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function (data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Time Slot',
            escapeMarkup: function (markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function () {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function statusDd() {
        $(".statusDd,#filter_status_id").select2({
            ajax: {
                url: "<?= admin_url('Status/getStatusDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Status',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function intercomTypeDd() {
        var intercomType = $("#intercom_type").val();

        console.log(intercomType);
        if(intercomType == 'flat'){
            var url = "<?= admin_url('Flat/getFlatDd') ?>";
        }
        else if(intercomType == 'common_area'){
            var url = "<?= admin_url('CommonArea/getCommonAreaDd') ?>";
        }
        else{
            var url = '';
        }
        $(".intercomTypeDd,#filter_intercom_type_id").select2({
            ajax: {
                url: url,
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Intercom Type',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function flatTypeDd() {
        var flatType = $("#flat_type").val();

        console.log(flatType);
        if(flatType == 'rentals'){
            var url = "<?= admin_url('Rentals/getAllRentalsMemberDd') ?>";
        }
        else if(flatType == 'ownership_flat'){
            var url = "<?= admin_url('OwnershipFlat/getAllOwnershipFlatMemberDd') ?>";
        }
        else{
            var url = '';
        }
        $(".flatTypeDd,#filter_type_id").select2({
            ajax: {
                url: url,
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Flat Type',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }
    function categoryDd() {
        $("#category_id,#filter_category_id").select2({
            ajax: {
                url: "<?= admin_url('Category/getCategoryDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        category_for: $("#category_for").val(),
                        filter_param: params.term || '', // search term
                        page: params.page || 1,
                        <?php if(isset($isCategoryForResource)){ ?>
							category_for: 'resource'
						<?php } ?>
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Category',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function bankAccountDd() {
        $("#filter_bank_account_id,.bankAccountDd").select2({
            ajax: {
                url: "<?= admin_url('BankAccount/getBankAccountDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Bank Account',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function(bankAccount) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }

            console.log(bankAccount);
            
            var bankAccountData = bankAccount.params.data;
            var bankName = bankAccountData.bank_name;
            var branchName = bankAccountData.branch;
            var ifscCode = bankAccountData.ifsc_code;
            if ($("#bank_account_id").length > 0) {
                $("#bank").val(bankName);
                $("#branch").val(branchName);
                $("#ifsc_code").val(ifscCode);
            }

        });
    }

    function pollDd() {
        $("#filter_poll_id,.pollDd").select2({
            ajax: {
                url: "<?= admin_url('Poll/getPollDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Poll',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function pollOptionDd() {
        $("#filter_poll_option_id,.pollOptionDd").select2({
            ajax: {
                url: "<?= admin_url('Poll/getPollOptionDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Poll Option',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }


    function flatMemberDd() {
        $(".flatMemberDd").select2({
            ajax: {
                url: "<?= admin_url('ManagementCommittee/getFlatMemberDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {

                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Member',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function(member) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }

            var memberData = member.params.data;
            var memberMobileNo = memberData.mobile_no;
            var flatId = memberData.flat_id;
            var flatName = memberData.tower_flat_name;
            if ($("#mobile_no").length > 0) {
                $("#mobile_no").val(memberMobileNo);
            }

            if(flatId != 0 && ($("#flat_id").length > 0)){
                $("#flat_id").empty().trigger('change');
                var option = new Option(flatName, flatId, true, true);
                $('#flat_id').append(option).trigger('change.select2');
            }
        });
    }

    function getFlatMemberDd() {
        $(".getFlatMemberDd,#filter_flat_member_id").select2({
            ajax: {
                url: "<?= admin_url('EventBooking/getFlatMemberDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    return {

                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Member',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function(member) {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }

        });
    }

    function commonKeysDd() {
        $("#filter_common_keys_id,.commonKeysDd").select2({
            ajax: {
                url: "<?= admin_url('CommonKeys/getCommonKeysDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    var societyId;
                    if ($("#society_id").length > 0) {
                        societyId = $("#society_id").val() || 0;
                    }
                    return {
                        society_id: societyId,
                        filter_param: params.term || '', // search term
                        page: params.page || 1,
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    // params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Common Keys',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }

            if ($("#" + $(this).attr('id')).closest("form").find(".commonKeysAvailabilityDd").length > 0) {
                $("#" + $(this).attr('id')).closest("form").find(".commonKeysAvailabilityDd").val('').trigger('change.select2');
            }
        });
    }

    function commonKeysAvailabilityDd() {
        $("#filter_common_keys_availability_id,.commonKeysAvailabilityDd").select2({
            ajax: {
                url: "<?= admin_url('CommonKeys/getCommonKeysAvailabilityDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    var commonKeysId;
                    if ($("#common_keys_id").length > 0) {
                        commonKeysId = $("#common_keys_id").val() || 0;
                    }
                    if ($("#filter_common_keys_id").length > 0) {
                        commonKeysId = $("#filter_common_keys_id").val() || 0;
                    }
                    return {
                        common_keys_id: commonKeysId,
                        filter_param: params.term || '', // search term
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Common Keys',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }

    function materialReturnDd() {
        $(".materialReturnDd").select2({
            ajax: {
                url: "<?= admin_url('Material/getMaterialReturnDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
                data: function(params) {
                    var commonAreaId;
                    if ($("#common_area_id").length > 0) {
                        commonAreaId = $("#common_area_id").val() ;
                    }
                    return {
                        filter_param: params.term || '', // search term
                        page: params.page || 1,
                        common_area_id: commonAreaId
                    };
                },
                processResults: function(data, params) {
                    // parse the results into the format expected by Select2
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data, except to indicate that infinite
                    // scrolling can be used
                    //                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (data.page * 10) < data.totalRows

                        }
                    };
                },
                //cache: true
            },
            placeholder: 'Select Return',
            escapeMarkup: function(markup) {
                return markup;
            }, // let our custom formatter work
            //minimumInputLength: 2,


        }).on('select2:select', function() {
            if ($("#" + $(this).attr('id')).valid()) {
                $("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
            }
        });
    }
</script>