<?php
$html = '';
if (isset($key_availability_data) && !empty($key_availability_data)) {
	foreach ($key_availability_data as $key => $value) {
		$data["row_number"] = $key + 1;
		$data["key_availability_data"] = $value;
		$html .= view('Admin/CommonKeys/KeyAvailabilityTableRowView', $data);
	}
}
?>
<!-- Responsive Table -->
	<div class="table-responsive text-nowrap">
		<table id="key_availability_table" class="table">
			<thead>
			<tr class="text-nowrap">
				<th><?= lang('CommonMessage.common_sr_no'); ?></th>
				<th><?= lang('CommonKeys.key_name'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('CommonMessage.common_action'); ?></th>
			</tr>
			</thead>
			<tbody class="table-border-bottom-0">
			<?php
			if (isset($key_availability_data) && !empty($key_availability_data)) {
				echo $html;
			}else { ?>
				<?php
				$data["row_number"] =  1;
				echo view('Admin/CommonKeys/KeyAvailabilityTableRowView',$data); ?>
			<?php } ?>

			</tbody>
		</table>
	</div>
<!--/ Responsive Table -->
<script>
	var rowNumber;

	function addKeyAvailability() {
		var lastIndex = ($("#key_availability_table tbody tr:last").length >= 1) ? $("#key_availability_table tbody tr:last").attr("data-id").split("_").pop() : 0;
		rowNumber = parseInt(lastIndex) + 1;
		$.ajax({
			type: "post",
			url: "<?= admin_url('CommonKeys/addKeyAvailabilityRow'); ?>",
			dataType: "html",
			async: false,
			data: {
				row_number: rowNumber,
			},
			success: function (data) {
				if (data) {
					$('table#key_availability_table tbody').append(data);
					addSerialNumber('key_availability_table');
					numberInit();
					keyAvailability();
				}
			}
		});
	}


	$(document).on('click', '.dt-delete-key-row', function () {
		var trField = $(this).closest('tr');
		var id = $(this).closest('tr').find(".common_keys_availability_id").val();
		var commonKeysId = $("#common_keys_id").val();
		if (id != '') {
				Swal.fire({
					title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
					text: "<?= lang('CommonMessage.delete_warning'); ?>",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'OK',
					customClass: {
						confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
						cancelButton: 'btn btn-label-secondary waves-effect waves-light'
					},
					buttonsStyling: false

			}).then(function (result) {
				if (result.value) {
					var deleteId = [];
					deleteId.push(id);
					$.ajax({
						type: "POST",
						url: "<?php echo admin_url('CommonKeys/deleteKeyAvailabilityRow');?>",
						dataType: "json",
						async:false,
						data: {
                            common_keys_availability_id: deleteId,
							common_keys_id: commonKeysId
						},
						success: function (resObj) {
							if (resObj.success) {
								$(trField).remove();
								addSerialNumber('key_availability_table');
								Swal.fire({
									title: 'Success',
									text: resObj['msg'],
									icon: 'success',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								}).then(function() {
									if ($('#key_availability_table tbody > tr').length == 0) {
										addKeyAvailability();
									}
								});
							} else {
								Swal.fire({
									title: 'Error!',
									text: resObj['msg'],
									icon: 'error',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								});
							}
						}
					});
				}
			});
		} else {
			$(trField).remove();
			addSerialNumber('key_availability_table');
			if ($('#key_availability_table tbody > tr').length == 0) {
				addKeyAvailability();
			}
		}
	});


</script>
