<?php $dtCIAcl = new \App\Libraries\Dt_ci_acl(); ?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('CommonKeys.common_keys_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_common_keys',
				);
				echo form_open_multipart('',$form_id);
				$commonKeysId = (isset($common_keys_data['common_keys_id']) && ($common_keys_data['common_keys_id'] != '')) ? $common_keys_data['common_keys_id'] : '';
				?>
				<input type="hidden" id="common_keys_id" name="common_keys_id" value="<?= $commonKeysId ?>">

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonKeys.description');?><span class="text-danger"> * </span></label>
						<div class="col-sm-10">
							<textarea name="description"  id="description" placeholder="Enter <?= lang('CommonKeys.description'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($common_keys_data['description']) && ($common_keys_data['description'] != '')) ? $common_keys_data['description'] : ''; ?></textarea>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonKeys.remarks');?></label>
						<div class="col-sm-10">
							<textarea name="remarks"  id="remarks" placeholder="Enter <?= lang('CommonKeys.remarks'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($common_keys_data['remarks']) && ($common_keys_data['remarks'] != '')) ? $common_keys_data['remarks'] : ''; ?></textarea>
						</div>
					</div>

					

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
							<div class="col-sm-10">
							<label class="switch switch-sm"><span class="switch-label"></span>
								<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($common_keys_data['is_active']) || $common_keys_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
								<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
								
							</label>
						</div>
					</div>

					<hr class="my-4 mx-n4" />
		            <h6> <?= lang('CommonKeys.common_key_availability_information'); ?></h6>
		            <div class="row">
		                <?= isset($key_availability_table) ? $key_availability_table : ""; ?>
		            </div>
		            <?php if ($dtCIAcl->checkAccess('CommonKeys|manage')) { ?>
						<button type="button" class="btn btn-xs btn-primary" onclick="addKeyAvailability()">
							<i class="ti ti-plus me-1"></i>
							<span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
						</button>
					<?php } ?>
		            <hr class="my-4 mx-n4" />

					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('CommonKeys'); ?>'" class="btn btn-label-secondary">Cancel</button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>

	function keyAvailability() {
		addValidation("input", ".dt-keys-name", {
			required: true,
			messages: {
				required: "Please Enter "+"<?= lang('CommonKeys.keys_name');?>",
			}
		});
	}

    $(document).ready(function() {
    	numberInit();
		switcheryKeyGen("datatable-list-switchery");
		addSerialNumber("key_availability_table");
        // Initialize
		var validator = $("#form_common_keys").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				description : {
					required : true,
				},
				
				
            },
            messages: {
				description: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('CommonKeys.description');?>"
				},
				
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("CommonKeys/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('CommonKeys');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('CommonKeys');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });

        keyAvailability();
        $("#reading_date_time").flatpickr({
			// monthSelectorType: 'static',
    		enableTime: true,
    		dateFormat: "d-m-Y H:i",
			// dateFormat: 'd-m-Y'
		});
    });
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
