<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#charges_detail" aria-controls="charges_detail" aria-selected="true">
			<?= lang('Charges.charges_detail'); ?>
		</button>
	</li>
	
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="charges_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="charges_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Charges.fee_type"); ?></td>
						<td><?php
							echo (isset($charges_data['fee_type']) && $charges_data['fee_type'] != "") ? underscoreToUcWord($charges_data['fee_type']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Charges.charges_name"); ?></td>
						<td><?php
							echo (isset($charges_data['charges_name']) && $charges_data['charges_name'] != "") ? $charges_data['charges_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Charges.amount"); ?></td>
						<td><?php
							echo (isset($charges_data['amount']) && $charges_data['amount'] != "") ? indianMoneyFormat($charges_data['amount']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Charges.deposit"); ?></td>
						<td><?php
							echo (isset($charges_data['deposit']) && $charges_data['deposit'] != "") ? indianMoneyFormat($charges_data['deposit']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Charges.gst"); ?></td>
						<td><?php
							echo (isset($charges_data['tax_name']) && $charges_data['tax_name'] != "") ? $charges_data['tax_name'] : '-';
							?></td>
					</tr>
					<tr>
						<td><?= lang("Charges.remarks"); ?></td>
						<td><?php
							echo (isset($charges_data['remarks']) && $charges_data['remarks'] != "") ? $charges_data['remarks'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($charges_data['created_at']) && isValidDate($charges_data['created_at'])) ? siteDateFormat($charges_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($charges_data['created_by']) && $charges_data['created_by'] != "") ? $charges_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($charges_data['updated_at']) && isValidDate($charges_data['updated_at'])) ? siteDateFormat($charges_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($charges_data['updated_by']) && $charges_data['updated_by'] != "") ? $charges_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	
</div>