<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Banner.banner_form');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_banner',
				);
				echo form_open_multipart('',$form_id);
				$bannerId = (isset($banner_data['banner_id']) && ($banner_data['banner_id'] != '')) ? $banner_data['banner_id'] : '';
				?>
				<input type="hidden" id="banner_id" name="banner_id" value="<?= $bannerId ?>">
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Banner.banner_title');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="banner_title" id="banner_title" placeholder="Enter <?= lang('Banner.banner_title');?>" value="<?= (isset($banner_data['banner_title']) && ($banner_data['banner_title'] != '')) ? $banner_data['banner_title'] : '';  ?>" />
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Banner.start_date');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<td>
							<input type="text"  name="start_date" id="start_date" class="form-control dt-start-date" placeholder="Select <?= lang('Banner.start_date'); ?>" value="<?= isset($banner_data['start_date']) ? YMDToDMY($banner_data['start_date']): ""; ?>"/>
						</td>
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Banner.end_date');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<td>
							<input type="text"  name="end_date" id="end_date" class="form-control dt-end-date" placeholder="Select <?= lang('Banner.end_date'); ?>" value="<?= isset($banner_data['end_date']) ? YMDToDMY($banner_data['end_date']): ""; ?>"/>
						</td>
					</div>
				</div>

				<div class="row mb-3">
                    <label class="col-sm-2 col-form-label"
                           for="basic-default-name"><?= lang('Banner.description'); ?><span
                                class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <textarea name="description"  id="description" placeholder="Enter <?= lang('Banner.description'); ?>" rows="3" cols="5"  class="form-control description"><?= (isset($banner_data['description']) && ($banner_data['description'] != '')) ? $banner_data['description'] : ''; ?></textarea>
                    </div>
                </div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Banner.sort_order');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="text" class="form-control numberInit" name="sort_order" id="sort_order" placeholder="Enter <?= lang('Banner.sort_order');?>" value="<?= (isset($banner_data['sort_order']) && ($banner_data['sort_order'] != '')) ? $banner_data['sort_order'] : '';  ?>" />
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Banner.banner_image');?><span class="text-danger"> </span></label>
					<div class="col-sm-10">
						<input type="file" accept="image/*" class="form-control" name="banner_image[]" multiple="multiple">
						<span class="form-text text-muted"><?= FILE_UPLOAD_TYPE_MSG; ?></span> <br>
						<?php 
	                    if(isset($image_data) && is_array($image_data) && !empty($image_data)){
	                        foreach($image_data as $image) { 
	                        	if(file_exists(DOCUMENT_IMAGE_PATH . $image['document_image'])){
	                        		$thumbnailPaths = site_url() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $image['document_image'];
			                        $paths = site_url() . DOCUMENT_IMAGE_PATH . $image['document_image']; ?> &nbsp;&nbsp;&nbsp;
			                 		<span class="document-image-<?= $image['document_image_id']; ?>">
			                 			<a href="<?= $paths; ?>" target="_blank"> 
											<img src="<?= $thumbnailPaths; ?>" width="100" class="img-fluid" alt=""> 
											<?php if(!empty($bannerId) && $dtCIAcl->checkAccess('Banner|deleteImage')) {?>
												<a href="javascript:void(0);"  id="<?php echo $image['document_image_id']; ?>" class="btn btn-icon btn-outline-dribbble delete-image"> <i class="tf-icons ti ti-trash"></i> </a> 
											<?php }?>
										</a>
			        				</span>
	            		<?php }} } ?>
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
					<div class="col-sm-10">
						<label class="switch switch-sm"><span class="switch-label"></span>
							<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($banner_data['is_active']) || $banner_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
							<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
						</label>
					</div>
				</div>

				<div class="pt-4">
					<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
					<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Banner'); ?>'" class="btn btn-label-secondary">Cancel</button>
				</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
	let startDate;
	let endDate;

	

	function startAndEndDate(){
		var startDate = $(".dt-start-date").flatpickr({
			//monthSelectorType: 'static',
			dateFormat: 'd-m-Y',
			onChange: function( selectedDates, dateStr, instance ) {
				endDate.set('minDate', dateStr)
			}
		});

		var endDate = $(".dt-end-date").flatpickr({
			//monthSelectorType: 'static',
			dateFormat: 'd-m-Y',
		});
	}
	$(document).ready(function() {
		numberInit();
		switcheryKeyGen("datatable-list-switchery");
		startAndEndDate();
		ckEditorInit('description');
		// Initialize
		var validator = $("#form_banner").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				banner_title: {
					required: true,
				},
				start_date: {
					required: true,
				},
				end_date: {
					required: true,
				},
				sort_order: {
					required: true,
					digits : true,
				},
				description: {
					required: true,
				}
			},
			messages: {
				banner_title: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Banner.banner_title"); ?>',
				},
				start_date: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Banner.start_date"); ?>',
				},
				end_date: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Banner.end_date"); ?>',
				},
				sort_order: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Banner.sort_order"); ?>',
				},
				description: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Banner.description"); ?>',
				}
			},
			submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Banner/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Banner');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Banner');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
			}
		});
	});

	$(document).on('click', '.delete-image', function () {
        var deleteId = $(this).attr("id");
		var bannerId = $("#banner_id").val();
        Swal.fire({
			title: "<?= ucwords(lang('CommonMessage.common_delete')); ?>",
			text: "<?= lang('CommonMessage.delete_warning'); ?>",
			icon: 'warning',
			showCancelButton: true,
			confirmButtonText: 'OK',
			customClass: {
				confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
				cancelButton: 'btn btn-label-secondary waves-effect waves-light'
			},
			buttonsStyling: false
		}).then(function(result) {
			if (result.value) {

				$("span.document-image-"+deleteId).remove();

		        $.ajax({
		            type: "post",
		            url: "<?= admin_url("Banner/deleteBannerImage")?>",
		            dataType: "json",
		            data: {document_image_id: deleteId,document_type_id:bannerId,document_type:'banner'},
		            success: function (data) {
		                if (data['success']) {
		                    $(".delete-image").click(function() {
		                        $(this).parent().remove();
		                    }); 
			                Swal.fire({
								title: 'Success',
								text: data['msg'],
								icon: 'success',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								dt_DataTable.ajax.reload();
							});
		                }
		                else{
		                    Swal.fire({
								title: 'Error!',
								text: data['msg'],
								icon: 'error',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								dt_DataTable.ajax.reload();
							});
		                }
		            }
		        });
		    }
		});
    });
</script>