<!-- Forgot Password -->
<div class="d-flex col-12 col-lg-5 align-items-center p-sm-5 p-4">
	<div class="w-px-400 mx-auto">
		<!-- Logo -->
		<div class="app-brand mb-4">
			<a href="index.html" class="app-brand-link gap-2">
                <span class="app-brand-logo demo">
                  <svg width="32" height="22" viewBox="0 0 32 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path
						fill-rule="evenodd"
						clip-rule="evenodd"
						d="M0.00172773 0V6.85398C0.00172773 6.85398 -0.133178 9.01207 1.98092 10.8388L13.6912 21.9964L19.7809 21.9181L18.8042 9.88248L16.4951 7.17289L9.23799 0H0.00172773Z"
						fill="#7367F0" />
                    <path
						opacity="0.06"
						fill-rule="evenodd"
						clip-rule="evenodd"
						d="M7.69824 16.4364L12.5199 3.23696L16.5541 7.25596L7.69824 16.4364Z"
						fill="#161616" />
                    <path
						opacity="0.06"
						fill-rule="evenodd"
						clip-rule="evenodd"
						d="M8.07751 15.9175L13.9419 4.63989L16.5849 7.28475L8.07751 15.9175Z"
						fill="#161616" />
                    <path
						fill-rule="evenodd"
						clip-rule="evenodd"
						d="M7.77295 16.3566L23.6563 0H32V6.88383C32 6.88383 31.8262 9.17836 30.6591 10.4057L19.7824 22H13.6938L7.77295 16.3566Z"
						fill="#7367F0" />
                  </svg>
                </span>
			</a>
		</div>
		<!-- /Logo -->
		<h3 class="mb-1">Society</h3>
		<?php
		$form_id = array(
			'id' => 'login_society_frm',
			'method' => 'post',
			'class' => 'mb-3'
		);
		echo form_open("Admin/Auth/user_society", $form_id); ?>

		<!-- Basic -->

			<div class="mb-3">
				<select id="society_id" name="society_id" class="select2 form-select"  data-placeholder="Select Society" >
					<option value="">Select Society</option>
					<?php
					foreach ($user_society_data as $societyData){ ?>
						<option value="<?= $societyData['society_id'] ?>"> <?= $societyData['society_name'] ?></option>
					<?php } ?>

				</select>
			</div>
			<button type="submit" class="btn btn-primary d-grid w-100">Submit</button>
		<?php echo form_close(); ?>

	</div>
</div>
<!-- /Forgot Password -->
<script>
	$(document).ready(function () {
		var validator = $("#login_society_frm").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				society_id: {
					required: true
				}
			},
			messages: {
				society_id: {
					required: "Please Select Society"
				}
			},
			submitHandler: function (form) {
				form.submit();
			}
		});
	});
</script>
