<!-- Reset Password -->
<div class="d-flex col-12 col-lg-5 align-items-center p-4 p-sm-5">
    <div class="w-px-400 mx-auto">
        <!-- Logo -->
        <div class="app-brand mb-4">
            <a href="index.html" class="app-brand-link gap-2">
                <span class="app-brand-logo demo">
                  <svg width="32" height="22" viewBox="0 0 32 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path
                            fill-rule="evenodd"
                            clip-rule="evenodd"
                            d="M0.00172773 0V6.85398C0.00172773 6.85398 -0.133178 9.01207 1.98092 10.8388L13.6912 21.9964L19.7809 21.9181L18.8042 9.88248L16.4951 7.17289L9.23799 0H0.00172773Z"
                            fill="#7367F0" />
                    <path
                            opacity="0.06"
                            fill-rule="evenodd"
                            clip-rule="evenodd"
                            d="M7.69824 16.4364L12.5199 3.23696L16.5541 7.25596L7.69824 16.4364Z"
                            fill="#161616" />
                    <path
                            opacity="0.06"
                            fill-rule="evenodd"
                            clip-rule="evenodd"
                            d="M8.07751 15.9175L13.9419 4.63989L16.5849 7.28475L8.07751 15.9175Z"
                            fill="#161616" />
                    <path
                            fill-rule="evenodd"
                            clip-rule="evenodd"
                            d="M7.77295 16.3566L23.6563 0H32V6.88383C32 6.88383 31.8262 9.17836 30.6591 10.4057L19.7824 22H13.6938L7.77295 16.3566Z"
                            fill="#7367F0" />
                  </svg>
                </span>
            </a>
        </div>
        <!-- /Logo -->
        <h4 class="mb-1">Reset Password 🔒</h4>
        <p class="mb-4">for <span class="fw-medium"><?= isset($email) ? $email : ''; ?></span></p>
        <?php
        //create  form open tag
        $form_id = array(
            'id' => 'form_reset_password',
            'method' => 'post',
            'class' => 'mb-3',
            'action' => 'Admin/Auth/reset_password/' . $code,

        );
        echo form_open_multipart('', $form_id); ?>

        <?php
        $user_id = (isset($user_id) && ($user_id != '')) ? $user_id : '';
        ?>
        <input type="hidden" name="user_id" value="<?= $user_id ?>" id="user_id" class="form-control">
        <div class="mb-3 form-password-toggle">
            <label class="form-label" for="password"><?php echo sprintf(lang('Auth.reset_password_new_password_label'), $minPasswordLength); ?></label>
            <div class="input-group input-group-merge">
                <input
                        type="password"
                        id="new"
                        class="form-control"
                        name="new"
                        placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                        aria-describedby="password"
                        pattern="<?php echo '^.{' . $minPasswordLength . '}.*$' ?>"/>
                <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
            </div>
        </div>
        <div class="mb-3 form-password-toggle">
            <label class="form-label" for="confirm-password"><?php echo lang('Auth.reset_password_new_password_confirm_label'); ?></label>
            <div class="input-group input-group-merge">
                <input
                        type="password"
                        id="new_confirm"
                        class="form-control"
                        name="new_confirm"
                        placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                        aria-describedby="password"
                        pattern="<?php echo '^.{' . $minPasswordLength . '}.*$' ?>" />
                <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
            </div>
        </div>
        <button type="submit" class="btn btn-primary d-grid w-100 mb-3"><?php echo lang('Auth.set_new_password'); ?></button>
        <div class="text-center">
            <a href="<?= admin_url("auth/login"); ?>">
                <i class="ti ti-chevron-left scaleX-n1-rtl"></i>
                <?php echo lang('Auth.back_to_login'); ?>
            </a>
        </div>
        <?php echo form_close();
        ?>
    </div>
</div>
<!-- /Reset Password -->
<script>
    $(document).ready(function () {

        var validator = $("#form_reset_password").validate({
            ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
            errorClass: 'validation-invalid-label',
            successClass: 'validation-valid-label',
            validClass: 'validation-valid-label',
            highlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            unhighlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },

            // Different components require proper error label placement
            errorPlacement: function (error, element) {

                // Styled checkboxes, radios, bootstrap switch
                if (element.parents('div').hasClass("checker") || element.parents('div').hasClass("choice") || element.parent().hasClass('bootstrap-switch-container')) {
                    if (element.parents('label').hasClass('checkbox-inline') || element.parents('label').hasClass('radio-inline')) {
                        error.appendTo(element.parent().parent().parent().parent());
                    } else {
                        error.appendTo(element.parent().parent().parent().parent().parent());
                    }
                }

                // Unstyled checkboxes, radios
                else if (element.parents('div').hasClass('checkbox') || element.parents('div').hasClass('radio')) {
                    error.appendTo(element.parent().parent().parent());
                }

                // Input with icons and Select2
                else if (element.parents('div').hasClass('has-feedback') || element.hasClass('select2-hidden-accessible')) {
                    error.appendTo(element.parent());
                }

                // Inline checkboxes, radios
                else if (element.parents('label').hasClass('checkbox-inline') || element.parents('label').hasClass('radio-inline')) {
                    error.appendTo(element.parent().parent());
                }

                // Input group, styled file input
                else if (element.parent().hasClass('uploader') || element.parents().hasClass('input-group')) {
                    error.appendTo(element.parent().parent());
                } else {
                    error.insertAfter(element);
                }
            },
            validClass: "validation-valid-label",
            success: function (label) {
                label.addClass("validation-valid-label").text("Success.")
            },
            rules: {
                new: {
                    required: true,
                    minlength: 8,
                    maxlength: 20
                },
                new_confirm: {
                    required: true,
                    equalTo: "#new",
                    minlength: 8,
                    maxlength: 20
                }
            },
            messages: {
                new: {
                    required: "Please enter new password",
                    minlength: "Please enter at least 8 characters",
                    maxlength: "Please enter no more than 20 characters"
                },
                new_confirm: {
                    required: "Please enter confirm new password",
                    equalTo: "New password and Confirm New Password must be same",
                    minlength: "Please enter at least 8 characters",
                    maxlength: "Please enter no more than 20 characters"
                }
            },
            submitHandler: function (form) {
                form.submit();
            }
        });
    });

</script>
