<!-- Login -->
<div class="d-flex col-12 col-lg-5 align-items-center p-sm-5 p-4">
    <div class="w-px-400 mx-auto">
        <!-- Logo -->
        <div class="app-brand mb-4">
            <a href="index.html" class="app-brand-link gap-2">
                <span class="app-brand-logo demo">
                  <svg width="32" height="22" viewBox="0 0 32 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path
                            fill-rule="evenodd"
                            clip-rule="evenodd"
                            d="M0.00172773 0V6.85398C0.00172773 6.85398 -0.133178 9.01207 1.98092 10.8388L13.6912 21.9964L19.7809 21.9181L18.8042 9.88248L16.4951 7.17289L9.23799 0H0.00172773Z"
                            fill="#7367F0" />
                    <path
                            opacity="0.06"
                            fill-rule="evenodd"
                            clip-rule="evenodd"
                            d="M7.69824 16.4364L12.5199 3.23696L16.5541 7.25596L7.69824 16.4364Z"
                            fill="#161616" />
                    <path
                            opacity="0.06"
                            fill-rule="evenodd"
                            clip-rule="evenodd"
                            d="M8.07751 15.9175L13.9419 4.63989L16.5849 7.28475L8.07751 15.9175Z"
                            fill="#161616" />
                    <path
                            fill-rule="evenodd"
                            clip-rule="evenodd"
                            d="M7.77295 16.3566L23.6563 0H32V6.88383C32 6.88383 31.8262 9.17836 30.6591 10.4057L19.7824 22H13.6938L7.77295 16.3566Z"
                            fill="#7367F0" />
                  </svg>
                </span>
            </a>
        </div>
        <!-- /Logo -->
        <h3 class="mb-1">Welcome to Society! 👋</h3>
        <p class="mb-4">Please sign-in to your account and start the adventure</p>
        <?php
        $form_id = array(
            'id' => 'form_login',
            'method' => 'post',
            'class' => 'mb-3'
        );

        echo form_open(current_url(), $form_id); ?>
        <?php if ($message != '') { ?>
            <div class="alert alert-danger alert-dismissible" role="alert">
                <?= $message ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php } ?>
        <div class="mb-3">
            <label for="email" class="form-label">Email or Username</label>
            <input
                    type="text"
                    class="form-control"
                    id="identity"
                    name="identity"
                    placeholder="Enter your email or username"
                    autofocus />
        </div>
        <div class="mb-3 form-password-toggle">
            <div class="d-flex justify-content-between">
                <label class="form-label" for="password">Password</label>
                <a href="<?php echo admin_url('Auth/forgot_password') ?>">
                    <small>Forgot Password?</small>
                </a>
            </div>
            <div class="input-group input-group-merge">
                <input
                        type="password"
                        id="password"
                        class="form-control"
                        name="password"
                        placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                        aria-describedby="password" />
                <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
            </div>
        </div>
        <?php /*
		<div class="mb-3">
			<div class="form-check">
				<input class="form-check-input" type="checkbox" id="remember-me" />
				<label class="form-check-label" for="remember-me"> Remember Me </label>
			</div>
		</div>
      	*/ ?>
        <button class="btn btn-primary d-grid w-100">Sign in</button>
        <?php echo form_close(); ?>

        <?php /*
		<p class="text-center">
			<span>New on our platform?</span>
			<a href="auth-register-cover.html">
				<span>Create an account</span>
			</a>
		</p>
 		*/ ?>

    </div>
</div>
<!-- /Login -->
<script>
    $(document).ready(function () {
        $('.select').each(function () {
            var select = $(this);
            $("#" + select.attr('id')).select2({ allowClear: true}).on('change.select2', function () {
                if ($("#" + select.attr('id')).valid()) {
                    $("#" + select.attr('id')).removeClass('invalid').addClass('success');
                }
            });
        });
        var validator = $("#form_login").validate({
            ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
            errorClass: 'validation-invalid-label',
            successClass: 'validation-valid-label',
            validClass: 'validation-valid-label',
            highlight: function(element, errorClass) {
                $(element).removeClass(errorClass);
            },
            unhighlight: function(element, errorClass) {
                $(element).removeClass(errorClass);
            },
            success: function(label) {
                label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
            },
            // Different components require proper error label placement
            errorPlacement: function(error, element) {

                // Unstyled checkboxes, radios
                if (element.parents().hasClass('form-check')) {
                    error.appendTo( element.parents('.form-check').parent() );
                }

                // Input with icons and Select2
                else if (element.parents().hasClass('form-group-feedback') || element.hasClass('select2-hidden-accessible')) {
                    error.appendTo( element.parent() );
                }

                // Input group, styled file input
                else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                    error.appendTo( element.parent().parent() );
                }

                // Other elements
                else {
                    error.insertAfter(element);
                }
            },
            rules: {
                identity: {
                    required: true,
                },
                password: {
                    required: true,
                }
            },
            messages: {
                identity: {
                    required: "Please Enter <?= lang('identity') ?>",
                },
                password: {
                    required: "Please Enter <?= lang('password') ?>"
                }
            },
            submitHandler: function (form) {
                form.submit();
            }
        });
    });
</script>
