<?php 
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$isSuperAdmin = session('is_super_admin');
?>
<div class="row">

    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-header d-flex align-items-center justify-content-between">
                <h5 class="mb-0"><?= isset($title) ? $title: ''; ?></h5>
            </div>
            <div class="card-body">
                <?php
                //create  form open tag
                $form_id = array(
                    'id'=>'form_user',
                );
                echo form_open_multipart('',$form_id);
                ?>
                <input type="hidden" id="id" name="id" value="<?= (isset($user['id']) && ($user['id'] != '')) ? $user['id'] : ''; ?>">
                <input type="hidden" id="user_society_id" name="user_society_id" value="<?= (isset($user['user_society_id']) && ($user['user_society_id'] != '')) ? $user['user_society_id'] : ''; ?>">

                <?php if(!isset($user['id'])) { ?>
                    <div class="row mb-3">
                        <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Auth.create_user_email_label'); ?></label>
                        <div class="col-sm-10">
                            <input type="email" class="form-control" name="email" id="email" placeholder="Enter <?= lang('Auth.create_user_email_label'); ?>" />
                        </div>
                    </div>
                <?php } ?>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Auth.create_user_fname_label'); ?></label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="first_name" id="first_name"
                               value="<?= (isset($user['first_name']) && ($user['first_name'] != '')) ? $user['first_name'] : '';  ?>"
                               placeholder="Enter <?= lang('Auth.create_user_fname_label'); ?>" />
                    </div>
                </div>


                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Auth.create_user_lname_label'); ?></label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="last_name" id="last_name"
                               value="<?= (isset($user['last_name']) && ($user['last_name'] != '')) ? $user['last_name'] : '';  ?>"
                               placeholder="Enter <?= lang('Auth.create_user_lname_label'); ?>" />
                    </div>
                </div>


                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-phone"><?= lang('Auth.edit_user_phone_label'); ?></label>
                    <div class="col-sm-10">
                        <input
                                type="text"
                                id="phone"
                                name="phone"
                                class="form-control numberInit"
                                value="<?= (isset($user['phone']) && ($user['phone'] != '')) ? $user['phone'] : '';  ?>"
                                placeholder="Enter <?= lang('Auth.edit_user_phone_label'); ?>"
                        />
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Auth.create_user_password_label'); ?></label>
                    <div class="col-sm-10">
                        <input type="password" class="form-control" name="password" id="password"
                               placeholder="Enter <?= lang('Auth.create_user_password_label'); ?>" />
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Auth.create_user_password_confirm_label'); ?></label>
                    <div class="col-sm-10">
                        <input type="password" class="form-control" name="password_confirm" id="password_confirm"
                               placeholder="Enter <?= lang('Auth.create_user_password_confirm_label'); ?>" />
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-image"><?= lang('Auth.edit_user_image_label'); ?></label>
                    <div class="col-sm-10">
                        <input type="file" accept="image/*" class="form-control" name="user_image">
                        <span class="form-text text-muted"><?= FILE_UPLOAD_TYPE_MSG; ?></span><br>
                        <?php 
                        if(isset($user['user_image']) && !empty($user['user_image'])){
                            if(file_exists(USER_IMAGE_PATH . $user['user_image'])){
                               
                                $thumbnailPaths = site_url() . THUMBNAIL_USER_IMAGE_PATH . $user['user_image'];
                                $paths = site_url() . USER_IMAGE_PATH . $user['user_image']; ?>
                                <a href="<?= $paths; ?>" target="_blank"> <img src="<?= $thumbnailPaths; ?>" width="100" class="img-fluid" alt="">  </a>      
                        <?php }} ?>
                    </div>
                </div>
                <?php if(empty($isSuperAdmin)) {?>
                    <hr class="my-2 mx-n2"/>
                    <h6><?= lang("Auth.assigned_group"); ?></h6>
                    <div class="row g-3">
                        <div class="col-md-12">
                            <?php foreach ($groups as $group){ ?>
                                <label class="checkbox">
                                    <?php
                                    $gID=$group['id'];
                                    $checked = null;
                                    $item = null;
                                    foreach($currentGroups as $grp) {
                                        if ($gID == $grp->id) {
                                            $checked= ' checked="checked"';
                                            break;
                                        }
                                    }
                                    ?>
                                    <div class='checkbox-custom checkbox-primary'>
                                        <input  type='checkbox' <?= $checked ?> name='groups[]' value='<?= $group['id'] ?>'>
                                        <label class="font-weight-bold"><?php echo htmlspecialchars($group['name'],ENT_QUOTES,'UTF-8');?>&nbsp;&nbsp;&nbsp;</label>
                                    </div>
                                </label>
                            <?php } ?>
                            <!-- <button type="button" class="btn btn-sm btn-rounded btn-primary btn-flat  getPermission">Get Permission</button> -->
                            <label id="groups[]-error" class="validation-invalid-label" for="groups[]"></label>
                        </div>
                    </div>
                <?php } else{?>

                 <hr class="my-4 mx-n4" />
                <h6><?= lang('Auth.assigned_group'); ?></h6>
                <div class="row g-3">
                    <?= isset($user_group_table) ? $user_group_table : ""; ?>
                </div>
                <?php if ($dtCIAcl->checkAccess('Auth|edit_user')) { ?>
                    <button type="button" class="btn btn-xs btn-primary" onclick="addUserGroup()">
                        <i class="ti ti-plus me-1"></i>
                        <span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
                    </button>
                <?php } }?>

                <?php /*
                <hr class="my-2 mx-n2"/>
                <h6>Search Permission</h6>
                <div class="row g-3">
                    <div class="col-md-6">
                        <input type="text" class="filter form-control"
                               placeholder="Search Access Permission"
                               autofocus="autofocus"/>
                    </div>

                </div>

                <hr class="my-2 mx-n2"/>
                <h6>Access Permissions</h6>
                <div class="row g-3">

                    <div class="col-md-12 dt-controller-name">
                        <table class="table ">
                            <thead>
                            <td>Items</td>
                            <td>Permissions</td>
                            </thead>
                            <?php
                            $permArr = unserialize(@$user['permissions);
                            if (!is_array($permArr)) {
                                $permArr = array();
                            }
                            foreach ($controllers_methods as $controller_name => $methods_arr) {
                                echo "<tr  class='controller_name'>";
                                echo "<td >" . $controller_name . "</td>";
                                echo "<td>";
                                foreach ($methods_arr as $method) {
                                    $methodDisplay = "";
                                    $methodActual = "";
                                    if (is_array($method)) {
                                        reset($method);
                                        $methodActual = key($method);
                                        $methodDisplay = $method[$methodActual];

                                    } else {
                                        $methodDisplay = $method;
                                        $methodActual = $method;
                                    }
                                    $inputName = $controller_name . "|" . $methodActual;
                                    $checked = "";
                                    if (in_array($inputName, $permArr)) {
                                        $checked = "checked";
                                    }
                                    echo "<div class='checkbox-custom checkbox-primary pull-xs-left'> <input class='per_name' type='checkbox' {$checked} name='permissions[]' value='{$inputName}'> <label>{$methodDisplay}&nbsp;&nbsp;</label> </div>";
                                    echo "<input  type='hidden'  name='permission_label[]' value='" . $inputName . "|dt|" . $controller_name . "|dt|" . $methodDisplay . "'>";

                                }
                                echo "</td>";
                                echo "<td><button type='button' class='btn btn-sm btn-success getRelativePermission'>Check All</button></td>";
                                echo "</tr>";
                            }
                            ?>
                        </table>
                    </div>
                </div> */ ?>
                <div class="pt-4">
                    <button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1">Submit</button>
                    <button type="button" id="cancelBtn" onclick="window.location.href='<?= site_url(session('is_super_admin') ? 'SuperAdmin/Auth' : 'Admin/Auth') ?>'" class="btn btn-label-secondary">Cancel</button>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>

<script>
    function userGroup() {
        addValidation("select", ".dt-society", {
            required: true,
            messages: {
                required: "<?= lang('CommonMessage.common_please_select');?> " + "<?= lang('Auth.society');?>",
            }
        });

    }
    $(document).ready(function() {
        numberInit();
        societyDd();
        groupDd();
        addSerialNumber('user_group_table');
        // Initialize
        var validator = $("#form_user").validate({
            ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
            errorClass: 'validation-invalid-label',
            successClass: 'validation-valid-label',
            validClass: 'validation-valid-label',
            highlight: function(element, errorClass) {
                $(element).removeClass(errorClass);
            },
            unhighlight: function(element, errorClass) {
                $(element).removeClass(errorClass);
            },
            success: function(label) {
                label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
            },
            // Different components require proper error label placement
            errorPlacement: function(error, element) {

                // Unstyled checkboxes, radios
                if (element.parents().hasClass('form-check')) {
                    error.appendTo( element.parents('.form-check').parent() );
                }

                // Input with icons and Select2
                else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
                    error.appendTo( element.parent() );
                }

                // Input group, styled file input
                else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                    error.appendTo( element.parent().parent() );
                }

                // Other elements
                else {
                    error.insertAfter(element);
                }
            },
            rules: {
                email: {
                    required: true,
                    email: true,
                    validEmail: true
                },
                first_name: {
                    required: true,
                    maxlength: 50
                },
                last_name: {
                    required: true,
                    maxlength: 50
                },
                phone: {
                    required: true,
                    number: true,
                    maxlength: 12
                },
                
                <?php if(!isset($user['id'])){ ?>
                password: {
                    required: true,
                    maxlength: 8
                },
                <?php } else{ ?>
                password: {
                    maxlength: 8
                },
                <?php }?>
                <?php if(!isset($user['id'])){ ?>
                password_confirm: {
                    required: true,
                    equalTo: "#password"
                }
                <?php } else { ?>
                password_confirm: {
                    equalTo: "#password"
                }
                <?php } ?>
            },
            messages: {
                email: {
                    required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Auth.create_user_validation_email_label"); ?>.'
                },
                first_name: {
                    required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Auth.create_user_validation_fname_label"); ?>',
                    maxlength: '<?= lang("CommonMessage.common_please_enter"); ?> not more than 50 Characters.'
                },
                last_name: {
                    required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Auth.create_user_validation_lname_label"); ?>',
                    maxlength: '<?= lang("CommonMessage.common_please_enter"); ?> not more than 50 Characters.'
                },
                phone: {
                    required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Auth.create_user_validation_phone_label"); ?>',
                    maxlength: '<?= lang("CommonMessage.common_please_enter"); ?> not more than 12 number.'
                },
                password: {
                    required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Auth.create_user_validation_password_label"); ?>.'
                },
                password_confirm: {
                    required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Auth.create_user_validation_password_confirm_label"); ?>',
                    equalTo: '<?= lang("Auth.confirm_password_error"); ?>'
                },
            },
            submitHandler: function (e) {
                $(e).ajaxSubmit({
                    url: '<?php echo current_url();?>',
                    type: 'post',
                    beforeSubmit: function (formData, jqForm, options) {
                        dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
                    },
                    complete: function () {

                    },
                    dataType: 'json',
                    clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    // window.location.href = '<?php echo admin_url('Auth');?>';
                                    let prefix = '<?= session('is_super_admin') ? 'SuperAdmin/Auth' : 'Admin/Auth' ?>';
                                    window.location.href = '<?= site_url() ?>' + prefix;
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Auth');?>';
							// }, 1000);

						} else {
                            dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
                });
            }
        });
        // userGroup();

        jQuery.validator.addMethod("validEmail", function(value, element, param) {
            var reg = /^([\w-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([\w-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$/;
            if(reg.test(value)){
                return true;
            }else{
                return false;
            }
        }, "<?= lang("CommonMessage.common_email_error") ?>");

        // $(document).on('click', '.getRelativePermission', function () {
        //     var tr = $(this).closest('tr');
        //     var checkBoxes = $('td input:checkbox',tr);
        //     checkBoxes.prop("checked", !checkBoxes.prop("checked"));
        // });


        // $(document).on('click', '.getPermission', function () {
        //     var permissionArray = [];

        //     $.each($("input[name='groups[]']:checkbox:checked"),function () {
        //         permissionArray.push($(this).val());
        //     });

        //     $.ajax({
        //         type: "POST",
        //         url: "<?php echo admin_url('Auth/getGroupPermission'); ?>",
        //         dataType: "json",
        //         data: {group_id: permissionArray},
        //         success: function (data) {
        //             $("input[name='permissions[]']:checkbox").attr('checked', false);
        //             $.each(data,function (index,toBeChecked) {
        //                 $("input[value='" + toBeChecked + "']").prop('checked',true);
        //             });
        //         }
        //     });
        // });

    });
</script>
<script type="text/javascript" src="<?= $assets ?>js/lookingfor.js"></script>
<script>
    $('.dt-controller-name').lookingfor({
        input: $('input.filter'),
        items: 'tr.controller_name',
        highlight: false
    });
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
