<div class="row">
    <div class="col-md-12">
        <!-- Multi Column with Form Separator -->
        <div class="card mb-4">
            <h5 class="card-header"><?= isset($title) ? $title: ''; ?></h5>
            <?php
            //create  form open tag
            $form_id = array(
                'id' => 'form_group',
                'class' => 'card-body'
            );
            echo form_open_multipart('', $form_id);
            ?>
            <input type="hidden" id="id" name="id"
                   value="<?= (isset($group->id) && ($group->id != '')) ? $group->id : ''; ?>">
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label" for="multicol-username"><?= lang("Auth.group_name"); ?></label>
                    <input type="text" id="group_name" name="group_name"
                           value="<?= (isset($group->name) && ($group->name != '')) ? $group->name : ''; ?>"
                           class="form-control" placeholder="Enter <?= lang("Auth.group_name"); ?>"/>
                </div>

                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-password"><?= lang("Auth.group_desc"); ?></label>
                        <input
                                type="text"
                                id="description"
                                name="description"
                                class="form-control"
                                value="<?= (isset($group->description) && ($group->description != '')) ? $group->description : ''; ?>"
                                placeholder="<?= lang("Auth.group_desc"); ?>"
                        />
                    </div>
                </div>
            </div>
            <hr class="my-2 mx-n2"/>
            <h6>Search Permission</h6>
            <div class="row g-3">
                <div class="col-md-6">
                    <input type="text" class="filter form-control"
                           placeholder="Search Access Permission"
                           autofocus="autofocus"/>
                </div>

            </div>
            <hr class="my-2 mx-n2"/>
            <h6>Access Permissions</h6>
            <div class="row g-3">

                <div class="col-md-12 dt-controller-name">
                    <table class="table">
                        <thead>
                        <td>Items</td>
                        <td>Permissions</td>
                        </thead>
                        <?php
                        $permArr = unserialize(@$group->permissions);
                        if (!is_array($permArr)) {
                            $permArr = array();
                        }
                        foreach ($controllers_methods as $controller_name => $methods_arr) {
                            echo "<tr class='controller_name'>";
                            echo "<td>" . $controller_name . "</td>";
                            echo "<td>";
                            foreach ($methods_arr as $method) {
                                $methodDisplay = "";
                                $methodActual = "";
                                if (is_array($method)) {
                                    reset($method);
                                    $methodActual = key($method);
                                    $methodDisplay = $method[$methodActual];

                                } else {
                                    $methodDisplay = $method;
                                    $methodActual = $method;
                                }
                                $inputName = $controller_name . "|" . $methodActual;
                                $checked = "";
                                if (in_array($inputName, $permArr)) {
                                    $checked = "checked";
                                }
                                echo "<div class='checkbox-custom checkbox-primary pull-xs-left'> <input  type='checkbox' {$checked} name='permissions[]' value='{$inputName}'> <label>{$methodDisplay}&nbsp;&nbsp;</label> </div>";
                                echo "<input  type='hidden'  name='permission_label[]' value='" . $inputName . "|dt|" . $controller_name . "|dt|" . $methodDisplay . "'>";
                            }
                            echo "</td>";
                            echo "<td><button type='button' class='btn btn-sm btn-success getRelativePermission'>Check All</button></td>";
                            echo "</tr>";
                        }
                        ?>
                    </table>
                </div>
            </div>
            <div class="pt-4">
                <button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1">Submit</button>
                <button type="button" id="cancelBtn"
                        onclick="window.location.href='<?= site_url(session('is_super_admin') ? 'SuperAdmin/manage_groups' : 'Admin/Auth/manage_groups') ?>'"
                        class="btn btn-label-secondary">Cancel
                </button>
            </div>
            <?php echo form_close(); ?>
        </div>


    </div>
</div>


<script type="text/javascript">
    $(document).ready(function () {
        $.validator.addMethod("noSpace", function (value, element) {
            return value.indexOf(" ") < 0 && value != "";
        }, "Group name cannot contain spaces.");
        // Initialize


        var validator = $("#form_group").validate({
            ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
            errorClass: 'validation-invalid-label',
            successClass: 'validation-valid-label',
            validClass: 'validation-valid-label',
            highlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            unhighlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            success: function (label) {
                //label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
            },
            // Different components require proper error label placement
            errorPlacement: function (error, element) {

                // Unstyled checkboxes, radios
                if (element.parents().hasClass('form-check')) {
                    error.appendTo(element.parents('.form-check').parent());
                }

                // Input with icons and Select2
                else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
                    error.appendTo(element.parent());
                }

                // Input group, styled file input
                else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                    error.appendTo(element.parent().parent());
                }

                // Other elements
                else {
                    error.insertAfter(element);
                }
            },
            rules: {
                group_name: {
                    required: true,
                    maxlength: 20,
                    noSpace: true,
                },
                group_description: {
                    required: true,
                    maxlength: 100
                }
            },
            messages: {
                group_name: {
                    required: "<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Auth.group_name"); ?>",
                    maxlength: "Please Enter 20 Characters Only",
                    noSpace: "Group name cannot contain spaces."
                },
                group_description: {
                    required: "<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Auth.group_desc"); ?>",
                    maxlength: "Please Enter 100 Characters Only"
                }

            },
            submitHandler: function (e) {
                $(e).ajaxSubmit({
                    url: '<?php echo current_url();?>',
                    type: 'post',
                    beforeSubmit: function (formData, jqForm, options) {
                        dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
                    },
                    complete: function () {
                    },
                    dataType: 'json',
                    clearForm: false,
                    success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    // window.location.href = '<?php echo admin_url('Auth/manage_groups');?>';
                                    let prefix = '<?= session('is_super_admin') ? 'SuperAdmin' : 'Admin/Auth' ?>';
                                    window.location.href = '<?= site_url() ?>' + prefix + '/manage_groups';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Auth/manage_groups');?>';
							// }, 1000);

						} else {
                            dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
                });
            }
        });
    });

    $(document).on('click', '.getRelativePermission', function () {
        var tr = $(this).closest('tr');
        var checkBoxes = $('td input:checkbox', tr);
        checkBoxes.prop("checked", !checkBoxes.prop("checked"));
    });
</script>
<script type="text/javascript" src="<?= $assets ?>js/lookingfor.js"></script>
<script>
    $('.dt-controller-name').lookingfor({
        input: $('input.filter'),
        items: 'tr.controller_name',
        highlight: false
    });
</script>
