<!-- Add New Amenities Modal -->
<div class="modal fade" id="amenities_modal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-simple modal-add-new-address">
        <div class="modal-content p-3 p-md-5">
            <div class="modal-body">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <div class="text-center mb-4">
                    <h3 class="address-title mb-2"><?= lang('Amenities.amenities_form')?></h3>
                </div>
                <?php
                $form_id = array(
                    'id' => 'form_amenities',
                    'method' => 'post',
                    'class' => 'row g-3',
                    'autocomplete' => 'off'
                );
                echo form_open_multipart('',$form_id);
                ?>
                <input type="hidden" name="amenities_id" id="amenities_id">
                <div class="col-12">
                    <label class="form-label" for=""><?= lang('Amenities.type'); ?><span class="text-danger"> *</span></label>
                    <?php
                        $amenitiesTypes = amenitiesType();
                    ?>
                    <select data-placeholder="Select  <?= lang('Amenities.type'); ?>" name="type" id="type"  class="select2 form-select form-select-lg dt-amenities" data-allow-clear="true">
                        
                        <?php
                        
                        foreach ($amenitiesTypes as $amenitiesKey => $amenities) { ?>
                            <option value="<?= $amenitiesKey; ?>"> <?= $amenities; ?> </option>
                        <?php } ?>
                    </select>
                </div>
                <div class="col-12">
                    <label class="form-label" for=""><?= lang('Amenities.amenities_name'); ?><span class="text-danger"> *</span></label>
                    <input type="text" id="amenities_name" name="amenities_name" class="form-control" placeholder="Enter <?= lang('Amenities.amenities_name'); ?>"/>
                </div>
                <div class="col-12">
                    <label class="form-label" for=""><?= lang('Amenities.total_quantity'); ?><span class="text-danger"> *</span></label>
                    <input type="text" id="total_quantity" name="total_quantity" class="form-control numberInit" placeholder="Enter <?= lang('Amenities.total_quantity'); ?>"/>
                </div>

                <div class="col-12">
                    <label class="form-label" for=""><?= lang('Amenities.common_area');?><span class="text-danger"> *</span></label>
                    <select data-placeholder="Select  <?= lang('Amenities.common_area'); ?>" name="common_area_id[]" id="common_area_id" class="form-control commonAreaDd" multiple>
                    </select>
                </div>

                <div class="col-12">

                    <label class="switch switch-sm">
                        <input type="checkbox" class="switch-input form-add-switchery "  name="is_active" id="is_active"/>
                        <span class="switch-toggle-slider">
                              <span class="switch-on"></span>
                              <span class="switch-off"></span>
                            </span>
                        <span class="switch-label"><?= lang('CommonMessage.common_active'); ?></span>
                    </label>
                </div>
                <div class="col-12 text-center">
                    <button type="submit" class="btn btn-primary me-sm-3 me-1"><?= lang('CommonMessage.common_submit'); ?></button>
                    <button
                            type="reset"
                            class="btn btn-label-secondary"
                            data-bs-dismiss="modal"
                            aria-label="Close">
                        <?= lang('CommonMessage.common_cancel'); ?>
                    </button>
                </div>
                <?= form_close(); ?>
            </div>
        </div>
    </div>
</div>
<!--/ Add New Address Modal -->


<!--  add,update and delete model code here-->
<script type="text/javascript">
    //var laddaSubmitBtn = Ladda.create(document.querySelector('#submit'));
    $(document).ready(function () {
        $(".dt-amenities").select2();
        numberInit();
        //validation
        var validator = $("#form_amenities").validate({
            ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
            errorClass: 'validation-invalid-label',
            successClass: 'validation-valid-label',
            validClass: 'validation-valid-label',
            highlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            unhighlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            success: function (label) {
                label.addClass('validation-valid-label'); // remove to hide Success message
            },
            // Different components require proper error label placement
            errorPlacement: function (error, element) {
                // Unstyled checkboxes, radios
                if (element.parents().hasClass('form-check')) {
                    error.appendTo(element.parents('.form-check').parent());
                }

                // Input with icons and Select2
                else if (element.parents().hasClass('form-group-feedback') || element.hasClass('select2-hidden-accessible')) {
                    error.appendTo(element.parent());
                }

                // Input group, styled file input
                else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                    error.appendTo(element.parent().parent());
                }

                // Other elements
                else {
                    error.insertAfter(element);
                }
            },
            rules: {
                amenities_name: {
                    required: true
                },
                total_quantity: {
                    required: true
                },
                type: {
                    required: true
                },
                "common_area_id[]": {
                    required: true
                },
            },
            messages: {
                amenities_name: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang("Amenities.amenities_name"); ?>",
                },
                total_quantity: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang("Amenities.total_quantity"); ?>",
                },
                type: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang("Amenities.type"); ?>",
                },
                "common_area_id[]": {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang("Amenities.common_area"); ?>",
                }
            },
            submitHandler: function (e) {
                $(e).ajaxSubmit({
                    url: '<?php echo admin_url("Amenities/addEdit");?>',
                    type: 'post',
                    beforeSubmit: function (formData, jqForm, options) {
                        //laddaStart();
                    },
                    complete: function () {
                        //laddaStop();
                    },
                    dataType: 'json',
                    clearForm: false,
                    success: function (resObj) {
                        if (resObj.success) {
                            $('#amenities_modal').modal('hide');
                            Swal.fire({
                                title: 'Success',
                                text: resObj.msg,
                                icon: 'success',
                                customClass: {
                                    confirmButton: 'btn btn-primary waves-effect waves-light'
                                },
                                buttonsStyling: false
                            }).then(function() {
                                dt_DataTable.ajax.reload();
                            });

                        } else {
                            Swal.fire({
                                title: 'Error!',
                                text: resObj.msg,
                                icon: 'error',
                                customClass: {
                                    confirmButton: 'btn btn-primary waves-effect waves-light'
                                },
                                buttonsStyling: false
                            });
                        }
                    }
                });
            }
        });
    });
</script>