<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$amenitiesView = isset($amenities_data['view']) ? $amenities_data['view'] : 0;
?>
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-header d-flex align-items-center justify-content-between">
                <h5 class="mb-0"><?= lang('Amenities.amenities_detail'); ?></h5>
            </div>
            <div class="card-body">
                <?php
                //create  form open tag
                $form_id = array(
                    'id' => 'form_amenities',
                );
                echo form_open_multipart('', $form_id);
                $amenitiesId = (isset($amenities_data['amenities_id']) && ($amenities_data['amenities_id'] != '')) ? $amenities_data['amenities_id'] : '';
                ?>
                <input type="hidden" id="amenities_id" name="amenities_id" value="<?= $amenitiesId ?>">
                <input type="hidden" id="delete_amenities_unit_id" name="delete_amenities_unit_id" value="">
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="col-form-label" for="basic-default-name"><?= lang('Amenities.amenities_name'); ?><span
                            class="text-danger"> *</span></label>
                        <input type="text" class="form-control" name="amenities_name" id="amenities_name"
                           placeholder="Enter <?= lang('Amenities.amenities_name'); ?>"
                           value="<?= (isset($amenities_data['amenities_name']) && ($amenities_data['amenities_name'] != '')) ? $amenities_data['amenities_name'] : ''; ?>"/>
                    </div>
                    <div class="col-md-4">
                        <label class="col-form-label" for="basic-default-name"><?= lang('Amenities.total_quantity'); ?><span
                            class="text-danger"> *</span></label>
                        <input type="tel" class="form-control numberInit" name="total_quantity" id="total_quantity"
                           placeholder="Enter <?= lang('Amenities.total_quantity'); ?>"
                           value="<?= (isset($amenities_data['total_quantity']) && ($amenities_data['total_quantity'] != '')) ? $amenities_data['total_quantity'] : ''; ?>"/>
                    </div>
                    <div class="col-md-4">
                        <label class="col-form-label" for="basic-default-name"><?= lang('Amenities.common_area'); ?>
                        <span class="text-danger"> *</span></label>
                        <select id="common_area_id" name="common_area_id[]" class="select2 form-select form-select-lg commonAreaDd">
                            <option></option>
                            <?php

                                if (!empty($common_area_data)) {
                                    foreach ($common_area_data as $commonArea) { ?>
                                        <option value="<?= $commonArea['common_area_id'] ?>" selected><?= $commonArea['common_area_name']; ?></option>
                                    <?php }
                                } ?>
                        </select>
                    </div>
                </div>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="col-form-label" for="basic-default-name"><?= lang('Amenities.max_advance_booking'); ?><span
                                class="text-danger"> *</span></label>
                        <div class="d-flex gap-2">
                            <div class="w-50">
                                <input type="text" class="form-control numberInit" name="max_advance_booking" id="max_advance_booking"
                                placeholder="Enter <?= lang('Amenities.max_advance_booking'); ?>" value="<?= (isset($amenities_data['max_advance_booking']) && ($amenities_data['max_advance_booking'] != '')) ? $amenities_data['max_advance_booking'] : '5'; ?>"/>
                            </div>
                            <div class="w-50">
                                <?php
                                    $dayTypes = dayType();
                                ?>
                                <select data-placeholder="Select  <?= lang('Amenities.day_type'); ?>" name="day_type"
                                        id="day_type" class="select2 form-select form-select-lg dt-day-type">
                                    <?php
                                    $selectedDayType = isset($amenities_data['day_type']) ? $amenities_data['day_type'] : "";
                                    foreach ($dayTypes as $dayKey => $dayType) { ?>
                                        <option <?= ($selectedDayType == $dayKey) ? "selected" : ""; ?>
                                            value="<?= $dayKey; ?>"> <?= $dayType; ?> </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class="col-form-label" for="basic-default-name"><?= lang('Amenities.amenities_operational_hours'); ?><span class="text-danger"> *</span></label>
                        <div class="d-flex gap-2">
                            <div class="w-50">
                                <input type="text" class="form-control dt-from-hour" name="from_hour" id="from_hour"
                               placeholder="Select <?= lang('Amenities.from_hour'); ?>"
                               value="<?= (isset($amenities_data['from_hour']) && ($amenities_data['from_hour'] != '')) ? date("h:i A",strtotime($amenities_data['from_hour'])) : ''; ?>" />
                            </div>
                            <div class="w-50">
                                <input type="text" class="form-control dt-to-hour" name="to_hour" id="to_hour" placeholder="Select <?= lang('Amenities.to_hour'); ?>" value="<?= (isset($amenities_data['to_hour']) && ($amenities_data['to_hour'] != '')) ? date("h:i A",strtotime($amenities_data['to_hour'])) : ''; ?>" />
                            </div>
                        </div>
                    </div>
                </div><br>
                
                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label"
                           for="basic-default-name"><?= lang('Amenities.short_description'); ?><span
                                class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <textarea name="short_description"  id="short_description" placeholder="Enter <?= lang('Amenities.short_description'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($amenities_data['short_description']) && ($amenities_data['short_description'] != '')) ? $amenities_data['short_description'] : ''; ?></textarea>
                    </div>
                </div>
                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label"
                           for="basic-default-name"><?= lang('Amenities.long_description'); ?><span
                             class="text-danger"> </span></label>
                    <div class="col-sm-10">
                        <textarea class="form-control long_description " name="long_description" id="long_description" rows="5" cols="5"  placeholder="Enter <?= lang('Amenities.long_description'); ?>" rows="10" cols="10"  class="form-control long_description"><?= (isset($amenities_data['long_description']) && ($amenities_data['long_description'] != '')) ? $amenities_data['long_description'] : ''; ?></textarea>
                    </div>
                </div>
                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label"
                           for="basic-default-name"><?= lang('Amenities.rules_and_regulations'); ?><span
                                class="text-danger"> </span></label>
                    <div class="col-sm-10">
                        <textarea class="form-control rules_and_regulations" name="rules_and_regulations" id="rules_and_regulations" rows="5" cols="5"  placeholder="Enter <?= lang('Amenities.rules_and_regulations'); ?>" rows="10" cols="10"  class="form-control rules_and_regulations"><?= (isset($amenities_data['rules_and_regulations']) && ($amenities_data['rules_and_regulations'] != '')) ? $amenities_data['rules_and_regulations'] : ''; ?></textarea>
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label"
                           for="basic-default-name"><?= lang('CommonMessage.common_active'); ?></label>
                    <div class="col-sm-10">
                        <label class="switch switch-sm"><span class="switch-label"></span>
                            <input type="checkbox" class="switch-input form-add-switchery" name="is_active"
                                   id="is_active" <?php echo (!isset($amenities_data['is_active']) || $amenities_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>>
                            <span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>

                        </label>
                    </div>
                </div>
                
                <hr class="my-4 mx-n4" />
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="col-form-label" for="basic-default-name"><?= lang('Amenities.booking_allowed'); ?></label> <br>
                        <label class="switch switch-sm"><span class="switch-label"></span>
                            <input type="checkbox" class="switch-input form-add-switchery" name="booking_allowed"
                                   id="booking_allowed" <?php if (isset($amenities_data['booking_allowed']) && $amenities_data['booking_allowed'] == 1) {
                                echo 'checked="checked"';
                            }else if($amenitiesId == '')  {
                                echo 'checked="checked"';
                            } else {
                                echo '';
                            } ?>/>
                            <span class="switch-toggle-slider"> <span class="switch-on"></span> <span class="switch-off"></span> </span>
                        </label>
                    </div>
                    <div class="col-md-4">
                        <label class="col-form-label" for="basic-default-name"><?= lang('Amenities.admin_approval_required'); ?></label> <br>
                        <label class="switch switch-sm"><span class="switch-label"></span>
                            <input type="checkbox" class="switch-input form-add-switchery" name="admin_approval_required"
                                   id="admin_approval_required" <?php if (isset($amenities_data['admin_approval_required']) && $amenities_data['admin_approval_required'] == 1) {
                                echo 'checked="checked"';
                            } else{
                                echo '';
                            } ?>/>
                            <span class="switch-toggle-slider"> <span class="switch-on"></span> <span class="switch-off"></span> </span>
                        </label>
                    </div>
                    <div class="col-md-4">
                        <label class="col-form-label" for="basic-default-name"><?= lang('Amenities.payment_required'); ?></label> <br>
                        <label class="switch switch-sm"><span class="switch-label"></span>
                            <input type="checkbox" class="switch-input form-add-switchery" name="payment_required"
                                   id="payment_required" <?php if (isset($amenities_data['payment_required']) && $amenities_data['payment_required'] == 1) {
                                echo 'checked="checked"';
                            } else {
                                echo '';
                            } ?>/>
                            <span class="switch-toggle-slider"><span class="switch-on"></span><span class="switch-off"></span></span>
                        </label>
                    </div>
                </div> 
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="col-form-label" for="basic-default-name"><?= lang('Amenities.max_booking_per_slot'); ?><span
                                class="text-danger"> *</span></label>
                        <input type="text" class="form-control numberInit" name="max_booking_per_slot" id="max_booking_per_slot" placeholder="Enter <?= lang('Amenities.max_booking_per_slot'); ?>" value="<?= (isset($amenities_data['max_booking_per_slot']) && ($amenities_data['max_booking_per_slot'] != '')) ? $amenities_data['max_booking_per_slot'] : ''; ?>"/>
                    </div>
                    <div class="col-md-6 cancel-before">
                        <label class="col-form-label" for="basic-default-name"><?= lang('Amenities.cancel_before'); ?><span
                                class="text-danger"> *</span></label>
                        <div class="d-flex gap-2">
                            <div class="w-50">
                                <input type="text" class="form-control numberInit" name="cancel_before" id="cancel_before"
                               placeholder="Enter <?= lang('Amenities.cancel_before'); ?>"
                               value="<?= (isset($amenities_data['cancel_before'])) ? $amenities_data['cancel_before'] : ''; ?>"/>
                            </div>
                            <div class="w-50">
                                <?php
                                $timeTypes = timeType();
                                ?>
                                <select data-placeholder="Select  <?= lang('Amenities.cancel_before_type'); ?>" name="cancel_before_type"
                                        id="cancel_before_type" class="select2 form-select form-select-lg dt-cancel-before-type">
                                    <?php
                                    $selectedTimeType = isset($amenities_data['cancel_before_type']) ? $amenities_data['cancel_before_type'] : "";
                                    foreach ($timeTypes as $timeKey => $timeType) { ?>
                                        <option <?= ($selectedTimeType == $timeKey) ? "selected" : ""; ?>
                                            value="<?= $timeKey; ?>"> <?= $timeType; ?> </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="row g-3">
                    
                    <div class="col-md-6 pay-before">
                        <label class="col-form-label" for="basic-default-name"><?= lang('Amenities.pay_before'); ?><span
                                class="text-danger"> *</span></label>
                        <div class="d-flex gap-2">
                            <div class="w-50">
                                <input type="text" class="form-control numberInit" name="pay_before" id="pay_before"
                               placeholder="Enter <?= lang('Amenities.pay_before'); ?>"
                               value="<?= (isset($amenities_data['pay_before']) && ($amenities_data['pay_before'] != 0)) ? $amenities_data['pay_before'] : ''; ?>"/>
                            </div>
                            <div class="w-50">
                                <?php
                                $timeTypes = timeType();
                                ?>
                                <select data-placeholder="Select  <?= lang('Amenities.pay_before_type'); ?>" name="pay_before_type"
                                        id="pay_before_type" class="select2 form-select form-select-lg dt-pay-before-type">
                                    <?php
                                    $selectedTimeType = isset($amenities_data['pay_before_type']) ? $amenities_data['pay_before_type'] : "";
                                    foreach ($timeTypes as $timeKey => $timeType) { ?>
                                        <option <?= ($selectedTimeType == $timeKey) ? "selected" : ""; ?>
                                            value="<?= $timeKey; ?>"> <?= $timeType; ?> </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 tax">
                        <label class="col-form-label" for="basic-default-name"><?= lang('Amenities.tax'); ?>
                        <span class="text-danger"> *</span></label>
                        <select id="tax_id" name="tax_id" class="select2 form-select form-select-lg taxDd" data-allow-clear="true">
                                <option></option>
                                <?php if(isset($amenities_data['tax_id']) && $amenities_data['tax_id'] != 0){ ?>
                                     <option value="<?= isset($amenities_data['tax_id']) ? $amenities_data['tax_id'] : 0 ?>" selected> <?= isset($amenities_data['tax_name']) ? $amenities_data['tax_name'] : ''  ?> </option>
                                <?php } ?>
                            </select>
                    </div>
                </div>

                <hr class="my-4 mx-n4" />
                <h6>2. <?= lang('Amenities.contact_person_detail'); ?></h6>
				<div class="row g-3">
					<div class="col-md-6">
						<label class="form-label" for="basic-default-name"><?= lang('Amenities.contact_person_name');?><span class="text-danger"> *</span></label>
						<input type="text" class="form-control" name="contact_person_name" id="contact_person_name" placeholder="Enter <?= lang('Amenities.contact_person_name');?>" value="<?= isset($amenities_data['contact_person_name']) ? $amenities_data['contact_person_name'] : ""; ?>" />
					</div>
					<div class="col-md-6">
						<label class="form-label" for="basic-default-name"><?= lang('Amenities.contact_phone_number');?><span class="text-danger"> *</span></label>
						<input type="text" class="form-control numberInit" name="contact_phone_number" id="contact_phone_number" placeholder="Enter <?= lang('Amenities.contact_phone_number');?>" value="<?= isset($amenities_data['contact_phone_number']) ? $amenities_data['contact_phone_number'] : ""; ?>" />
					</div>
				</div>
                
                <hr class="my-4 mx-n4" />
                <h6>3. <?= lang('Amenities.unit_information'); ?></h6>
                <div class="row g-3">
                    <?= isset($amenities_unit_table) ? $amenities_unit_table : ""; ?>
                </div>
                <?php if ($dtCIAcl->checkAccess('Amenities|manage')) { ?>
                    <button type="button" class="btn btn-xs btn-primary" onclick="addAmenitiesUnit()">
                        <i class="ti ti-plus me-1"></i>
                        <span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
                    </button>
                <?php } ?>

                <hr class="my-4 mx-n4" />
                <h6>4. <?= lang('Amenities.booking_slot_information'); ?></h6>
                <div class="row g-3">
                    <?= isset($amenities_booking_slot_table) ? $amenities_booking_slot_table : ""; ?>
                </div>
                <?php if ($dtCIAcl->checkAccess('Amenities|manage')) { ?>
                    <button type="button" class="btn btn-xs btn-primary" onclick="addAmenitiesBookingSlot()">
                        <i class="ti ti-plus me-1"></i>
                        <span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
                    </button>
                <?php } ?>
                <?php if($amenitiesView != 1) { ?>
                    <div class="pt-4">
                        <button type="submit" id="submitBtn"
                                class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
                        <button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Amenities'); ?>'"
                                class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
                    </div>
                <?php } ?>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>

<script>
    var editable = <?= $amenitiesView ?>;
    if(editable == 1)
    {
        $("#form_amenities :input").prop("disabled", true);
        // $('#rules_and_regulations').ckEditorInit().setReadOnly();
        // $('#long_description').ckeditorGet().setReadOnly();
        $(".dt-delete-item-row").removeAttr("onclick");
        $(".dt-delete-item-row").remove();
        $(".dt-delete-unit-row").removeAttr("onclick");
        $(".dt-delete-unit-row").remove();
    }

    function amenitiesUnit() {
        addValidation("input", ".dt-unit-name", {
            required: true,
            messages: {
                required: "<?= lang('CommonMessage.common_please_enter');?> " + "<?= lang('Amenities.unit_name');?>",
            }
        });
    }

    function amenitiesBookingSlot() {
        addValidation("input", ".dt-start-time", {
            required: true,
            messages: {
                required: "<?= lang('CommonMessage.common_please_select');?> " + "<?= lang('Amenities.start_time');?>",
            }
        });
        addValidation("input", ".dt-end-time", {
            required: true,
            messages: {
                required: "<?= lang('CommonMessage.common_please_select');?> " + "<?= lang('Amenities.end_time');?>",
            }
        });
        addValidation("input", ".dt-hour", {
            required: true,
            messages: {
                required: "<?= lang('CommonMessage.common_please_select');?> " + "<?= lang('Amenities.hour');?>",
            }
        });
        addValidation("input", ".dt-minutes", {
            required: true,
            messages: {
                required: "<?= lang('CommonMessage.common_please_select');?> " + "<?= lang('Amenities.minutes');?>",
            }
        });
        addValidation("select", ".dt-day", {
            required: true,
            messages: {
                required: "<?= lang('CommonMessage.common_please_select');?> " + "<?= lang('Amenities.day');?>",
            }
        });
    }

    $('#from_hour').timepicker({ 'timeFormat': 'h:i A','scrollDefault': 'now','ampm': true  });
    $('#to_hour').timepicker({ 'timeFormat': 'h:i A','scrollDefault': 'now','ampm': true   });

    function startTime() {
        $('.dt-start-time').timepicker({ 'timeFormat': 'h:i A','scrollDefault': 'now', 'step': '15','ampm': true });
        }
    function endTime() {
        $('.dt-end-time').timepicker({ 'timeFormat': 'h:i A','scrollDefault': 'now', 'step': '15','ampm': true  });
        }
    // function hour() {
    //     $('.dt-hour').timepicker({ 'timeFormat': 'h','scrollDefault': 'now'  });
    //     }
    // function minutes() {
    //     $('.dt-minutes').timepicker({ 'timeFormat': 'i','scrollDefault': 'now', 'step': '5','ampm': true  });
    // }

    function minutes() {
        $('.dt-minutes').each(function() {
            $(this).timepicker({
                timeFormat: 'i',  // Display minutes only
                step: 5,          // Increment by 5 minutes
                minTime: '00:00', // Start at 00 minutes
                maxTime: '00:55', // End at 55 minutes
                scrollbar: true   // Allows scrolling selection
            });
        });
    }


    $(document).ready(function () {
        commonAreaDd();
        taxDd();
        numberInit();
        switcheryKeyGen("datatable-list-switchery");
        var  paymentRequired = $("#payment_required").prop('checked');
        if(paymentRequired == true){
            $(".dt-unit-price-modal-show").show();
            $(".cancel-before").show();
            // $(".dt-cancel-before-type").show();
            $(".pay-before").show();
            // $(".dt-pay-before-type").show();
            $(".tax").show();
        }
        else {
            $(".dt-unit-price-modal-show").hide();
            $(".cancel-before").hide();
            // $(".dt-cancel-before-type").hide();
            $(".pay-before").hide();
            // $(".dt-pay-before-type").hide();
            $(".tax").hide();
        }

        $(".dt-amenities").select2();
        $(".dt-day-type").select2();
        $(".dt-day").select2();
        $(".dt-cancel-before-type").select2();
        $(".dt-pay-before-type").select2();

        addSerialNumber('amenities_unit_table');
        addSerialNumber('amenities_booking_slot_table');
        addSerialNumber('amenities_booking_slot_unit_payment_table');

        ckEditorInit('long_description');
        ckEditorInit('rules_and_regulations');

        numberInit();
        startTime();
        endTime();
        // hour();
        minutes();

        // Initialize
        var validator = $("#form_amenities").validate({
            ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
            errorClass: 'validation-invalid-label',
            successClass: 'validation-valid-label',
            validClass: 'validation-valid-label',
            highlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            unhighlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            success: function (label) {
                label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
            },
            // Different components require proper error label placement
            errorPlacement: function (error, element) {

                // Unstyled checkboxes, radios
                if (element.parents().hasClass('form-check')) {
                    error.appendTo(element.parents('.form-check').parent());
                }

                // Input with icons and Select2
                else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
                    error.appendTo(element.parent());
                }

                // Input group, styled file input
                else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                    error.appendTo(element.parent().parent());
                }

                // Other elements
                else {
                    error.insertAfter(element);
                }
            },
            rules: {
                amenities_name: {
                    required: true
                },
                short_description: {
                    required: true
                },
                // type: {
                //     required: true
                // },
                contact_person_name : {
					required: true,
				},
				contact_phone_number: {
					required: true,
					number: true,
					minlength: 10,
					maxlength: 10,
				},
                max_advance_booking: {
                    required: true
                },
                day_type: {
                    required: true
                },
                from_hour: {
                    required: true
                },
                to_hour: {
                    required: true
                },
                max_booking_per_slot: {
                    required: true
                },
                total_quantity: {
                    required: true
                },
                cancel_before: {
                    required: "#cancel_before:visible"
                },
                cancel_before_type: {
                    required: "#cancel_before_type:visible"
                },
                pay_before: {
                    required: "#pay_before:visible"
                },
                pay_before_type: {
                    required: "#pay_before_type:visible"
                },
                tax_id: {
                    required: "#tax_id:visible"
                },
                "common_area_id[]": {
                    required: true
                },
            },
            messages: {
                amenities_name: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Amenities.amenities_name');?>"
                },
                short_description: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Amenities.short_description');?>"
                },
                // type: {
                //     required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Amenities.type');?>"
                // },
                contact_person_name: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Amenities.contact_person_name"); ?>',
				},
				contact_phone_number: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Amenities.contact_phone_number"); ?>',
				},
                total_quantity: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Amenities.total_quantity');?>"
                },
                max_advance_booking: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Amenities.max_advance_booking');?>"
                },
                day_type: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Amenities.day_type');?>"
                },
                from_hour: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Amenities.from_hour');?>"
                },
                to_hour: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Amenities.to_hour');?>"
                },
                max_booking_per_slot: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Amenities.max_booking_per_slot');?>"
                },
                cancel_before: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Amenities.cancel_before');?>"
                },
                cancel_before_type: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Amenities.cancel_before_type');?>"
                },
                pay_before: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Amenities.pay_before');?>"
                },
                pay_before_type: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Amenities.pay_before_type');?>"
                },
                tax_id: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Amenities.tax');?>"
                },
                "common_area_id[]": {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Amenities.common_area');?>"
                },
            },
            submitHandler: function (e) {

               // $("#long_description").val($("#full-editor").html());

                $(e).ajaxSubmit({
                    url: '<?php echo admin_url("Amenities/save");?>',
                    type: 'post',
                    beforeSubmit: function (formData, jqForm, options) {
                        dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
                    },
                    complete: function () {

                    },
                    dataType: 'json',
                    clearForm: false,
                    success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Amenities');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Amenities');?>';
							// }, 1000);

						} else {
                            dtButtonShow('#submitBtn');
                            dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
                });
            }
        });
        amenitiesUnit();
        amenitiesBookingSlot();

    });

    function unitPriceStore(){


        var  paymentRequired = $("#payment_required").prop('checked');
        if(paymentRequired == true){
            var unitNameArray = [];
            var unitArray = [];
            $("table#amenities_unit_table .amenities_unit_id").each(function (index) {
                var objectOfThisRow = {};
                var unitTr = $(this).closest('tr');
                var unitName = unitTr.find(".dt-unit-name").val() || '';
                objectOfThisRow["unit_name"] = unitName;
                objectOfThisRow["unit_price"] = 0;
                unitArray.push(objectOfThisRow);
                unitNameArray.push(unitName);
            });
            //$(".dt-unit-payment-json").val(JSON.stringify(unitArray));

            // console.log('ssdsd',unitNameArray);

            $("table#amenities_booking_slot_table .amenities_booking_slot_id").each(function (index) {
                var trField = $(this).closest('tr');
                var unitPriceJson = trField.find(".dt-unit-price-json").val() || '';
                var unitPriceArray = [];
                var unitPriceJsonArray = [];
                var alreadyAddedJsonArray = [];

                var alreadyAddedJsonObject = {};
                if(unitPriceJson != '' && unitPriceJson != '[]') {
                    unitPriceJsonArray = JSON.parse(unitPriceJson);
                    $.each( unitPriceJsonArray, function( key, value ) {
                        alreadyAddedJsonArray.push(value.unit_name);
                        alreadyAddedJsonObject[value.unit_name] = value.unit_price;
                    });
                }

                $.each( unitNameArray,function( key, value ) {
                    var objectOfThisRow = {};
                    if(jQuery.inArray(value, alreadyAddedJsonArray) != -1){
                        objectOfThisRow["unit_name"] = value;
                        objectOfThisRow["unit_price"] = alreadyAddedJsonObject[value];
                    } else {
                        objectOfThisRow["unit_name"] = value;
                        objectOfThisRow["unit_price"] = 0;
                    }
                    unitPriceArray.push(objectOfThisRow);
                });
                trField.find(".dt-unit-price-json").val(JSON.stringify(unitPriceArray));
            });
        }
    }

    $(document).on('change', '#payment_required', function () {
        var paymentRequired = (this.checked ? 1 : 0);
        if(paymentRequired == true){
            $(".dt-unit-price-modal-show").show();
            $(".cancel-before").show();
            // $(".dt-cancel-before-type").show();
            $(".pay-before").show();
            // $(".dt-pay-before-type").show();
            $(".tax").show();
        }
        else {
            $(".dt-unit-price-modal-show").hide();
            $(".cancel-before").hide();
            // $(".dt-cancel-before-type").hide();
            $(".pay-before").hide();
            // $(".dt-pay-before-type").hide();
            $(".tax").hide();
        }
        unitPriceStore();
    });
    $(document).on('focusout', '.dt-unit-name', function () {
        unitPriceStore();
    });

</script>

<?php //isset($payment_modal_view) ? $payment_modal_view : ""; ?>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
