<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#amc_detail" aria-controls="amc_detail" aria-selected="true">
			<?= lang('AMC.amc_detail'); ?>
		</button>
	</li>
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="amc_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="amc_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("AMC.financial_year"); ?></td>
						<td><?php
							echo (isset($amc_data['financial_year_prefix']) && $amc_data['financial_year_prefix'] != "") ? $amc_data['financial_year_prefix'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("AMC.amc_type"); ?></td>
						<td><?php
							echo (isset($amc_data['amc_type']) && $amc_data['amc_type'] != "") ? underscoreToUcWord($amc_data['amc_type']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("AMC.particular"); ?></td>
						<td><?php
							echo (isset($amc_data['particular']) && $amc_data['particular'] != "") ? $amc_data['particular'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("AMC.company_person"); ?></td>
						<td><?php
							echo (isset($amc_data['vendor_name']) && $amc_data['vendor_name'] != "") ? $amc_data['vendor_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("AMC.period_from"); ?></td>
						<td><?php
							echo (isset($amc_data['period_from']) && $amc_data['period_from'] != "") ? siteDateFormat($amc_data['period_from']) : '-';
							?></td>
					</tr>
					<tr>
						<td><?= lang("AMC.period_to"); ?></td>
						<td><?php
							echo (isset($amc_data['period_upto']) && $amc_data['period_upto'] != "") ? siteDateFormat($amc_data['period_upto']) : '-';
							?></td>
					</tr>
					<tr>
						<td><?= lang("AMC.amount"); ?></td>
						<td><?php
							echo (isset($amc_data['amount']) && $amc_data['amount'] != "") ? indianMoneyFormat($amc_data['amount'],2,0) : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("AMC.facilities"); ?></td>
						<td><?php
							echo (isset($amc_data['amenities_name']) && $amc_data['amenities_name'] != "") ? underscoreToUcWord($amc_data['amenities_name']) : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("AMC.place"); ?></td>
						<td><?php
							echo (isset($amc_data['place']) && $amc_data['place'] != "") ? ($amc_data['place']) : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($amc_data['created_at']) && isValidDate($amc_data['created_at'])) ? siteDateFormat($amc_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($amc_data['created_by']) && $amc_data['created_by'] != "") ? $amc_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($amc_data['updated_at']) && isValidDate($amc_data['updated_at'])) ? siteDateFormat($amc_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($amc_data['updated_by']) && $amc_data['updated_by'] != "") ? $amc_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
</div>