<?php
namespace App\Services;

use Config\Database;

class DatabaseService
{
    private $centralDB;
    private $tenantDB;

    public function __construct()
    {
        $this->centralDB = Database::connect();
    }

    /**
     * Get the tenant database connection
     * 
     * @param string $societyId The society ID for the tenant
     * @return \CodeIgniter\Database\ConnectionInterface The tenant database connection
     */
    public function getTenantConnection($societyId)
    {
        if ($societyId) {
            $masterDb = Database::connect('default');

            $row = $masterDb
                ->table('tbl_society')
                ->where('society_id', $societyId)
                ->get()
                ->getRowArray();

            if (!$societyId) {
                throw new \RuntimeException("Society not found for ID: $societyId");
            }

            // Build tenant DB config dynamically
            $config = [
                'DSN'      => '',
             
                'hostname' => DB_HOST,
                'username' => DB_USER,
                'password' => DB_PASS,
                'database' => $row['db_name'] ?? '',
                'DBDriver' => 'MySQLi',
                'DBPrefix' => '',
                'pConnect' => false,
                'DBDebug'  => (ENVIRONMENT !== 'production'),
                'charset'  => 'utf8mb4',
                'DBCollat' => 'utf8mb4_general_ci',
            ];
            $this->tenantDB = Database::connect($config);
        } else {
            $this->tenantDB = $this->centralDB;
        }

        return $this->tenantDB;
    }
}
