<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class WaterTankModel extends BaseModel
{
	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}

	public function getWaterTankData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_water_tank as twt');
        $builder->select("twt.*");
        if((isset($filterData['is_api'])) && $filterData['is_api'] == 1){
            $builder->select("twmr.availability_volume");
            $builder->join("(SELECT water_tank_id, MAX(reading_date_time) as latest_reading FROM tbl_water_meter_reading Where water_meter_reading_id != '". $filterData['water_meter_reading_id'] ."'  GROUP BY water_tank_id) as latest", 'latest.water_tank_id = twt.water_tank_id', 'left');      
            $builder->join('tbl_water_meter_reading as twmr',"twmr.water_tank_id = twt.water_tank_id  AND twmr.reading_date_time = latest.latest_reading", 'left');
        }
        if(isset($filterData['water_tank_id']) && !empty($filterData['water_tank_id'])) {
            if (is_array($filterData['water_tank_id'])) {
                $builder->whereIn('twt.water_tank_id', $filterData['water_tank_id']);
            } else {
                $builder->where('twt.water_tank_id', $filterData['water_tank_id']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('twt.society_id', $filterData['society_id']);
            } else {
                $builder->where('twt.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('twt.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('water_tank_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }
        $builder->groupBy('twt.water_tank_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
	

	public function deleteRecord($waterTankId)
    {
        $builder = $this->db->table('tbl_water_tank');
        $waterTankIdArray = is_array($waterTankId) ? $waterTankId : array($waterTankId);
        $builder->whereIn('water_tank_id', $waterTankIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($waterTankId)){
                foreach($waterTankId as $waterTank){
                    $deleteDataArray['module'] = 'Parking Place';
                    $deleteDataArray['activity'] = "Parking Place Deleted";
                    $deleteDataArray['module_id'] = $waterTank;
                    logActivity('Parking Place Deleted [WaterTankID: ' . $waterTank . ']',$this->ionAuth->getUserId(),'Parking Place',$waterTank,json_encode($deleteDataArray),'','Parking Place',$waterTank);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

	function getWaterTank($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_water_tank as twt');
        //$builder->startCache();
        $builder->select("twt.water_tank_id as id,COALESCE(twt.water_tank_name,'') as text,twt.society_id,ts.society_name");
        $builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = twt.society_id","left");

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('twt.society_id', $filterData['society_id']);
            } else {
                $builder->where('twt.society_id', $filterData['society_id']);
            }
        }

        if (isset($filterData['water_tank_id']) && !empty($filterData['water_tank_id'])) {
            if (is_array($filterData['water_tank_id'])) {
                $builder->whereIn('twt.water_tank_id', $filterData['water_tank_id']);
            } else {
                $builder->where('twt.water_tank_id', $filterData['water_tank_id']);
            }
        }
        accessFilter($builder, array("society" => "twt.society_id"));
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(twt.water_tank_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('twt.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }
}
?>
