<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class VisitorCompanyModel extends BaseModel
{
    public function getVisitorCompanyData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_visitor_company as tvc');
        $builder->select("tvc.*");
        accessFilter($builder, array("society" => "tvc.society_id"));
        if (isset($filterData['visitor_company_id']) && !empty($filterData['visitor_company_id'])) {
            if (is_array($filterData['visitor_company_id'])) {
                $builder->whereIn('tvc.visitor_company_id', $filterData['visitor_company_id']);
            } else {
                $builder->where('tvc.visitor_company_id', $filterData['visitor_company_id']);
            }
        }
        if (isset($filterData['visitor_company_type']) && !empty($filterData['visitor_company_type'])) {
            if (is_array($filterData['visitor_company_type'])) {
                $builder->whereIn('tvc.visitor_company_type', $filterData['visitor_company_type']);
            } else {
                $builder->where('tvc.visitor_company_type', $filterData['visitor_company_type']);
            }
        }
        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('tvc.is_active', $filterData['is_active']);
        }
        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }
        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('visitor_company_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }
        $builder->groupBy('tvc.visitor_company_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($visitorCompanyId)
    {
        $builder = $this->db->table('tbl_visitor_company');
        $visitorCompanyIdArray = is_array($visitorCompanyId) ? $visitorCompanyId : array($visitorCompanyId);
        $builder->whereIn('visitor_company_id', $visitorCompanyIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($visitorCompanyId)){
                foreach($visitorCompanyId as $visitorCompany){
                    $deleteDataArray['module'] = 'Visitor Company';
                    $deleteDataArray['activity'] = "Visitor Company Deleted";
                    $deleteDataArray['module_id'] = $visitorCompany;
                    logActivity('Visitor Company Deleted [VisitorCompanyID: ' . $visitorCompany . ']',$this->ionAuth->getUserId(),'Visitor Company',$visitorCompany,json_encode($deleteDataArray),'','Visitor Company',$visitorCompany);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
    function getVisitorCompany($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }
        $builder = $this->db->table('tbl_visitor_company as tvc');
        $builder->select("tvc.visitor_company_id as id,COALESCE(tvc.visitor_company_name,'') as text");
        if (isset($filterData['visitor_company_id']) && !empty($filterData['visitor_company_id'])) {
            if (is_array($filterData['visitor_company_id'])) {
                $builder->whereIn('tvc.visitor_company_id', $filterData['visitor_company_id']);
            } else {
                $builder->where('tvc.visitor_company_id', $filterData['visitor_company_id']);
            }
        }
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tvc.visitor_company_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tvc.is_active', $filterData['is_active']);
        }
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    public function checkVisitorCompanyNameExist($filterData = array())
    {

        $builder = $this->db->table('tbl_visitor_company as tvc');
        $builder->select("tvc.*");

        if(isset($filterData['visitor_company_id']) && !empty($filterData['visitor_company_id'])) {
            if (is_array($filterData['visitor_company_id'])) {
                $builder->whereNotIn('tvc.visitor_company_id', $filterData['visitor_company_id']);
            } else {
                $builder->where('tvc.visitor_company_id !=', $filterData['visitor_company_id']);
            }
        }
        if(isset($filterData['visitor_company_type']) && !empty($filterData['visitor_company_type'])) {
            if (is_array($filterData['visitor_company_type'])) {
                $builder->whereIn('tvc.visitor_company_type', $filterData['visitor_company_type']);
            } else {
                $builder->where('tvc.visitor_company_type', $filterData['visitor_company_type']);
            }
        }
        if(isset($filterData['visitor_company_name']) && !empty($filterData['visitor_company_name'])) {
            if (is_array($filterData['visitor_company_name'])) {
                $builder->whereIn('tvc.visitor_company_name', $filterData['visitor_company_name']);
            } else {
                $builder->where('tvc.visitor_company_name', $filterData['visitor_company_name']);
            }
        }
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
}