<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class VendorModel extends BaseModel
{
	public function getVendorData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_vendor as tv');
        $builder->select("tv.*");
		$builder->select("COALESCE(ts.society_name,'') as society_name");
		$builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
		$builder->select("GROUP_CONCAT(distinct(tvm.vendor_mobile_no) SEPARATOR ',') as vendor_mobile_no");
		$builder->select("GROUP_CONCAT(distinct(tvm.vendor_person_name) SEPARATOR ',') as vendor_person_name");
		$builder->select("GROUP_CONCAT(distinct(tvm.vendor_designation) SEPARATOR ',') as vendor_designation");
		$builder->select("GROUP_CONCAT(distinct(tc.category_name) SEPARATOR ',') as vendor_category_name,GROUP_CONCAT(distinct(tc.category_id) SEPARATOR ',') as vendor_category_id");
		$builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tv.society_id","left");
		$builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tv.updated_by AND tupdate.society_id = tv.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tv.created_by AND tcreate.society_id = tv.society_id","left");
		$builder->join("tbl_vendor_mobile as tvm","tvm.vendor_id = tv.vendor_id","left");
		$builder->join("tbl_vendor_category as tvc","tvc.vendor_id = tv.vendor_id","left");
		$builder->join("tbl_category as tc","tc.category_id = tvc.category_id","left");

		if (isset($filterData['vendor_id']) && !empty($filterData['vendor_id'])) {
			if (is_array($filterData['vendor_id'])) {
				$builder->whereIn('tv.vendor_id', $filterData['vendor_id']);
			} else {
				$builder->where('tv.vendor_id', $filterData['vendor_id']);
			}
		}
		if (isset($filterData['category_id']) && !empty($filterData['category_id'])) {
			if (is_array($filterData['category_id'])) {
				$builder->whereIn('tc.category_id', $filterData['category_id']);
			} else {
				$builder->where('tc.category_id', $filterData['category_id']);
			}
		}
		if (isset($filterData['start'])) {
			if ($filterData['start'] != '-1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('tv.vendor_name', $filterData['search'], 'both');
			$builder->orLike('tv.agency', $filterData['search'], 'both');
			$builder->orLike('tc.category_name', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('tv.is_active', $filterData['is_active']);
		}
		if(isset($filterData['is_active']))

		if(isset($filterData['is_api'])){
			accessFilter($builder, array("society" => "tv.society_id"),1,array("society_id" => isset($filterData['society_id']) ? $filterData['society_id'] : 0));
		} else  {
			accessFilter($builder, array("society" => "tv.society_id"));
		}
		$builder->groupBy('tv.vendor_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function deleteRecord($vendorId)
	{
		$builder = $this->db->table('tbl_vendor_mobile');
        $builder->whereIn('vendor_id', $vendorId);
        $builder->delete();
        $builder = $this->db->table('tbl_vendor_category');
        $builder->whereIn('vendor_id', $vendorId);
        $builder->delete();
        $builder = $this->db->table('tbl_vendor');
        $builder->whereIn('vendor_id', $vendorId);
        $builder->delete();
		$ids = is_array($vendorId) ? implode(',',$vendorId) : $vendorId;
		if ($this->db->affectedRows()) {
			if(!empty($vendorId)){
				foreach($vendorId as $documentElement){
					$deleteDataArray['module'] = 'Vendor';
					$deleteDataArray['activity'] = "Vendor Deleted";
					$deleteDataArray['module_id'] = $documentElement;
					logActivity('Vendor Deleted [VendorID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Vendor',$documentElement,json_encode($deleteDataArray),'','Vendor',$documentElement);
				}
			}
			return true;
		}
		return false;
	}
	public function getVendorMobileData($filterData)
	{
		$builder = $this->db->table('tbl_vendor_mobile as tvm');
		$builder->select("tvm.*");
		

		if(isset($filterData['vendor_id']) && !empty($filterData['vendor_id'])) {
			if (is_array($filterData['vendor_id'])) {
				$builder->whereIn('tvm.vendor_id', $filterData['vendor_id']);
			} else {
				$builder->where('tvm.vendor_id', $filterData['vendor_id']);
			}
		}

		if(isset($filterData['vendor_mobile_id']) && !empty($filterData['vendor_mobile_id'])) {
			if (is_array($filterData['vendor_mobile_id'])) {
				$builder->whereIn('tvm.vendor_mobile_id', $filterData['vendor_mobile_id']);
			} else {
				$builder->where('tvm.vendor_mobile_id', $filterData['vendor_mobile_id']);
			}
		}

		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();

			$builder->groupEnd();
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

	public function getVendorCategoryData($filterData)
	{
		$builder = $this->db->table('tbl_vendor_category as tvc');
		$builder->select("tvc.*,tc.category_name");
		$builder->join("tbl_category as tc","tc.category_id = tvc.category_id","left");

		if(isset($filterData['vendor_id']) && !empty($filterData['vendor_id'])) {
			if (is_array($filterData['vendor_id'])) {
				$builder->whereIn('tvc.vendor_id', $filterData['vendor_id']);
			} else {
				$builder->where('tvc.vendor_id', $filterData['vendor_id']);
			}
		}

		if(isset($filterData['vendor_category_id']) && !empty($filterData['vendor_category_id'])) {
			if (is_array($filterData['vendor_category_id'])) {
				$builder->whereIn('tvc.vendor_category_id', $filterData['vendor_category_id']);
			} else {
				$builder->where('tvc.vendor_category_id', $filterData['vendor_category_id']);
			}
		}

		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();

			$builder->groupEnd();
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

	public function deleteVendorMobileRecord($vendorMobileId,$vendorId = '')
	{
		$builder = $this->db->table('tbl_vendor_mobile');
        $vendorMobileIdArray = is_array($vendorMobileId) ? $vendorMobileId : array($vendorMobileId);
        $builder->whereIn('vendor_mobile_id', $vendorMobileIdArray);
        $builder->delete();

		$ids = is_array($vendorMobileId) ? implode(',',$vendorMobileId) : $vendorMobileId;
		
		if ($this->db->affectedRows()) {

			if(!empty($vendorMobileId)){
				foreach($vendorMobileId as $documentElement){
					$deleteDataArray['module'] = 'Vendor Mobile No';
					$deleteDataArray['activity'] = "Vendor Mobile No Deleted";
					$deleteDataArray['module_id'] = $documentElement;
					logActivity('Vendor Mobile No Deleted [VendorMobileID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Vendor Mobile No',$documentElement,json_encode($deleteDataArray),'','Vendor',$vendorId);
				}
			}
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}

	}

	public function deleteCategoryRecord($vendorId){

		$builder = $this->db->table('tbl_vendor_category');
        $vendorIdArray = is_array($vendorId) ? $vendorId : array($vendorId);
        $builder->whereIn('vendor_id', $vendorIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
	function getVendor($filterData = array())
	{
		if(isset($filterData['page']) && $filterData['page'] != 1) {
			$filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
		}

		$builder = $this->db->table('tbl_vendor as tv');
		$builder->select("tv.vendor_id as id,tv.vendor_name as text");

		if(isset($filterData['is_active'])){
			$builder->where('tv.is_active', $filterData['is_active']);
		}

		if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
			$builder->groupStart();
			$builder->like("tv.vendor_name", $filterData['filter_param'], 'both');
			$builder->groupEnd();
		}
		accessFilter($builder, array("society" => "tv.society_id"));

		$totalRows = $builder->countAllResults(false);
		$builder->limit($filterData['limit'], $filterData['start']);
		$query = $builder->get();
		$result['result'] = $query->getResultArray();
		$result['totalRows'] = $totalRows;
		$result['page'] = $filterData['page'];
		return json_encode($result);
	}

}
?>
