<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class TimeSlotModel extends BaseModel
{
	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}

	public function getTimeSlotData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_time_slot as tts');
        $builder->select("tts.*");

		if(isset($filterData['time_slot_id']) && !empty($filterData['time_slot_id'])) {
			if (is_array($filterData['time_slot_id'])) {
				$builder->whereIn('tts.time_slot_id', $filterData['time_slot_id']);
			} else {
				$builder->where('tts.time_slot_id', $filterData['time_slot_id']);
			}
		}

		if(isset($filterData['time_slot_id_not']) && !empty($filterData['time_slot_id_not'])) {
			if (is_array($filterData['time_slot_id_not'])) {
				$builder->whereNotIn('tts.time_slot_id', $filterData['time_slot_id_not']);
			} else {
				$builder->where('tts.time_slot_id != ', $filterData['time_slot_id_not']);
			}
		}

		if(isset($filterData['time_slot_name']) && !empty($filterData['time_slot_name'])) {
			if (is_array($filterData['time_slot_name'])) {
				$builder->whereIn('tts.time_slot_name', $filterData['time_slot_name']);
			} else {
				$builder->where('tts.time_slot_name', $filterData['time_slot_name']);
			}
		}

		if(isset($filterData['start_time']) && !empty($filterData['start_time'])) {
			if (is_array($filterData['start_time'])) {
				$builder->whereIn('tts.start_time', $filterData['start_time']);
			} else {
				$builder->where('tts.start_time', $filterData['start_time']);
			}
		}

		if(isset($filterData['start_time']) && !empty($filterData['start_time'])) {
			$builder->where('tts.start_time <', $filterData['start_time']);
			$builder->where('tts.end_time >', $filterData['start_time']);
		}

		if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tts.society_id', $filterData['society_id']);
			} else {
				$builder->where('tts.society_id', $filterData['society_id']);
			}
		}

		if(isset($filterData['start'])){
			if($filterData['start'] != '-1'){
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if(isset($filterData['is_active'])){
			$builder->where('tts.is_active', $filterData['is_active']);
		}
		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();
			$builder->like('tts.time_slot_name', $filterData['search'], 'both');
			$builder->groupEnd();
		}

		$builder->orderBy('tts.time_slot_name','ASC');

		$builder->groupBy('tts.time_slot_id');
		if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		}else{
			$queryData = $builder->get()->getRowArray();
		}
		//lastQuery();

		return $queryData;
	}

	public function deleteRecord($timeSlotId)
	{
		$builder = $this->db->table('tbl_time_slot');
        $timeSlotIdArray = is_array($timeSlotId) ? $timeSlotId : array($timeSlotId);
        $builder->whereIn('time_slot_id', $timeSlotIdArray);
        $builder->delete();
		if ($this->db->affectedRows()) {
			if(!empty($timeSlotId)){
				foreach($timeSlotId as $documentElement){
					$deleteDataArray['module'] = 'Time Slot';
					$deleteDataArray['activity'] = "Time Slot Deleted";
					$deleteDataArray['module_id'] = $documentElement;
					logActivity('Time Slot Deleted [TimeSlotID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Time Slot',$documentElement,json_encode($deleteDataArray),'','Time Slot',$documentElement);
				}
			}
			return true;
		}
		return false;
	}

	function getTimeSlot($filterData = array())
	{
		if(isset($filterData['page']) && $filterData['page'] != 1) {
			$filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
		}

		// $builder->start_cache();
		$builder = $this->db->table('tbl_time_slot as tts');
		$builder->select("tts.time_slot_id as id,tts.time_slot_name as text");
		
		$builder->where("tts.is_active", 1);
		if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
			$builder->groupStart();
			$builder->like("tts.time_slot_name", $filterData['filter_param'], 'both');
			$builder->groupEnd();
		}
		accessFilter($builder, array("society" => "tts.society_id"));
		// $this->db->stop_cache();
		$totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
		$query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
		// $this->db->flush_cache();
		return json_encode($result);
	}
}
?>
