<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class TagModel extends BaseModel
{

    public function getTagData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_tag as tt');
        $builder->select("tt.*");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tt.updated_by AND tupdate.society_id = tt.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tt.created_by AND tcreate.society_id = tt.society_id","left");

        if (isset($filterData['tag_id']) && !empty($filterData['tag_id'])) {
            if (is_array($filterData['tag_id'])) {
                $builder->whereIn('tt.tag_id', $filterData['tag_id']);
            } else {
                $builder->where('tt.tag_id', $filterData['tag_id']);
            }
        }

        if (isset($filterData['tag_type']) && !empty($filterData['tag_type'])) {
            if (is_array($filterData['tag_type'])) {
                $builder->whereIn('tt.tag_type', $filterData['tag_type']);
            } else {
                $builder->where('tt.tag_type', $filterData['tag_type']);
            }
        }

        if (isset($filterData['tag_no']) && !empty($filterData['tag_no'])) {
            if (is_array($filterData['tag_no'])) {
                $builder->whereIn('tt.tag_no', $filterData['tag_no']);
            } else {
                $builder->where('tt.tag_no', $filterData['tag_no']);
            }
        }

        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tt.society_id', $filterData['society_id']);
            } else {
                $builder->where('tt.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['tag_id_not']) && !empty($filterData['tag_id_not'])) {
            if (is_array($filterData['tag_id_not'])) {
                $builder->whereNotIn('tt.tag_id', $filterData['tag_id_not']);
            } else {
                $builder->where('tt.tag_id !=', $filterData['tag_id_not']);
            }
        }
        
        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if(isset($filterData['is_active'])){
            $builder->where('tt.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if (isset($filterData['search']) && $filterData['search'] != '') {
            $builder->groupStart();
            $builder->like('tag_no', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tt.tag_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($tagId)
    {
        $builder = $this->db->table('tbl_tag');
        $tagIdArray = is_array($tagId) ? $tagId : array($tagId);
        $builder->whereIn('tag_id', $tagIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($tagId)){
                foreach($tagId as $tag){
                    $deleteDataArray['module'] = 'Tag';
                    $deleteDataArray['activity'] = "Tag Deleted";
                    $deleteDataArray['module_id'] = $tag;
                    logActivity('Tag Deleted [TagID: ' . $tag . ']',$this->ionAuth->getUserId(),'Tag',$tag,json_encode($deleteDataArray),'','Tag',$tag);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getTag($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_tag as tg');
        //$builder->startCache();
        $builder->select("tg.tag_id as id,tg.tag_no as text");

        if (isset($filterData['tag_id']) && !empty($filterData['tag_id'])) {
            if (is_array($filterData['tag_id'])) {
                $builder->whereIn('tg.tag_id', $filterData['tag_id']);
            } else {
                $builder->where('tg.tag_id', $filterData['tag_id']);
            }
        }

        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tg.society_id', $filterData['society_id']);
            } else {
                $builder->where('tg.society_id', $filterData['society_id']);
            }
        }

        accessFilter($builder, array("society" => "tg.society_id"));
        $builder->groupBy("tg.tag_id");
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("tg.tag_no", $filterData['filter_param'], 'both');
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tg.is_active', $filterData['is_active']);
        }
        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }
}