<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class SubLedgerModel extends BaseModel
{

	public function getSubLedgerData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_sub_ledger as tsl');
        $builder->select("tsl.*,tsloc.society_name");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tsl.updated_by AND tupdate.society_id = tsl.society_id","left");
        $builder->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tsl.created_by AND tcreate.society_id = tsl.society_id","left");
        $builder->join(MASTER_DB.".tbl_society as tsloc","tsloc.society_id = tsl.society_id","left");
        // $builder->join("tbl_sub_ledger_guard as tslg","tslg.sub_ledger_id = tsl.sub_ledger_id","left");

        if (isset($filterData['sub_ledger_id']) && !empty($filterData['sub_ledger_id'])) {
            if (is_array($filterData['sub_ledger_id'])) {
                $builder->whereIn('tsl.sub_ledger_id', $filterData['sub_ledger_id']);
            } else {
                $builder->where('tsl.sub_ledger_id', $filterData['sub_ledger_id']);
            }
        }
        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tsl.society_id', $filterData['society_id']);
            } else {
                $builder->where('tsl.society_id', $filterData['society_id']);
            }
        }
        if (isset($filterData['sub_ledger_code']) && !empty($filterData['sub_ledger_code'])) {
            if (is_array($filterData['sub_ledger_code'])) {
                $builder->whereIn('tsl.sub_ledger_code', $filterData['sub_ledger_code']);
            } else {
                $builder->where('tsl.sub_ledger_code', $filterData['sub_ledger_code']);
            }
        }
        if (isset($filterData['sub_ledger_name']) && !empty($filterData['sub_ledger_name'])) {
            if (is_array($filterData['sub_ledger_name'])) {
                $builder->whereIn('tsl.sub_ledger_name', $filterData['sub_ledger_name']);
            } else {
                $builder->where('tsl.sub_ledger_name', $filterData['sub_ledger_name']);
            }
        }

        if (isset($filterData['start'])) {
            if ($filterData['start'] != '1') {
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
            $builder->where('tsl.is_active', $filterData['is_active']);
        }


        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('tsl.sub_ledger_code', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tsl.sub_ledger_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
	

	public function deleteRecord($subLedgerId)
    {
        $subLedgerIdArray = is_array($subLedgerId) ? $subLedgerId : array($subLedgerId);
        $builder = $this->db->table('tbl_sub_ledger');
        $builder->whereIn('sub_ledger_id', $subLedgerIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($subLedgerId)){
                foreach($subLedgerId as $documentElement){
                    $deleteDataArray['module'] = 'SubLedger';
                    $deleteDataArray['activity'] = "SubLedger Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('SubLedger Deleted [SubLedgerID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'SubLedger',$documentElement,json_encode($deleteDataArray),'','SubLedger',$documentElement);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

	function getSubLedger($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_sub_ledger as tsl');
        //$builder->startCache();
        $builder->select("tsl.sub_ledger_id as id,COALESCE(tsl.sub_ledger_name,'')  as text");
        if(isset($filterData['sub_ledger_id']) && !empty($filterData['sub_ledger_id'])) {
            if (is_array($filterData['sub_ledger_id'])) {
                $builder->whereIn('tsl.sub_ledger_id', $filterData['sub_ledger_id']);
            } else {
                $builder->where('tsl.sub_ledger_id', $filterData['sub_ledger_id']);
            }
        }
        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tsl.society_id', $filterData['society_id']);
            } else {
                $builder->where('tsl.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tsl.sub_ledger_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tsl.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    public function getSubLedgerLedgerData($filterData  = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_ledger_sub_ledger as tslsl');
        $builder->select("tslsl.ledger_sub_ledger_id,tslsl.ledger_id");
        $builder->select("concat(COALESCE(tsl.ledger_code,''),'-',COALESCE(tsl.ledger_name,'')) as ledger_code_name");
        $builder->join('tbl_ledger tsl', 'tsl.ledger_id = tslsl.ledger_id', 'left');

        if(isset($filterData['sub_ledger_id']) && !empty($filterData['sub_ledger_id'])) {
            if (is_array($filterData['sub_ledger_id'])) {
                $builder->whereIn('tslsl.sub_ledger_id', $filterData['sub_ledger_id']);
            } else {
                $builder->where('tslsl.sub_ledger_id', $filterData['sub_ledger_id']);
            }
        }

        // if (isset($filterData['sub_ledger_image_id']) && $filterData['sub_ledger_image_id'] != '') {
        //     $builder->where("tmi.sub_ledger_image_id", $filterData['sub_ledger_image_id']);
        // }

        $builder->orderBy("tslsl.sub_ledger_id");

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }

        return $query;
    }

    public function deleteLedgerRecord($subLedgerId){
        $builder = $this->db->table('tbl_ledger_sub_ledger');
        $subLedgerIdArray = is_array($subLedgerId) ? $subLedgerId : array($subLedgerId);
        $builder->whereIn('sub_ledger_id', $subLedgerIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

}
?>
